/*
 * Please see wp-cookie-allow.php for more details.
 *
 * @author $Author: Vincent Weber <weepie-plugins@outlook.com> $
 * @since 2.0
 */

var WPIE = (function(wpie) {
	""; // fix for yuicompressor
	"use strict";

	wpie.setKookie = function(name, value, days, domain, path, secure) {
		var expires = "";
		if (days) {
			var date = new Date();
			date.setTime(date.getTime()+(days*24*60*60*1000));
			expires = "; expires="+date.toGMTString();
		}

		var path = ('undefined' !== typeof path) ? "; path="+path : "; path=/";
		var domain = ('undefined' !== typeof domain && '' !== domain) ? "; domain="+domain : "";
		var secure = ('boolean' === typeof secure && secure) ? "; secure" : "";

		var cookieStr = name+"="+value+expires+path+domain+secure;
		document.cookie = cookieStr;
	};

	wpie.readKookie  = function(name) {
		var nameEQ = name + "=";
		var ca = document.cookie.split(';');
		for(var i=0;i < ca.length;i++) {
			var c = ca[i];
			while (c.charAt(0)==' ') c = c.substring(1,c.length);
			if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
		}
		return null;
	};

	wpie.eraseKookie  = function(name, domain, path) {
		wpie.setKookie (name, "", -1, domain, path);
	};

	/**
	 * Get difference of two arrays
	 *
	 * @returns array
	 */
	wpie.arrDiff = function(a1, a2) {
	  var a=[], diff=[], i, k;

	  for(i=0; i<a1.length; i++) {
	    a[a1[i]]=true;
	  }

	  for(i=0;i<a2.length;i++) {
	    if(a[a2[i]]) {
	    	delete a[a2[i]];
	    } else {
	    	a[a2[i]]=true;
	    }
	  }

	  for(k in a) {
	    diff.push(k);
	  }

	  return diff;
	};

	/**
	 * Remove a query var from a URL
	 *
	 * @returns string
	 */
	wpie.removeQueryVar = function(url, name, value) {
		if(null == url || 'string' !== typeof url) {
			throw new Error('Could not add parameter to URL. The URL is not valid.');
		}
		if(null == name || 'string' !== typeof name) {
			throw new Error('Could not add parameter to URL. The parameter name is not valid.');
		}
		if('undefined' === typeof value) {
			throw new Error('Could not add parameter to URL. The parameter value is undefined.');
		}

		var pat = new RegExp(name, 'i');
		if( pat.test(url) ) {
			url = url.replace('?'+name+'='+value+'&', '?');
			url = url.replace('?'+name+'='+value, '');
			url = url.replace('&'+name+'='+value, '');
		}
		return url;
	};

	/**
	 * Log wrapper function
	 *
	 * @returns void
	 */
	wpie.log = function() {
		if(null != console && null != console.log) {
			if(0 < arguments.length) {
				[].unshift.call(arguments, 'WeePie log: ');
				console.log.apply(this, arguments);
			}
		}
	};

	/**
	 * Alert wrapper function
	 *
	 * @returns void
	 */
	wpie.alert = function(msg) {
		alert('WeePie says: '+msg)
	};

	wpie.getNameSpaceData = function() {
		if(!window.wpieData) {
			throw new Error('Missing global param: wpieData');
		}
		if('' == wpieData['curr_sett_ns'] || 'string' !== typeof wpieData['curr_sett_ns']) {
			throw new Error('Namespace is not valid, value found: '+wpieData['curr_sett_ns']);
		}

		// namespace dependent global plugin data
		var data = {
			currNsData: window[wpieData.curr_sett_ns + 'Data'],
			currNsDatal10n: window[wpieData.curr_sett_ns + 'Datal10n']
		}

		return data;
	};

	wpie.getAjaxArgs = function(action, data, ns) {
		var nsData = false,
			currNsData,
			namespaceAction,
			args = {};

		if(ns && !window.wpieData) {
			currNsData = window[ns + 'Data'];
		} else {
			nsData = wpie.getNameSpaceData();
			currNsData = nsData.currNsData;
		}

		namespaceAction = currNsData.ns + '_action';

		args['action'] = 'wpie-action';
		args[namespaceAction] = action;
		args['data'] = data;
		args['nonce'] = currNsData.nonce;
		args['ns'] = currNsData.ns;

		return args;
	};

	wpie.checkForRequiredProps = function(props, obj, soft, objName) {
        if(null == obj) {
            throw new Error('missing global param: ' + objName);
        }

        if('undefined' === typeof soft) {
            soft = false;
        }

        for(var i=0; i<props.length; i++) {
            if(null == obj[props[i]]) {
                if(!soft) {
                    throw new Error('missing property: ' + props[i] + ' for ' + objName);
                } else {
                    return false;
                }
            }
        }
    };

	return wpie;

})(WPIE || {});