<?php
/**
 * Please see weepie-framework.php for more details.
 */

namespace WpieFw\Framework\Logger;

use WpieFw\Framework\Logger\WpieLoggerInterface;

if( ! defined( 'ABSPATH' ) ) exit;

class WpieErrorLogger implements WpieLoggerInterface
{
	/**
	 * {@inheritDoc}
	 * @see WpieLoggerInterface::log()
	 */
	public static function logMessage( $message = '', $whenLoggedIn = false )
	{
		if( $whenLoggedIn ) {
			if( function_exists( 'is_user_logged_in' ) && !is_user_logged_in() ) {
				return;
			}
		}

		if( defined( 'WP_DEBUG' ) && !WP_DEBUG ) {
			return;
		}

		if( '' !== $message ) {
			error_log( 'WeePie Framework: ' . $message );
		}
	}
}