<?php

namespace WpieFw\Framework\Patterns\Resolver;

if( ! defined( 'ABSPATH' ) ) exit;

/**
 * @author WeePie Plugins
 *
 */
interface WpieFilesResolverInterface
{
	/**
	 * Get stored files
	 *
	 * @return array
	 */
	public function getFiles();

	/**
	 * Store stored files
	 *
	 * @param array $files
	 */
	public function persistFiles( array $files );

	/**
	 * Delete stored settings files
	 *
	 * @return boolean
	 */
	public function deleteFiles();
}