<?php

namespace WpieFw\Modules\Iterator;

use WpieFw\Wpie\WpieGlobals;
use WpieFw\Modules\Iterator\WpieModuleInterface;
use WpieFw\Settings\WpieSettingsProcessor;
use WpieFw\Modules\Iterator\WpieModulesCollection;

if( ! defined( 'ABSPATH' ) ) exit;

/**
 * @author WeePie Plugins
 *
 */
abstract class WpieModule implements WpieModuleInterface
{
	/**
	 * Flag if Module is active.
	 *
	 * If false, module is not loaded
	 *
	 * @since 1.0
	 *
	 * @var bool
	 */
	protected $active = true;

	/**
	 * The loading priority for the Module
	 *
	 * 1 will load first, 2 after etc.
	 *
	 * @since 0.1
	 *
	 * @var int
	 */
	protected $priority = 10;

	/**
	 * The index for the Module
	 *
	 * @since 0.1
	 *
	 * @var string
	 */
	protected $index;

	/**
	 * Absolute path to the Module
	 *
	 * @since 0.1
	 *
	 * @var string
	 */
	protected $path;

	/**
	 * Data that is passes to the Module
	 *
	 * @since 1.0
	 *
	 * @var array
	 */
	protected $vars;

	/**
	 * Instance of WpieGlobals class
	 *
	 * @since 1.4.0
	 *
	 * @var WpieGlobals
	 */
	protected $globals;

	/**
	 * Instance of WpieSettingsProcessor class
	 *
	 * @since 1.4.0
	 *
	 * @var WpieSettingsProcessor
	 */
	protected $settingsProcessor;

	/**
	 * Set class member $status
	 *
	 * @access public
	 *
	 * @param bool $status
	 *
	 * @since 1.0
	 */
	public function setActive( $status )
	{
		$this->active = $status;
	}

	/**
	 * Set class member $priority
	 *
	 * @access public
	 *
	 * @param int $priority
	 *
	 * @since 0.1
	 */
	public function setPriority( $priority )
	{
		$this->priority = $priority;
	}

	/**
	 * Set class member $index
	 *
	 * @access public
	 *
	 * @param string $index
	 *
	 * @since 0.1
	 */
	public function setIndex( $index )
	{
		$this->index = $index;
	}

	/**
	 * Set class member $path
	 *
	 * @access public
	 *
	 * @param string $path
	 *
	 * @since 0.1
	 */
	public function setPath( $path )
	{
		$this->path = $path;
	}

	/**
	 * Set class member $vars
	 *
	 * @access public
	 *
	 * @param array $vars
	 *
	 * @since 1.0
	 */
	public function setVars( $vars )
	{
		$this->vars = $vars;
	}

	/**
	 * Set the module ancestors
	 *
	 * @param array $ancestors
	 *
	 * @since 2.0
	 */
	public function setAncestors( array $ancestors )
	{
		$this->ancestors = $ancestors;
	}

	/**
	 * Set class member $globals
	 *
	 * @param WpieGlobals $globals
	 *
	 * @since 1.4.0
	 */
	public function setGlobals( WpieGlobals $globals )
	{
		$this->globals = $globals;
	}

	/**
	 * @param WpieSettingsProcessor $processor
	 */
	public function setSettingsProcessor( WpieSettingsProcessor $processor )
	{
		$this->settingsProcessor = $processor;
	}

	/**
	 * Get class member $active
	 *
	 * @access public
	 *
	 * @since 1.0
	 *
	 * @return bool
	 */
	public function getActive()
	{
		return $this->active;
	}

	/**
	 * Get class member $priority
	 *
	 * @access public
	 *
	 * @since 0.1
	 *
	 * @return int
	 */
	public function getPriority()
	{
		return $this->priority;
	}

	/**
	 * Get class member $index
	 *
	 * @access public
	 *
	 * @since 0.1
	 *
	 * @return string
	 */
	public function getIndex()
	{
		return $this->index;
	}

	/**
	 * Get class member $path
	 *
	 * @access public
	 *
	 * @since 0.1
	 *
	 * @return string
	 */
	public function getPath()
	{
		return $this->path;
	}

	/**
	 * Get class member $vars
	 *
	 * @access public
	 *
	 * @since 1.0
	 *
	 * @return array
	 */
	public function getVars()
	{
		return $this->vars;
	}

	/**
	 * Get a module from the collection
	 *
	 * @param string $offset
	 *
	 * @uses WpieModulesCollection::get()
	 *
	 * @return WpieModule|boolean
	 */
	protected function getModule( $offset = '' )
	{
		return \WpieFw\modules\WpieModuleProcessor::getModule( $this->globals->nameSpace, $offset );
	}

	protected function notice( string $msg = '', string $type = 'error', string $setting = '', bool $once = false  )
	{
	    \WpieFw\Notices\WpieNotices::add( $this->globals->nameSpace, $msg, $type, $setting, $once );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Modules\Iterator\WpieModuleInterface::activating()
	 */
	public function activating() {}


	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Modules\Iterator\WpieModuleInterface::start()
	 */
	public function start() {}
}