<?php
/**
 * Please see weepie-framework.php for more details.
 */

namespace WpieFw\Multilang\Plugins;

use WpieFw\Wpie\WpieGlobals;

if( ! defined( 'ABSPATH' ) ) exit;

/**
 * WpieMultilangPluginInterface interface
 *
 * @author $Author: Vincent Weber <weepie-plugins@outlook.com> $
 * @since 1.2
 */
interface WpieMultilangPluginInterface
{
	/**
	 * Determine if plugin is activated
	 *
	 * @access	public
	 *
	 * @since 	1.2
	 *
	 * @return	bool
	 */
	public function isActive();

	/**
	 * Determine if plugin is ready (configured)
	 *
	 * This is optional
	 *
	 * @access	public
	 *
	 * @since 	1.2
	 *
	 * @return	bool
	 */
	public function isReady();

	/**
	 * Get the default language code
	 *
	 * @access	public
	 *
	 * @since 	1.2
	 *
	 * @return	string
	 */
	public function getDefaultCode();

	/**
	 * Get the default language locale
	 *
	 * @access	public
	 *
	 * @since 	1.2
	 *
	 * @return	string
	 */
	public function getDefaultLocale();

	/**
	 * Get the active language code
	 *
	 * @access	public
	 *
	 * @since 	1.2
	 *
	 * @return	string
	 */
	public function getActiveCode();

	/**
	 * Get the active language locale
	 *
	 * @access	public
	 *
	 * @since 	1.2
	 *
	 * @return	string
	 */
	public function getActiveLocale();

	/**
	 * Get all language codes
	 *
	 * @access	public
	 *
	 * @since 	1.2
	 *
	 * @return	string
	 */
	public function getAllCodes();

	/**
	 * Get all language locales
	 *
	 * This array should be indexed with the language codes
	 *
	 * @access	public
	 *
	 * @since 	1.2
	 *
	 * @return	string
	 */
	public function getAllLocales();

	/**
	 * Get all locales indexed by language code
	 *
	 * @see		self::getAllLocales()
	 *
	 * @access	public
	 *
	 * @since 	1.2
	 *
	 * @return	array
	 */
	public function getLangs();

	/**
	 * Get all language params (needed for the processor)
	 *
	 * @access	public
	 *
	 * @since 	1.2
	 *
	 * @return	string
	 */
	public function getParams();

	/**
	 * Switch to another language
	 *
	 * @param string $code the language code (like "en" for en_US)
	 *
	 * @since 2.0
	 */
	public function switchLanguage( $code = '' );

	/**
	 * Add hooks to perform when plugin is ready and on settings page (optional)
	 *
	 * @since 2.0
	 */
	public function doSettingsPageHooks( WpieGlobals $globals );
}