<?php

namespace WpieFw\Settings\Parser;

use WpieFw\Files\WpieFile;

if( ! defined( 'ABSPATH' ) ) exit;

interface WpieSettingsParserInterface
{
	/**
	 * Get the file
	 *
	 * @return WpieFile
	 */
	public function getFile();

	/**
	 * Get the file contents
	 *
	 * @return string
	 */
	public function getContents();

	/**
	 * Parse settings file
	 *
	 * @param WpieFile $file
	 *
	 * @return string
	 */
	public function parseFile( WpieFile $file );

	/**
	 * Load the settings file
	 *
	 * @param string content
	 */
	public function load( $content = '' );

	/**
	 * Parse the settings file
	 */
	public function parse();
}