<?php

namespace WpieFw\Settings\Resolver;

use WpieFw\Settings\Definition\WpieSettingsDefinition;
use WpieFw\Framework\Patterns\Resolver\WpieWpOptionsResolver;
use WpieFw\Framework\Patterns\Resolver\WpieFilesResolverInterface;
use WpieFw\Settings\Resolver\WpieSettingValuesResolverInterface;
use WpieFw\Exceptions\WpieInvalidArgumentException;

if( ! defined( 'ABSPATH' ) ) exit;

/**
 * @author WeePie Plugins
 *
 * @todo move validation of $idx (InvalidArgumentException) to private method or other layer
 *
 */
final class WpieSettingValuesWpOptionsResolver extends WpieWpOptionsResolver implements WpieSettingValuesResolverInterface
{
	/**
	 * Constructor
	 *
	 * @param WpieSettingsDefinition $defenitions
	 */
	public function __construct( WpieSettingsDefinition $definitions )
	{
		parent::__construct( $definitions );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Framework\Patterns\Resolver\WpieFilesResolverInterface::getFiles()
	 */
	public function getFiles()
	{
		$name = $this->getValueForShortcut( 'files' );

		return $this->getWpOption( $name, [] );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Settings\Resolver\WpieSettingValuesResolverInterface::getArray()
	 */
	public function getArray( $idx = '' )
	{
		$idx = trim( $idx );

		if( '' === $idx ) {
			throw new WpieInvalidArgumentException( 'Could not get setting fields array. Index is empty' );
		}

		$name = $this->getValueForShortcut( 'array', [ 'IDX' => $idx ] );

		return $this->getWpOption( $name, [] );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Settings\Resolver\WpieSettingValuesResolverInterface::getDefault()
	 */
	public function getDefault()
	{
		$name = $this->getValueForShortcut( 'default' );

		return $this->getWpOption( $name, null );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Settings\Resolver\WpieSettingValuesResolverInterface::getSetting()
	 */
	public function getSetting( $idx = '' )
	{
		$idx = trim( $idx );

		if( '' === $idx ) {
			throw new WpieInvalidArgumentException( 'Could not get setting. Index is empty' );
		}

		$name = $this->getValueForShortcut( 'setting', [ 'IDX' => $idx ] );

		return $this->getWpOption( $name, [] );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Settings\Resolver\WpieSettingValuesResolverInterface::getSettingTmp()
	 */
	public function getSettingTmp( $idx = '' )
	{
		$idx = trim( $idx );

		if( '' === $idx ) {
			throw new WpieInvalidArgumentException( 'Could not get temporary setting. Index is empty' );
		}

		$name = $this->getValueForShortcut( 'setting_tmp', [ 'IDX' => $idx ] );

		return $this->getWpOption( $name, [] );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Framework\Patterns\Resolver\WpieFilesResolverInterface::persistFiles()
	 */
	public function persistFiles( array $files )
	{
		$name = $this->getValueForShortcut( 'files' );

		return $this->addWpOption( $name, $files );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Settings\Resolver\WpieSettingValuesResolverInterface::persistArray()
	 */
	public function persistArray( string $idx, array $fields )
	{
		$idx = trim( $idx );

		if( '' === $idx ) {
			throw new WpieInvalidArgumentException( 'Could not persist setting fields array. Index is empty' );
		}

		$name = $this->getValueForShortcut( 'array', [ 'IDX' => $idx ] );

		return $this->addWpOption( $name, $fields );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Settings\Resolver\WpieSettingValuesResolverInterface::persistDefault()
	 */
	public function persistDefault( $value = '' )
	{
		$name = $this->getValueForShortcut( 'default' );

		return $this->addWpOption( $name, $value );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Settings\Resolver\WpieSettingValuesResolverInterface::persistSetting()
	 */
	public function persistSetting( string $idx, array $setting )
	{
		$idx = trim( $idx );

		if( '' === $idx ) {
			throw new WpieInvalidArgumentException( 'Could not persist setting. Index is empty' );
		}

		$name = $this->getValueForShortcut( 'setting', [ 'IDX' => $idx ] );

		return $this->addWpOption( $name, $setting );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Settings\Resolver\WpieSettingValuesResolverInterface::persistSettingTmp()
	 */
	public function persistSettingTmp( $idx = '' )
	{
		$idx = trim( $idx );

		if( '' === $idx ) {
			throw new WpieInvalidArgumentException( 'Could not persist temporary setting. Index is empty' );
		}

		$name = $this->getValueForShortcut( 'setting_tmp', [ 'IDX' => $idx ] );
		$setting = $this->getSetting( $idx );

		return $this->addWpOption( $name, $setting );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Framework\Patterns\Resolver\WpieFilesResolverInterface::deleteFiles()
	 */
	public function deleteFiles()
	{
		$name = $this->getValueForShortcut( 'files' );

		return $this->deleteWpOption( $name );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Settings\Resolver\WpieSettingValuesResolverInterface::deleteArray()
	 */
	public function deleteArray( $idx = '' )
	{
		$idx = trim( $idx );

		if( '' === $idx ) {
			throw new WpieInvalidArgumentException( 'Could not delete setting fields array. Index is empty' );
		}

		$name = $this->getValueForShortcut( 'array', [ 'IDX' => $idx ] );

		return $this->deleteWpOption( $name );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Settings\Resolver\WpieSettingValuesResolverInterface::deleteDefault()
	 */
	public function deleteDefault()
	{
		$name = $this->getValueForShortcut( 'default' );

		return $this->deleteWpOption( $name );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Settings\Resolver\WpieSettingValuesResolverInterface::deleteSetting()
	 */
	public function deleteSetting( $idx = '' )
	{
		$idx = trim( $idx );

		if( '' === $idx ) {
			throw new WpieInvalidArgumentException( 'Could not delete setting. Index is empty' );
		}

		$name = $this->getValueForShortcut( 'setting', [ 'IDX' => $idx ] );

		return $this->deleteWpOption( $name );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Settings\Resolver\WpieSettingValuesResolverInterface::deleteSettingTmp()
	 */
	public function deleteSettingTmp( $idx = '' )
	{
		$idx = trim( $idx );

		if( '' === $idx ) {
			throw new WpieInvalidArgumentException( 'Could not delete temporary setting. Index is empty' );
		}

		$name = $this->getValueForShortcut( 'setting_tmp', [ 'IDX' => $idx ] );

		return $this->deleteWpOption( $name );
	}
}