<?php

namespace WpieFw\Settings;

use WpieFw\Files\WpieFile;
use WpieFw\Settings\WpieSettingsValues;
use WpieFw\Settings\Iterator\WpieSetting;
use WpieFw\Multilang\WpieMultilangProcessor;

if( ! defined( 'ABSPATH' ) ) exit;

interface WpieSettingsFactoryInterface
{
	/**
	 * Create a setting instance
	 *
	 * @param string $type
	 * @param WpieFile $file
	 * @param WpieSettingsValues $values
	 *
	 * @return WpieSetting
	 */
	public function create( string $type, WpieFile $file, WpieSettingsValues $values );

	/**
	 * Create a setting instance with support for multilang
	 *
	 * @param string $type
	 * @param WpieFile $file
	 * @param WpieSettingsValues $values
	 * @param WpieMultilangProcessor $multilangProcessor
	 *
	 * @return \WpieFw\Settings\Iterator\WpieSetting
	 */
	public function createForMultilang( string $type, WpieFile $file, WpieSettingsValues $values, WpieMultilangProcessor $multilangProcessor );
}