<?php

namespace WpieFw\Templates\Files;

use WpieFw\Files\WpieFileFinder;
use WpieFw\Files\WpieFile;
use WpieFw\Exceptions\WpieInvalidArgumentException;

if( ! defined( 'ABSPATH' ) ) exit;

/**
 * @author WeePie Plugins
 *
 * It Finds template files and creates WpieFile instances for the founded files.
 */
final class WpieTemplatesFileFinder extends WpieFileFinder
{
	/**
	 * Constructor
	 *
	 * @param string $path
	 * @param string $extension
	 * @param string $prefix
	 * @param string $fileName
	 * @param bool $recursive
	 * @param \FilesystemIterator $iterator
	 *
	 * @uses parent::__construct()
	 */
	public function __construct( $path = '', $extension = '', $prefix = '', $fileName = '', $recursive = true, $iterator = null )
	{
		$fileName = trim( $fileName );

		if( '' === $fileName ) {
			throw new WpieInvalidArgumentException( 'input parameter $fileName is empty.' );
		}

		parent::__construct( $path, $extension, $prefix, $fileName, false, $iterator );
	}

	/**
	 * Create new file instance
	 *
	 * @param \SplFileInfo $file
	 * @return WpieFile
	 */
	protected function createFileInstance( \SplFileInfo $file )
	{
		return new WpieFile( $file->getRealPath(), $this->prefix );
	}

	/**
	 * Get the templats file name
	 *
	 * @return string
	 */
	public function getFileName()
	{
		return $this->fileName;
	}
}