<?php
/**
 * Please see weepie-framework.php for more details.
 */

namespace WpieFw\Wpie;

use WpieFw\Framework\Patterns\Iterator\WpieCollection;

if( ! defined( 'ABSPATH' ) ) exit;

/**
 * Final class WpieGlobals
 *
 * @author $Author: Vincent Weber <weepie-plugins@outlook.com> $
 *
 * @since 0.1
 */
final class WpieGlobals extends WpieCollection
{
	/**
	 * The Plugins namespace
	 *
	 * @since 1.0
	 *
	 * @var string
	 */
	public $nameSpace;

	/**
	 * Constructor
	 *
	 * Calls parent class WpieBaseSettings
	 *
	 * @access public
	 *
	 * @param string $nameSpace
	 *
	 * @since 0.1
	 */
	public function __construct( $nameSpace = '' )
	{
		$this->nameSpace = $nameSpace;
	}

	/**
	 * Set the plugin globals
	 *
	 * @return WpieGlobals
	 */
	public function setGlobals()
	{
		// WeePie Framework URL's and Paths
		$wfPluginFolderRel = trim( plugin_basename( dirname( $this->get( 'fileWpieFw' ) ) ), '\/' );
		$wfPluginUri = plugins_url( '/'.$wfPluginFolderRel );

		$pluginBase = plugin_basename( $this->get( 'file' ) );
		$pluginDirName = ( preg_match( '/[^\/]+/', $pluginBase, $m ) ) ? $m[0] : '';

		$this->set( 'wfPluginFile', $this->get( 'fileWpieFw' ) );
		$this->set( 'wfPluginFolderRel', $wfPluginFolderRel );
		$this->set( 'wfPluginPath', WP_PLUGIN_DIR . '/'.$wfPluginFolderRel );
		$this->set( 'wfAssetsUri', $wfPluginUri . '/assets' );
		$this->set( 'wfImgUri',  $this->get( 'wfAssetsUri' ) . '/img' );
		$this->set( 'wfJsUri',  $this->get( 'wfAssetsUri' ) . '/js' );
		$this->set( 'wfCssUri',  $this->get( 'wfAssetsUri' ) . '/css' );
		$this->set( 'wfTemplUri',  $wfPluginUri . '/templates' );
		$this->set( 'wfTemplPath',  $this->get( 'wfPluginPath' ) . '/templates' );
		$this->set( 'wfPathLangRel', $wfPluginFolderRel.'/lang' );

		// @todo rename pluginPathFile to pluginFile?
		$this->set( 'pluginPathFile', $this->get( 'file' ) );
		$this->set( 'pluginNameSpace', $this->nameSpace );
		$this->set( 'pluginDirName', $pluginDirName );
		$this->set( 'pluginFile', $pluginBase );
		$this->set( 'pluginFileBase', basename( $this->get( 'pluginFile' ), '.php' ) );
		$this->set( 'pluginUri', plugins_url( '/' . $pluginDirName ) );
		$this->set( 'pluginPath', WP_PLUGIN_DIR . '/' . $pluginDirName );
		$this->set( 'pluginPathLangRel', $this->get( 'pluginDirName' ) . '/lang' );

		$this->set( 'settingsPath',  $this->get( 'pluginPath' ) . '/settings' );
		$this->set( 'settingsUri',  $this->get( 'pluginUri' ) . '/settings' );
		$this->set( 'templatePath',  $this->get( 'pluginPath' ) . '/templates' );
		$this->set( 'assetsPath',  $this->get( 'pluginPath' ) . '/assets' );
		$this->set( 'templatePathTheme', [ get_stylesheet_directory(), get_stylesheet_directory().'/'.$this->nameSpace ] );
		$this->set( 'modulePath',  $this->get( 'pluginPath' ) . '/modules' );
		$this->set( 'moduleUri',  $this->get( 'pluginUri' ) . '/modules' );
		$this->set( 'assetsUri',  $this->get( 'pluginUri' ) . '/assets' );
		$this->set( 'cssUri',  $this->get( 'assetsUri' ) . '/css' );
		$this->set( 'jsUri',  $this->get( 'assetsUri' ) . '/js' );
		$this->set( 'imgUri',  $this->get( 'assetsUri' ) . '/img' );
		$this->set( 'jsNamespace', $this->nameSpace.'Data' );
		$this->set( 'locale', ( '' !== ( $locale = get_locale() ) ) ? $locale : 'en_US' );
		$this->set( 'pagenow', ( isset( $GLOBALS['pagenow'] ) ) ? $GLOBALS['pagenow'] : '' );

		$this->set( 'optionLanguages', 'wpie_languages' );
		$this->set( 'optionModules', $this->nameSpace . '_modules' );
		$this->set( 'optionSettings', $this->nameSpace . '_settings' );
		$this->set( 'optionSettingDefault', $this->nameSpace . '_setting_default' );
		$this->set( 'optionActivating', 'wpie_activating_' . $this->nameSpace );

		return $this;
	}
}