<?php
/**
 * Template for Wpie Auto Update info
 *
 * @since 2.0
 */
if( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="wrap">
	<h1><?php printf( __( 'Auto updating the %s plugin', 'weepie' ), $plugin_name ) ?></h1>
	<img width="160" height="100" src="<?php echo $logo_uri ?>" />
	<p><?php printf( __( 'Our %s plugin uses the %s to receive new updates.', 'weepie' ),
			$plugin_name,
			'<a title="'.__( 'Visit the Envato Market plugin page', 'weepie' ).'" href="'.$envato_market->url.'" target="_blank">Envato Market plugin</a>'
			) ?></p>
	<p><?php printf( __( 'If you want this, you will need to %s , install and activate the Envato Market plugin.', 'weepie' ),
			'<a title="'.__( 'Download the Envato Market plugin ZIP file', 'weepie' )	.'" href="'.$envato_market->downloadUrl	.'">download</a>'
			) ?></p>

	<div class="wpie-app-form">
	<p><?php echo WpieFw\Helpers\WpieFormHelper::formField(
			'linkbutton',
			'',
			'',
			'',
			[
				'class' => 'btn',
				'href' => $envato_market->url,
				'target' => '_blank'
			],
			__( 'More info', 'weepie' ) ) ?></p>

	<p><?php echo WpieFw\Helpers\WpieFormHelper::formField(
			'linkbutton',
			'',
			'',
			'',
			[
				'class' => 'btn',
				'href' => $envato_market->downloadUrl
			],
			__( 'Download now', 'weepie' ) ) ?></p>
	</div>
</div>