<?php
/**
 * Template for export form
 *
 * @since 2.0.5
 */

use WpieFw\Helpers\WpieFormHelper;

if( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="wrap">
	<h1><?php printf( __( 'Your exported settings for: %s', 'weepie' ), $plugin_name ) ?></h1>
	<img width="160" height="100" src="<?php echo $logo_uri ?>" />
	<div class="wpiefy-wrap" id="<?php echo $tb_content_id ?>">

		<p><?php _e( 'Copy the following encoded settings string and save it on you local system".', 'weepie' ) ?></p>

		<div class="wpie-app-form-msg-wrap">
			<?php if( $has_err ): ?><div class="wpie-app-form-msg-err wpie-app-form-msg"><?php echo $msg_err ?></div><?php endif ?>
			<div class="wpie-app-form-msg-suc6 wpie-app-form-msg"><?php echo $msg_suc6 ?></div>
		</div>

		<form class="wpie-app-form" action="" method="post">

			<div class="wpie-form-field<?php echo ( in_array( $field_name_pc, $error_fields ) || $all_has_error ) ? ' has-err' : '' ?>">
			<label for="wf_wpiefy_pc"><?php _e( 'Envato purchase code', 'weepie' ) ?></label>
			<?php echo WpieFormHelper::formField(
					'textarea',
					$field_name_pc,
					$wf_wpiefy_pc,
					'',
				    []
					); ?>
			</div>
		</form>
	</div>
</div>