<?php
/**
 * Template for managing custom lists
 *
 * Please see weepie-framework.php for more details.
 *
 * @author $Vincent Weber <weepie-plugins@outlook.com> $
 *
 * @since 1.2.1
 */
if( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="wpie-list-wrapper wpie-list-layout-<?php echo $layout ?><?php if( $can_add ): ?> wpie-has-add<?php endif ?><?php if( $have_posts ): ?> wpie-list-has-posts<?php endif ?><?php if( $click_select ): ?> wpie-click-select<?php endif ?>"
	data-layout = "<?php echo $layout ?>"
	data-outer-w = "<?php echo $outer_w ?>"
	data-context = "<?php echo $context ?>"
	data-post-type = "<?php echo $post_type ?>"
	data-can-add = "<?php echo $can_add ?>"
	data-can-del = "<?php echo $can_del ?>"
	data-can-save = "<?php echo $can_save ?>"
	data-click-select = "<?php echo $click_select ?>"
	data-has-title = "<?php echo $has_title ?>"
	data-has-media = "<?php echo $has_media ?>"
	data-group-meta = "<?php echo $group_meta ?>"
	data-group-meta-key = "<?php echo $group_meta_key ?>">

	<?php if( $can_add ): ?>
	<label for="wpie-list-new-post-<?php echo \WpieFw\Helpers\WpieMiscHelper::convertToHyphens( $context ) ?>"><?php _e( 'Add new item', 'weepie' ) ?>:</label><br/>
	<?php
	echo \WpieFw\Helpers\WpieFormHelper::formField(
		'textnoname',
		'wpieclb_new_list',
		'',
		false,
		[
			'id' 	=> 'wpie-list-new-post-' . \WpieFw\Helpers\WpieMiscHelper::convertToHyphens( $context ),
			'class' => 'wpie-field-medium wpie-list-new-post',
			'placeholder' => sprintf( __( 'Enter a new %s name', 'weepie' ), \WpieFw\Helpers\WpieMiscHelper::convertToHyphens( $context ) ),
		]
	)
	?><span class="wpie-list-controls"><?php
		echo \WpieFw\Helpers\WpieFormHelper::formField(
			'linkbutton',
			'',
			'',
			false,
			[
				'class' => 'wpie-btn-add wpie-btn-add-post'
			],
			__( 'Add', 'weepie' )
			)
		?>
	</span><span class="ajax-loading ajax-loading-wpie"></span>
	<?php endif ?>
	<?php
	/**
	 * Let others add content before displaying the posts list
	 *
	 * @since 1.2.1
	 */
	echo $hook_before_list_posts;
	?>

	<?php if( $click_select ):
	echo \WpieFw\Helpers\WpieFormHelper::formField(
		'hidden',
		'',
		$selected,
		false,
		[ 'class' => 'hide wpie-list-selected-post' ]
	);
	endif ?>

	<p class="no-items-msg"><?php printf( __( 'There are no <strong>custom %s\'s</strong> to display yet.', 'weepie' ), \WpieFw\Helpers\WpieMiscHelper::convertToHyphens( $context ), __( 'Add', 'weepie' ) ) ?></p>

	<table id="wpie-list-posts-<?php echo \WpieFw\Helpers\WpieMiscHelper::convertToHyphens( $context ) ?>s" class="group wpie-list-posts-table wpie-list-rows-table">
	<?php if( $have_posts ): ?>

	<?php if( $has_heading ): ?>
	<tr class="wpie-list-heading wpie-list-row group">
	<?php foreach ( $headings as $heading ): ?>
	<th class="wpie-list-heading-item"><?php echo $heading ?></th>
	<?php endforeach ?>
	</tr>
	<?php endif ?>

	<?php echo $html_list_items ?>

	<?php endif ?>
	</table>
	<?php
	/**
	 * Let others add content after displaying the posts list
	 *
	 * @since 1.2.1
	 */
	echo $hook_after_list_posts; ?>
</div>