<?php
/**
 * Template for showing the bar (top, bottom of screen)
 *
 * Please see wp-cookie-allow.php for more details.
 *
 * @author $Author: Vincent Weber <weepie-plugins@outlook.com> $
 * @since 1.0
 *
 * @since 3.1 show a decline button
 */
if( ! defined( 'ABSPATH' ) ) exit;
?>
<div id="wpca-bar" class="wpca-lay-out <?php echo esc_attr( $class ) ?>">
	<div id="wpca-bar-content" class="wpca-lay-out-content"><?php
	// content is escaped in the module with `wp_kses`
	echo $content_text ?></div>
	<?php if( $show_btns ): ?>
	<div id="wpca-bar-meta" class="wpca-lay-out-meta">
		<?php if( $show_icon_settings ): ?>
			<?php if( $settings_trigger_icon ):
				?><svg
					version="1.1"
					id="wpca-icon-settings"
					xmlns="http://www.w3.org/2000/svg"
					xmlns:xlink="http://www.w3.org/1999/xlink"
					x="0px"
					y="0px"
					width="33px"
					height="33px"
					viewBox="0 0 33 33"
					enable-background="new 0 0 33 33"
					xml:space="preserve">
				<title><?php echo __( 'Open cookie settings', 'wpca' ) ?></title>
				<g>
					<g>
						<rect x="11.22" y="3.327" fill="<?php echo $color_settings_icon ?>" width="21.78" height="3.3"/>
						<rect y="3.327" fill="<?php echo $color_settings_icon ?>" width="7.92" height="3.3"/>
					</g>
					<rect x="4.63" fill="<?php echo $color_settings_icon ?>" width="3.3" height="10"/>
				</g>
				<g>
					<g>
						<rect x="27.719" y="14.327" fill="<?php echo $color_settings_icon ?>" width="5.281" height="3.3"/>
						<rect y="14.327" fill="<?php echo $color_settings_icon ?>" width="21.726" height="3.3"/>
					</g>
					<rect x="21.118" y="10.977" fill="<?php echo $color_settings_icon ?>" width="3.301" height="10"/>
				</g>
				<g>
					<rect x="16.06" y="26.35" fill="<?php echo $color_settings_icon ?>" width="16.94" height="3.301"/>
					<rect y="26.35" fill="<?php echo $color_settings_icon ?>" width="10.065" height="3.301"/>
					<rect x="9.459" y="23" fill="<?php echo $color_settings_icon ?>" width="3.301" height="10"/>
				</g>
				</svg><?php
			      else:	?><a id="wpca-icon-settings" href="#" title="<?php echo esc_attr( $icon_settings_hover_txt ); ?>"><?php echo esc_attr( $icon_settings_hover_txt ); ?></a><?php
			      endif ?>
		<?php endif ?>
		<?php if( $show_btn_accept && $show_btn_decline && $btn_decline_right): ?>
			<?php echo $btn_accept; echo $btn_decline ?>
		<?php elseif( $show_btn_accept && $show_btn_decline && !$btn_decline_right): ?>
			<?php  echo $btn_decline; echo $btn_accept ?>
		<?php else: ?>
		<?php if( $show_btn_accept ): echo $btn_accept; endif ?>
		<?php if( $show_btn_decline ): echo $btn_decline; endif ?>
		<?php endif ?>
	</div>
	<?php endif ?>
	<?php if( $show_icon_close ): ?><svg
		version="1.1"
		class="wpca-icon-close"
		xmlns="http://www.w3.org/2000/svg"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		x="0px"
		y="0px"
		width="20px"
		height="20px"
		viewBox="0 0 20 20"
		enable-background="new 0 0 20 20"
		xml:space="preserve">
		<title><?php echo __( 'Close cookie bar', 'wpca' ) ?></title>
		<polygon fill-rule="evenodd" points="19,3.581 16.42,1 10,7.42 3.581,1 1,3.58 7.42,10 1,16.42 3.581,19 10,12.581 16.42,19 19,16.419 12.581,10" fill="<?php echo $color_close_x_icon ?>"/>
	</svg><?php endif ?>
</div>