<?php
/**
 * Please see weepie-framework.php for more details.
 */

namespace WpieFw\Helpers;

if( ! defined( 'ABSPATH' ) ) exit;

class WpieMultilangHelper
{
	/**
	 * Gets the first locale from an option
	 *
	 * @acces public
	 *
	 * @param array $option
	 *
	 * @since 2.0.9
	 *
	 * @return string|bool the first locale or boolean false is option is not languaged
	 */
	public static function getFirstLocaleFromOption( $option = [] )
	{
		if( self::isLanguagedOption( $option ) ) {
			$keys = array_keys( $option );
			$firstLocale = array_shift( $keys );

			return $firstLocale;
		} else {
			return false;
		}
	}

	/**
	 * Check if given option is indexed with locales
	 *
	 * @acces	public
	 *
	 * @param	array $option
	 *
	 * @since 	1.2
	 *
	 * @return 	bool
	 */
	public static function isLanguagedOption( $option = [] )
	{
		if( empty( $option ) ) {
			return false;
		}

		$isLanguaged = false;
		$keys = array_keys( $option );

		$count = count( $keys );

		$i = 0;
		while ( !$isLanguaged && $i<$count ) {
			$isLanguaged = ( 1 === preg_match( '/^[a-z]{2}_[A-Z]{2}$/', $keys[$i], $m ) );
			$i++;
		}

		unset( $keys );

		return $isLanguaged;
	}


	/**
	 * Map a locale format to a language code
	 *
	 * For example: from the 'locale' string "en_US", the first part "en" will be returned
	 *
	 * @acces public
	 *
	 * @param string $locale the locale
	 *
	 * @uses preg_match()
	 *
	 * @since 1.2
	 *
	 * @return string, empty on failure
	 */
	public static function mapLocaleToCode( $locale = '' )
	{
		if( '' === $locale )
			return '';

		$code = '';

		if( preg_match( '/^([a-z]{2})_([A-Z]{2})$/', $locale, $m ) ) {

			if( isset( $m[1] ) && 2 === strlen($m[1]) )
				$code = $m[1];
		}

		return $code;
	}

	/**
	 * Map a language code to language locale
	 *
	 * For example: for the 'code' "en", the locale "en_US" will be returned
	 *
	 * @param string $code
	 * @param array $langs
	 *
	 * @since 2.0
	 *
	 * @return string, empty on failure
	 */
	public static function mapCodeToLocale( $code = '', array $langs = [] )
	{
		if( '' == $code || 0 === count( $langs ) ) {
			return '';
		}

		$locale = '';
		if( array_key_exists( $code , $langs ) ) {
			$locale = $langs[$code];
		}

		return $locale;
	}

	/**
	 * Load the plugin text domain
	 *
	 * @param string $nameSpace
	 * @param string $pluginRelPath
	 *
	 * @since 1.4.0
	 *
	 * @uses load_plugin_textdomain()
	 */
	public static function loadPluginTextDomain( $nameSpace = '', $pluginRelPath = '' )
	{
		load_plugin_textdomain( $nameSpace, false,  $pluginRelPath );
	}

	/**
	 * Get the active multilang plugin index
	 *
	 * @uses WpieWpmlHelper::isActive()
	 *
	 * @since 2.0
	 *
	 * @return string
	 */
	public static function getActivePlugin()
	{
		if( WpieWpmlHelper::isActive() ) {
			return 'wpml';
		} else {
			return '';
		}
	}

	/**
	 * Determine if a multilang plugin is active
	 *
	 * @uses self::getActivePlugin()
	 *
	 * @since 2.0
	 *
	 * @return boolean
	 */
	public static function hasActivePlugin()
	{
		return ( '' !== self::getActivePlugin() );
	}
}