<?php
/**
 * Template for Cookie Category settings options fields
 *
 * The label and description
 *
 * @since 3.2.11
 */
if( ! defined( 'ABSPATH' ) ) exit; ?>
<table id="wpca-cc-data" class="wpie-data-table wpie-data-table-full">
	<thead>
        <tr valign="top">
        	<th scope="row"><?php _e( 'Internal name' ) ?></th>
        	<th scope="row"><?php _e( 'Display name' ) ?></th>
        	<th scope="row"><?php _e( 'Description' ) ?></th>
        </tr>
	</thead>
	<tbody>
    <?php foreach( $categories as $idx => $data ): ?>
        <tr>
        	<th class="wpie-internal"><?php echo $idx ?></th>
            <td class="wpca-cc-title">
            <?php
            echo \WpieFw\Helpers\WpieFormHelper::formField(
            		'text',
                    "{$setting}[cc_data][$idx][label]",
                    $data['label'],
            		'',
            		array( 'placeholder' => __( 'Enter the display name' ) )
            		);
            ?>
            </td>
            <td class="wpca-cc-descr">
            <?php
            echo \WpieFw\Helpers\WpieWpFormHelper::formField(
            		'wptextareabasic',
                    "{$setting}[cc_data][$idx][descr]",
                    $data['descr'],
            		'',
            		array( 'class' => 'large-text', 'placeholder' => __( 'Enter the description' ) )
            		);
            ?>
            </td>
        </tr>
    <?php endforeach ?>
	</tbody>
</table>