<?php
/**
 * Please see wp-cookie-allow.php for more details.
 *
 * @author $Vincent Weber <weepie-plugins@outlook.com>$
 *
 * This file contains the upgrade logic
 */

use WpieFw\Helpers\WpieMultilangHelper;

if( ! defined( 'ABSPATH' ) ) exit;

add_action( 'wpca_wpiefw_upgrade_logic', 'wpca_wpiefw_upgrade_logic', 10, 5 );

/**
 * Callback for wpca_wpiefw_upgrade_logic hook
 *
 * Handles upgrade logic
 *
 * @param string $currVersionPlugin
 * @param string $newVersionPlugin
 * @param string $wpiefwVersionOld
 * @param string $versionWpieFw
 * @param bool $network_wide
 *
 * @since 2.3.3
 */
function wpca_wpiefw_upgrade_logic( $currVersionPlugin, $newVersionPlugin, $wpiefwVersionOld, $versionWpieFw, $networkWide )
{
	if( version_compare( $newVersionPlugin, '3.4.10', '>=' ) ) {
		$msg = sprintf(
			'Hi! You have updated to version %s. This version includes the following change(s):<br/><br/>' .
				'* fixed: PHP warning function `_load_textdomain_just_in_time` was called incorrectly<br/>' .
				'* fixed: GTM message doesn\'t dissapear<br/>' .
				'* fixed: `wpca_fix_src_ampersand` hook throws PHP warning<br/>' .
				'<a target="_blank" href="https://www.weepie-plugins.com/changelog-weepie-cookie-allow-plugin/">View the whole changelog</a>.'
				, $newVersionPlugin );
		set_transient( 'wpca_upgrade_msg', $msg, 86400 );
	}
}