<?php

/**
 * Views class for Shortcode generator options.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package chat-whatsapp-pro
 * @subpackage chat-whatsapp-pro/src/Admin/Views/ChatWhatsappProPopup
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\ChatWhatsappPro\Admin\Views;

use ThemeAtelier\ChatWhatsappPro\Admin\Framework\Classes\CHAT_WHATSAPP_PRO;

class ChatWhatsappProButton
{

    /**
     * Create Option fields for the setting options.
     *
     * @param string $prefix Option setting key prefix.
     * @return void
     */
    public static function options($prefix)
    {

        CHAT_WHATSAPP_PRO::createSection($prefix, array(
            'title'  => esc_html__('FLOATING BUTTON', 'chat-whatsapp-pro'),
            'icon'   => 'icofont-brand-whatsapp',
            'fields' => array(
                array(
                    'type' => 'section_tab',
                    'tabs' => array(
                        array(
                            'title' => esc_html__('General', 'greet-bubble'),
                            'icon'  => 'icofont-gear',
                            'fields'    => array(
                                array(
                                    'id'      => 'opt-button-style',
                                    'type'    => 'image_select',
                                    'title'   => esc_html__('Bubble button style', 'chat-whatsapp-pro'),
                                    'options' => array(
                                        '1' => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/bubble-1.png',
                                        '2' => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/bubble-2.png',
                                        '3' => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/bubble-3.png',
                                        '4' => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/bubble-4.png',
                                        '5' => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/bubble-5.png',
                                        '6' => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/bubble-6.png',
                                        '7' => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/bubble-7.png',
                                        '8' => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/bubble-8.png',
                                        '9' => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/bubble-9.png',
                                    ),
                                    'default' => '1',
                                ),

                                // Show hide icon
                                array(
                                    'id'    => 'disable-button-icon',
                                    'type'  => 'switcher',
                                    'title' => esc_html__('Show/Hide icon', 'chat-whatsapp-pro'),
                                    'text_on' => esc_html__('Show', 'chat-whatsapp-pro'),
                                    'text_off'  => esc_html__('Hide', 'chat-whatsapp-pro'),
                                    'default'   => true,
                                    'text_width'    => 80,
                                    'dependency' => array('opt-button-style', '!=', '1'),
                                ),

                                // Circle button icon
                                array(
                                    'id'    => 'circle-button-icon-1',
                                    'type'  => 'icon',
                                    'title' => esc_html__('Icon for circle button', 'chat-whatsapp-pro'),
                                    'default' => 'icofont-brand-whatsapp',
                                    'subtitle' => esc_html__('Change icon for circle button.', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-button-style', '==', '1'),
                                ),

                                // Circle button icon close
                                array(
                                    'id'    => 'circle-button-close-1',
                                    'type'  => 'icon',
                                    'title' => esc_html__('Icon for circle button close ', 'chat-whatsapp-pro'),
                                    'default' => 'icofont-close',
                                    'subtitle' => esc_html__('Change icon for circle button close.', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-button-style', '==', '1'),
                                ),
                                // Circle button icon
                                array(
                                    'id'    => 'circle-button-icon',
                                    'type'  => 'icon',
                                    'title' => esc_html__('Icon for circle button', 'chat-whatsapp-pro'),
                                    'default' => 'icofont-brand-whatsapp',
                                    'subtitle' => esc_html__('Change icon for circle button.', 'chat-whatsapp-pro'),
                                    'dependency' => array('disable-button-icon|opt-button-style', '==|!=', 'true|1'),
                                ),

                                // Circle button icon close
                                array(
                                    'id'    => 'circle-button-close',
                                    'type'  => 'icon',
                                    'title' => esc_html__('Icon for circle button close ', 'chat-whatsapp-pro'),
                                    'default' => 'icofont-close',
                                    'subtitle' => esc_html__('Change icon for circle button close.', 'chat-whatsapp-pro'),
                                    'dependency' => array('disable-button-icon|opt-button-style', '==|!=', 'true|1'),
                                ),

                                // changeing circle animations
                                array(
                                    'id'    => 'circle-animation',
                                    'type'  => 'select',
                                    'title' => esc_html__('Select animation for circle icon', 'chat-whatsapp-pro'),
                                    'options' => array(
                                        '1'     => esc_html__('Slide down', 'chat-whatsapp-pro'),
                                        '2'     => esc_html__('Rotate', 'chat-whatsapp-pro'),
                                        '3'     => esc_html__('Fade', 'chat-whatsapp-pro'),
                                        '4'     => esc_html__('Slide Up', 'chat-whatsapp-pro'),
                                    ),
                                    'default'     => '1',
                                    'dependency' => array('circle-button-icon', '==', 'true'),
                                ),

                                // Bubble text

                                array(
                                    'id'    => 'bubble-text',
                                    'type'    => 'text',
                                    'title'   => esc_html__('Bubble text', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Change text to show in bubble', 'chat-whatsapp-pro'),
                                    'default' => esc_html__('How may I help you?', 'chat-whatsapp-pro'),
                                    'dependency' => array('opt-button-style', 'any', '2,3,4,5,6,7,8,9'),
                                ),

                                // Bubble button padding
                                array(
                                    'id'    => 'bubble-button-padding',
                                    'type'    => 'spacing',
                                    'title'   => esc_html__('Bubble button padding', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Change bubble button padding', 'chat-whatsapp-pro'),
                                    'default'     => array(
                                        'top'       => '5',
                                        'right'     => '15',
                                        'bottom'    => '5',
                                        'left'      => '15',
                                        'unit'      => 'px',
                                    ),
                                    'dependency' => array('opt-button-style', 'any', '2,3,4,5,6,7,8,9'),
                                ),
                                array(
                                    'id'    => 'bubble_button_tooltip',
                                    'type'    => 'switcher',
                                    'title'   => esc_html__('Button tooltip', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Show button tooltip.', 'chat-whatsapp-pro'),
                                    'text_on' => esc_html__('Show', 'chat-whatsapp-pro'),
                                    'text_off'  => esc_html__('Hide', 'chat-whatsapp-pro'),
                                    'default'   => true,
                                    'text_width'    => 80,
                                ),
                                array(
                                    'id'    => 'bubble_button_tooltip_text',
                                    'type'    => 'text',
                                    'title'   => esc_html__('Button Tooltip Text', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Set button tooltip text.', 'chat-whatsapp-pro'),
                                    'default' => esc_html__('Need Help? Chat with us', 'chat-whatsapp-pro'),
                                    'dependency' => array('bubble_button_tooltip', '==', 'true'),
                                ),
                                array(
                                    'id'    => 'bubble_button_tooltip_width',
                                    'type'    => 'slider',
                                    'title'   => esc_html__('Button Tooltip Width', 'chat-whatsapp-pro'),
                                    'subtitle' => esc_html__('Set bubble button tooltip width.', 'chat-whatsapp-pro'),
                                    'min'     => 20,
                                    'max'     => 500,
                                    'step'    => 5,
                                    'unit'    => 'px',
                                    'default' => 190,
                                    'dependency' => array('bubble_button_tooltip', '==', 'true'),
                                ),
                                // bubble visibility
                                array(
                                    'id'      => 'bubble-visibility',
                                    'type'    => 'button_set',
                                    'title'   => esc_html__('Bubble visibility', 'chat-whatsapp-pro'),
                                    'default' => 'everywhere',
                                    'options'    => array(
                                        'everywhere'  => esc_html__('Everywhere', 'chat-whatsapp-pro'),
                                        'desktop' => esc_html__('Desktop Only', 'chat-whatsapp-pro'),
                                        'tablet' => esc_html__('Tablet Only', 'chat-whatsapp-pro'),
                                        'mobile' => esc_html__('Mobile Only', 'chat-whatsapp-pro'),
                                    ),
                                ),
                            )
                        ),
                        array(
                            'title' => esc_html__('Position', 'greet-bubble'),
                            'icon'  => 'icofont-hand-drag',
                            'fields'    => array(

                                array(
                                    'id'      => 'bubble-position',
                                    'type'    => 'button_set',
                                    'title'   => esc_html__('Bubble position', 'chat-whatsapp-pro'),
                                    'default' => 'right_bottom',
                                    'options'    => array(
                                        'right_bottom'  => esc_html__('Right Bottom', 'chat-whatsapp-pro'),
                                        'left_bottom' => esc_html__('Left Bottom', 'chat-whatsapp-pro'),
                                        'right_middle' => esc_html__('Right Middle', 'chat-whatsapp-pro'),
                                        'left_middle' => esc_html__('Left Middle', 'chat-whatsapp-pro'),
                                    ),
                                ),

                                array(
                                    'id'    => 'right_bottom',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Right Bottom', 'chat-whatsapp-pro'),
                                    'top'   => false,
                                    'left'  => false,
                                    'default'  => array(
                                        'right'    => '30',
                                        'bottom'  => '30',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble-position', '==', 'right_bottom', 'any'),
                                ),

                                array(
                                    'id'    => 'left_bottom',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Left Bottom', 'chat-whatsapp-pro'),
                                    'top'   => false,
                                    'right'  => false,
                                    'default'  => array(
                                        'left'    => '30',
                                        'bottom'  => '30',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble-position', '==', 'left_bottom', 'any'),
                                ),

                                array(
                                    'id'    => 'right_middle',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Right Middle', 'chat-whatsapp-pro'),
                                    'top'   => false,
                                    'left'  => false,
                                    'bottom'  => false,
                                    'default'  => array(
                                        'right'    => '20',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble-position', '==', 'right_middle', 'any'),
                                ),

                                array(
                                    'id'    => 'left_middle',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Left Middle', 'chat-whatsapp-pro'),
                                    'top'   => false,
                                    'right' => false,
                                    'bottom' => false,
                                    'default'  => array(
                                        'left' => '20',
                                        'unit' => 'px',
                                    ),
                                    'dependency' => array('bubble-position', '==', 'left_middle', 'any'),
                                ),

                                array(
                                    'type'  => 'subheading',
                                    'title' => esc_html__('Different Positioning on Tablet', 'chat-whatsapp-pro'),
                                    'dependency' => array('bubble-visibility', '==', 'everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'enable-positioning-tablet',
                                    'type'  => 'switcher',
                                    'title' => esc_html__('Use Different Positioning for Tablet Devices', 'chat-whatsapp-pro'),
                                    'text_on' => esc_html__('Yes', 'chat-whatsapp-pro'),
                                    'text_off'  => esc_html__('No', 'chat-whatsapp-pro'),
                                    'dependency' => array('bubble-visibility', '==', 'everywhere', 'any'),
                                ),

                                // Bubble position
                                array(
                                    'id'      => 'bubble-position-tablet',
                                    'type'    => 'button_set',
                                    'title'   => esc_html__('Bubble position', 'chat-whatsapp-pro'),
                                    'default' => 'right_bottom',
                                    'options'    => array(
                                        'right_bottom'  => esc_html__('Right Bottom', 'chat-whatsapp-pro'),
                                        'left_bottom' => esc_html__('Left Bottom', 'chat-whatsapp-pro'),
                                        'right_middle' => esc_html__('Right Middle', 'chat-whatsapp-pro'),
                                        'left_middle' => esc_html__('Left Middle', 'chat-whatsapp-pro'),
                                    ),
                                    'dependency' => array('enable-positioning-tablet|bubble-visibility', '==|==', 'true|everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'right_bottom_tablet',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Right Bottom', 'chat-whatsapp-pro'),
                                    'top'   => false,
                                    'left'  => false,
                                    'default'  => array(
                                        'right'    => '30',
                                        'bottom'  => '30',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble-position-tablet|enable-positioning-tablet|bubble-visibility', '==|==|==', 'right_bottom|true|everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'left_bottom_tablet',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Left Bottom', 'chat-whatsapp-pro'),
                                    'top'   => false,
                                    'right'  => false,
                                    'default'  => array(
                                        'left'    => '30',
                                        'bottom'  => '30',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble-position-tablet|enable-positioning-tablet|bubble-visibility', '==|==|==', 'left_bottom|true|everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'right_middle_tablet',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Right Middle', 'chat-whatsapp-pro'),
                                    'top'   => false,
                                    'left'  => false,
                                    'bottom'  => false,
                                    'default'  => array(
                                        'right'    => '20',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble-position-tablet|enable-positioning-tablet|bubble-visibility', '==|==|==', 'right_middle|true|everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'left_middle_tablet',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Left Middle', 'chat-whatsapp-pro'),
                                    'top'   => false,
                                    'right' => false,
                                    'bottom' => false,
                                    'default'  => array(
                                        'left' => '20',
                                        'unit' => 'px',
                                    ),
                                    'dependency' => array('bubble-position-tablet|enable-positioning-tablet|bubble-visibility', '==|==|==', 'left_middle|true|everywhere', 'any'),
                                ),

                                array(
                                    'type'  => 'subheading',
                                    'title' => esc_html__('Different Positioning on Mobile', 'chat-whatsapp-pro'),
                                    'dependency'    => array('bubble-visibility', '==', 'everywhere', 'any')
                                ),
                                array(
                                    'id'    => 'enable-positioning-mobile',
                                    'type'  => 'switcher',
                                    'title' => esc_html__('Use Different Positioning for Mobile Devices', 'chat-whatsapp-pro'),
                                    'text_on' => esc_html__('Yes', 'chat-whatsapp-pro'),
                                    'text_off'  => esc_html__('No', 'chat-whatsapp-pro'),
                                    'dependency'    => array('bubble-visibility', '==', 'everywhere', 'any')
                                ),

                                // Bubble position
                                array(
                                    'id'      => 'bubble-position-mobile',
                                    'type'    => 'button_set',
                                    'title'   => esc_html__('Bubble position', 'chat-whatsapp-pro'),
                                    'default' => 'right_bottom',
                                    'options'    => array(
                                        'right_bottom'  => esc_html__('Right Bottom', 'chat-whatsapp-pro'),
                                        'left_bottom' => esc_html__('Left Bottom', 'chat-whatsapp-pro'),
                                        'right_middle' => esc_html__('Right Middle', 'chat-whatsapp-pro'),
                                        'left_middle' => esc_html__('Left Middle', 'chat-whatsapp-pro'),
                                    ),
                                    'dependency' => array('enable-positioning-mobile|bubble-visibility', '==|==', 'true|everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'right_bottom_mobile',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Right Bottom', 'chat-whatsapp-pro'),
                                    'top'   => false,
                                    'left'  => false,
                                    'default'  => array(
                                        'right'    => '30',
                                        'bottom'  => '30',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble-position-mobile|enable-positioning-mobile|bubble-visibility', '==|==|==', 'right_bottom|true|everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'left_bottom_mobile',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Left Bottom', 'chat-whatsapp-pro'),
                                    'top'   => false,
                                    'right'  => false,
                                    'default'  => array(
                                        'left'    => '30',
                                        'bottom'  => '30',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble-position-mobile|enable-positioning-mobile|bubble-visibility', '==|==|==', 'left_bottom|true|evenywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'right_middle_mobile',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Right Middle', 'chat-whatsapp-pro'),
                                    'top'   => false,
                                    'left'  => false,
                                    'bottom'  => false,
                                    'default'  => array(
                                        'right'    => '20',
                                        'unit'   => 'px',
                                    ),
                                    'dependency' => array('bubble-position-mobile|enable-positioning-mobile|bubble-visibility', '==|==|==', 'right_middle|true|everywhere', 'any'),
                                ),

                                array(
                                    'id'    => 'left_middle_mobile',
                                    'type'  => 'spacing',
                                    'title' => esc_html__('Margin From Left Middle', 'chat-whatsapp-pro'),
                                    'top'   => false,
                                    'right' => false,
                                    'bottom' => false,
                                    'default'  => array(
                                        'left' => '20',
                                        'unit' => 'px',
                                    ),
                                    'dependency' => array('bubble-position-mobile|enable-positioning-mobile|bubble-visibility', '==|==|==', 'left_middle|true|everywhere', 'any'),
                                ),

                            )
                        ),
                        array(
                            'title' => esc_html__('Page Restriction', 'greet-bubble'),
                            'icon'  => 'icofont-page',
                            'fields'    => array(
                                // Include specific
                                array(
                                    'id'      => 'bubble_include_page',
                                    'type'    => 'select',
                                    'title'   => esc_html__('Include page', 'chat-whatsapp-pro'),
                                    'options'    => 'pages',
                                    'chosen'      => true,
                                    'multiple'    => true,
                                    'sortable'    => true,
                                ),
                                // Exclude specific
                                array(
                                    'id'      => 'bubble_exclude_page',
                                    'type'    => 'select',
                                    'title'   => esc_html__('Exclude page', 'chat-whatsapp-pro'),
                                    'options'    => 'pages',
                                    'chosen'      => true,
                                    'multiple'    => true,
                                    'sortable'    => true,
                                    'dependency'  => array('bubble_include_page', '==', '', true),
                                ),
                            )
                        ),
                    )
                ),
            )
        ));
    }
}
