<?php
/**
 * Plugin Name: WBW Product Table PRO
 * Description: Product Table by WBW PRO. Best plugins from WBW!
 * Plugin URI: https://woobewoo.com/plugins/table-woocommerce-plugin/
 * Author: WBW
 * Author URI: https://woobewoo.com/
 * Version: 2.2.2
 * WC requires at least: 3.4.0
 * WC tested up to: 10.2
 * Requires Plugins: woocommerce
 */

defined( 'ABSPATH' ) || exit;

/**
 * wpUpdater.
 */
require_once __DIR__ . DIRECTORY_SEPARATOR . 'wpUpdater.php';

/**
 * Activation, deactivation, uninstall.
 *
 * @version 2.2.1
 */
register_activation_hook(   __FILE__, 'wooproducttablesProActivateCallback' );
register_deactivation_hook( __FILE__, 'wooproducttablesProDeactivateCallback' );
register_uninstall_hook(    __FILE__, 'wooproducttablesProUninstallCallback' );

/**
 * HPOS.
 */
add_action( 'before_woocommerce_init', function () {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility(
			'custom_order_tables',
			__FILE__,
			true
		);
	}
} );

/**
 * pre_set_site_transient_update_plugins.
 */
add_filter('pre_set_site_transient_update_plugins', 'checkForPluginUpdatewooproducttablesPro');

/**
 * plugins_api.
 */
add_filter('plugins_api', 'myPluginApiCallwooproducttablesPro', 10, 3);

/**
 * changeViewDetailsWtbp.
 */
add_filter('plugin_row_meta', 'changeViewDetailsWtbp', 10, 4);
if (!function_exists('changeViewDetailsWtbp')) {
	function changeViewDetailsWtbp($plugin_meta, $plugin_file, $plugin_data, $status) {
		if (isset($plugin_data['slug']) && $plugin_data['slug'] === getProPlugCodeWtbp()) {
			foreach ($plugin_meta as $key => $meta) {
				if (
					strpos($meta, 'plugin-install.php?tab=plugin-information') !== false &&
					isset($plugin_data['PluginURI'])
				) {
					$plugin_meta[$key] = '<a href="' . esc_url($plugin_data['PluginURI']) . '" target="_blank">' .
						__( 'Visit plugin site' ) .
					'</a>';
				}
			}
		}
		return $plugin_meta;
	}
}

/**
 * getProPlugCodeWtbp.
 */
if (!function_exists('getProPlugCodeWtbp')) {
	function getProPlugCodeWtbp() {
		return 'woo_producttables_pro';
	}
}

/**
 * getProPlugDirWtbp.
 */
if (!function_exists('getProPlugDirWtbp')) {
	function getProPlugDirWtbp() {
		return basename(__DIR__);
	}
}

/**
 * getProPlugFileWtbp.
 */
if (!function_exists('getProPlugFileWtbp')) {
	function getProPlugFileWtbp() {
		return basename(__FILE__);
	}
}

/**
 * getProPlugFullPathWtbp.
 */
if (!function_exists('getProPlugFullPathWtbp')) {
	function getProPlugFullPathWtbp() {
		return __FILE__;
	}
}

/**
 * getProPlugSlugWtbp.
 */
if (!function_exists('getProPlugSlugWtbp')) {
	function getProPlugSlugWtbp() {
		return 'woo-producttables-pro';
	}
}

/**
 * S_YOUR_SECRET_HASH_.
 */
if (!defined('S_YOUR_SECRET_HASH_' . getProPlugCodeWtbp())) {
	define('S_YOUR_SECRET_HASH_' . getProPlugCodeWtbp(), 'ng93#g3j9g#R#E)@KDPWKOK)Fkvvk#f30f#KF');
}

/**
 * checkForPluginUpdatewooproducttablesPro.
 */
if (!function_exists('checkForPluginUpdatewooproducttablesPro')) {
	function checkForPluginUpdatewooproducttablesPro( $checkedData ) {
		if (class_exists('WpUpdaterWtbp')) {
			return WpUpdaterWtbp::getInstance(
				getProPlugDirWtbp(),
				getProPlugFileWtbp(),
				getProPlugCodeWtbp(),
				getProPlugFullPathWtbp()
			)->checkForPluginUpdate($checkedData);
		}
		return $checkedData;
	}
}

/**
 * myPluginApiCallwooproducttablesPro.
 */
if (!function_exists('myPluginApiCallwooproducttablesPro')) {
	function myPluginApiCallwooproducttablesPro( $def, $action, $args ) {
		if (class_exists('WpUpdaterWtbp')) {
			return WpUpdaterWtbp::getInstance(
				getProPlugDirWtbp(),
				getProPlugFileWtbp(),
				getProPlugCodeWtbp(),
				getProPlugFullPathWtbp()
			)->myPluginApiCall($def, $action, $args);
		}
		return $def;
	}
}

/**
 * Check if there are base (free) version installed.
 *
 * @param bool $isNetworkWide Check if site activated for network
 */
if (!function_exists('wooproducttablesProActivateCallback')) {
	function wooproducttablesProActivateCallback( $isNetworkWide ) {
		if (class_exists('FrameWtbp')) {
			$arguments = func_get_args();
			if (function_exists('is_multisite') && is_multisite()) {
				global $wpdb;
				if ($isNetworkWide) {
					$blog_id = $wpdb->get_col("SELECT blog_id FROM $wpdb->blogs");
					foreach ($blog_id as $id) {
						if (switch_to_blog($id)) {
							call_user_func_array(array( 'ModInstallerWtbp', 'check' ), $arguments);
							restore_current_blog();
						}
					}
				} else {
					call_user_func_array(array( 'ModInstallerWtbp', 'check' ), $arguments);
				}
			} else {
				call_user_func_array(array( 'ModInstallerWtbp', 'check' ), $arguments);
			}
		}
	}
}

/**
 * wooproducttablesProDeactivateCallback.
 *
 * @version 2.2.1
 * @since   2.2.1
 */
if ( ! function_exists( 'wooproducttablesProDeactivateCallback' ) ) {
	function wooproducttablesProDeactivateCallback() {
		if ( is_callable( array( 'ModInstallerWtbp', 'deactivate' ) ) ) {
			ModInstallerWtbp::deactivate();
		}
	}
}

/**
 * wooproducttablesProUninstallCallback.
 *
 * @version 2.2.1
 * @since   2.2.1
 */
if ( ! function_exists( 'wooproducttablesProUninstallCallback' ) ) {
	function wooproducttablesProUninstallCallback() {
		if ( is_callable( array( 'ModInstallerWtbp', 'uninstall' ) ) ) {
			ModInstallerWtbp::uninstall();
		}
	}
}

/**
 * wooproducttablesProInstallBaseMsg.
 */
add_action('admin_notices', 'wooproducttablesProInstallBaseMsg');
if (!function_exists('wooproducttablesProInstallBaseMsg')) {
	return;
	function wooproducttablesProInstallBaseMsg() {
		if (!get_option('wtbp_full_installed') || !class_exists('FrameWtbp')) {
			$plugName = 'Product Table by WBW';
			$plugWpUrl = 'https://wordpress.org/plugins/woo-product-tables/';
			echo '<div class="notice error is-dismissible"><p><strong>
				Please install Free (Base) version of ' . esc_html($plugName) . ' plugin, you can get it <a target="_blank" href="' . esc_url($plugWpUrl) . '">here</a> or use Wordpress plugins search functionality,
				activate it, then deactivate and activate again PRO version of ' . esc_html($plugName) . '.
				In this way you will have full and upgraded PRO version of ' . esc_html($plugName) . '.</strong></p></div>';
		}
	}
}

/**
 * Add "Check for updates" row meta in the Plugins list table.
 *
 * @version 2.2.1
 * @since   2.2.1
 */
add_filter(
	'plugin_row_meta',
	function ( $plugin_meta, $plugin_file, $plugin_data, $status ) {
		if ( false !== strpos( $plugin_file, basename( __FILE__ ) ) ) {
			$plugin_meta[] = sprintf(
				'<a href="%1$s">%2$s</a>',
				add_query_arg( 'wbw_woo_product_tables_pro_check_for_updates', true ),
				__( 'Check for updates', 'woo-product-tables' )
			);
		}
		return $plugin_meta;
	},
	10,
	4
);

/**
 * Force check for updates.
 *
 * @version 2.2.1
 * @since   2.2.1
 *
 * @todo    (v2.2.1) add nonce?
 * @todo    (v2.2.1) add admin notice?
 */
add_action(
	'admin_init',
	function () {
		if ( ! isset( $_GET['wbw_woo_product_tables_pro_check_for_updates'] ) ) {
			return;
		}

		if ( ! current_user_can( 'manage_woocommerce' ) ) {
			wp_die( esc_html__( 'Wrong user.', 'woo-product-tables' ) );
		}

		delete_option( '_wbw_woo_product_tables_pro_request_time_basic_check' );
		delete_site_transient( 'update_plugins' );
		wp_update_plugins();

		wp_safe_redirect( remove_query_arg( 'wbw_woo_product_tables_pro_check_for_updates' ) );
		exit;
	}
);
