/* global wp */
( function() {
	const { registerBlockType } = wp.blocks;
	const { __, setLocaleData } = wp.i18n;
	const { useBlockProps, RichText } = wp.blockEditor || wp.editor;

	// Hydrate locale data when provided by PHP as a fallback.
	if ( window.wcAppointmentsAvailabilityLocaleData ) {
		setLocaleData( window.wcAppointmentsAvailabilityLocaleData, 'woocommerce-appointments' );
	}

	registerBlockType( 'woocommerce-appointments/availability-filter', {
		title: __( 'Filter Products by Availability', 'woocommerce-appointments' ),
		description: __( 'Filter products in your store by availability (dates).', 'woocommerce-appointments' ),
		category: 'woocommerce',
		icon: 'calendar-alt',
		supports: { html: false },
		attributes: {
			title: { type: 'string', default: '' }
		},
		edit( props ) {
			const { attributes: { title }, setAttributes } = props;
			const blockProps = useBlockProps ? useBlockProps( { className: 'wc-appointments-availability-block-editor' } ) : {};

			return wp.element.createElement(
				'div',
				blockProps,
				wp.element.createElement( RichText, {
					tagName: 'h3',
					className: 'wp-block-heading',
					value: title || '',
					onChange( value ) { setAttributes( { title: value } ); },
					placeholder: __( 'Filter Products by Availability', 'woocommerce-appointments' )
				} ),
				wp.element.createElement( 'div', { className: 'date_picker_wrapper' },
					wp.element.createElement( 'div', { className: 'date_picker_inner date_picker_start' },
						wp.element.createElement( 'label', { htmlFor: 'min_date_label' }, __( 'Start Date:', 'woocommerce-appointments' ) ),
						wp.element.createElement( 'input', { type: 'text', id: 'min_date_label', className: 'date-picker', value: '', readOnly: true } )
					),
					wp.element.createElement( 'div', { className: 'date_picker_inner date_picker_end' },
						wp.element.createElement( 'label', { htmlFor: 'max_date_label' }, __( 'End Date:', 'woocommerce-appointments' ) ),
						wp.element.createElement( 'input', { type: 'text', id: 'max_date_label', className: 'date-picker', value: '', readOnly: true } )
					),
					wp.element.createElement( 'button', { type: 'button', className: 'button', disabled: true }, __( 'Filter', 'woocommerce-appointments' ) )
				)
			);
		},
		save() { return null; }
	} );
} )();
