﻿<?php
// Exit if accessed directly.
defined('ABSPATH') || exit;
?>
<div class="wca-whats-new-page">
	<style>
		/* ============================================
		   MOBILE-FIRST BASE STYLES
		   ============================================ */
		:root {
			--wca-surface: #ffffff;
			--wca-surface-secondary: #f8f9fa;
			--wca-border: #e0e4e7;
			--wca-text-main: #101517;
			--wca-text-muted: #646970;
			--wca-primary: #2271b1;
			--wca-shadow-sm: 0 1px 2px rgba(0, 0, 0, 0.05);
			--wca-shadow-md: 0 4px 12px rgba(0, 0, 0, 0.08);
			--wca-radius-md: 8px;
			--wca-radius-lg: 12px;
		}

		.wca-whats-new-page {
			margin: 0 auto;
			max-width: 100%;
			padding: 20px;
			font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
			color: var(--wca-text-main);
			font-size: 16px;
			line-height: 1.6;
			-webkit-font-smoothing: antialiased;
			-moz-osx-font-smoothing: grayscale;
		}

		/* Visual Enhancements */
		.wca-whats-new-page * {
			box-sizing: border-box;
		}

		/* Utilities */
		.wca-placeholder {
			min-height: 200px;
			display: flex;
			align-items: center;
			justify-content: center;
			margin: 0;
			border: 1px solid var(--wca-border);
			border-radius: var(--wca-radius-lg);
			background: var(--wca-surface-secondary);
			overflow: hidden;
			position: relative;
			width: 100%;
			box-shadow: inset 0 2px 4px rgba(0,0,0,0.02);
		}

		.wca-placeholder svg {
			width: 100%;
			height: auto;
			max-width: 100%;
			display: block;
		}

		/* Typography */
		.wca-whats-new-page h1 {
			font-size: 32px;
			font-weight: 700;
			margin: 0 0 16px;
			padding: 0;
			line-height: 1.25;
			color: var(--wca-text-main);
			letter-spacing: -0.02em;
		}

		.wca-whats-new-page h2 {
			font-size: 24px;
			font-weight: 600;
			margin: 40px 0 20px;
			color: var(--wca-text-main);
			letter-spacing: -0.01em;
			line-height: 1.3;
		}

		.wca-whats-new-page h3 {
			font-size: 18px;
			font-weight: 600;
			margin: 0 0 12px;
			color: var(--wca-text-main);
			line-height: 1.4;
		}

		.wca-whats-new-page p {
			font-size: 16px;
			line-height: 1.6;
			margin-bottom: 24px;
			color: #3c434a;
		}

		.wca-whats-new-page strong {
			font-weight: 600;
			color: var(--wca-text-main);
		}

		/* Navigation */
		.wca-whats-new-page .nav-tab-wrapper {
			border-bottom: 1px solid var(--wca-border);
			padding: 0;
			margin: 32px 0 40px;
			display: none;
			gap: 32px;
		}

		.wca-mobile-nav-select {
			display: block;
			width: 100%;
			padding: 12px 16px;
			margin: 24px 0 32px;
			font-size: 16px;
			font-weight: 500;
			color: var(--wca-text-main);
			background: #fff;
			border: 1px solid var(--wca-border);
			border-radius: var(--wca-radius-md);
			box-shadow: var(--wca-shadow-sm);
			appearance: none;
			background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%23646970' d='M6 9L1 4h10z'/%3E%3C/svg%3E");
			background-repeat: no-repeat;
			background-position: right 16px center;
			background-size: 12px;
			padding-right: 40px;
			cursor: pointer;
		}

		.wca-mobile-nav-select:hover {
			border-color: var(--wca-muted);
		}
		
		.wca-mobile-nav-select:focus {
			border-color: var(--wp-admin-theme-color);
			box-shadow: 0 0 0 1px var(--wp-admin-theme-color);
			outline: none;
		}

		.wca-whats-new-page .nav-tab {
			font-size: 15px;
			font-weight: 500;
			line-height: 1.5;
			padding: 12px 0;
			margin: 0;
			background: transparent;
			border: none;
			border-bottom: 2px solid transparent;
			color: var(--wca-text-muted);
			text-decoration: none;
			display: inline-flex;
			align-items: center;
			gap: 8px;
			transition: color 0.2s ease, border-color 0.2s ease;
			margin-bottom: -1px;
			white-space: nowrap;
		}

		.wca-whats-new-page .nav-tab:hover {
			color: var(--wca-text-main);
			background: transparent;
		}

		.wca-whats-new-page .nav-tab:focus {
			box-shadow: none;
			outline: none;
			color: var(--wp-admin-theme-color);
		}

		.wca-whats-new-page .nav-tab-active {
			background: transparent;
			border-bottom: 2px solid var(--wp-admin-theme-color);
			color: var(--wca-text-main);
			font-weight: 600;
		}

		/* Animations */
		.about-section {
			margin-top: 32px;
			opacity: 1;
			transform: translateY(0);
		}

		.about-section.is-hidden {
			display: none;
			opacity: 0;
		}

		.about-section.is-animating-in {
			animation: wcaFadeSlideIn 0.3s cubic-bezier(0.2, 0, 0.2, 1) forwards;
		}

		.about-section.is-animating-out {
			animation: wcaFadeSlideOut 0.2s cubic-bezier(0.2, 0, 0.2, 1) forwards;
		}

		@keyframes wcaFadeSlideIn {
			from { opacity: 0; transform: translateY(12px); }
			to { opacity: 1; transform: translateY(0); }
		}

		@keyframes wcaFadeSlideOut {
			from { opacity: 1; transform: translateY(0); }
			to { opacity: 0; transform: translateY(-12px); }
		}

		@keyframes wca-spin {
			to { transform: rotate(360deg); }
		}

		@keyframes wca-pulse {
			0%, 100% { opacity: 1; }
			50% { opacity: 0.7; }
		}

		/* Improvements Nav */
		.wca-improvements-nav {
			display: grid;
			grid-template-columns: 1fr;
			gap: 12px;
			margin-bottom: 24px;
		}

		.wca-improvements-nav-item {
			padding: 20px;
			background: #fff;
			border: 1px solid var(--wca-border);
			border-radius: var(--wca-radius-lg);
			cursor: pointer;
			text-align: left;
			transition: all 0.2s cubic-bezier(0.2, 0, 0.2, 1);
			text-decoration: none;
			color: inherit;
			display: block;
			box-shadow: var(--wca-shadow-sm);
			position: relative;
			overflow: hidden;
		}

		.wca-improvements-nav-item:hover {
			border-color: #c3c4c7;
			box-shadow: var(--wca-shadow-md);
			transform: translateY(-1px);
		}

		.wca-improvements-nav-item.is-active {
			background: #fff;
			border-color: var(--wp-admin-theme-color);
			box-shadow: 0 0 0 1px var(--wp-admin-theme-color), var(--wca-shadow-md);
			z-index: 1;
		}

		.wca-improvements-nav-item .wca-chip {
			display: inline-block;
			margin-bottom: 12px;
		}

		.wca-improvements-nav-item h4 {
			margin: 0 0 6px;
			font-size: 16px;
			font-weight: 600;
			color: var(--wca-text-main);
		}

		.wca-improvements-nav-item p {
			margin: 0;
			font-size: 14px;
			line-height: 1.5;
			color: var(--wca-text-muted);
		}

		/* Connector line - Desktop only */
		.wca-connector {
			display: none;
			position: relative;
			height: 40px;
			margin-bottom: 0;
		}

		.wca-connector::before {
			content: '';
			position: absolute;
			left: var(--connector-x, 50%);
			top: 0;
			width: 2px;
			height: 100%;
			background: linear-gradient(to bottom, var(--wp-admin-theme-color), transparent);
			transition: left 0.3s cubic-bezier(0.2, 0, 0.2, 1);
		}

		.wca-connector::after {
			content: '';
			position: absolute;
			left: var(--connector-x, 50%);
			top: -1px;
			width: 8px;
			height: 8px;
			margin-left: -3px;
			border-radius: 50%;
			background: var(--wp-admin-theme-color);
			transition: left 0.3s cubic-bezier(0.2, 0, 0.2, 1);
		}

		/* Layouts */
		.about-header {
			display: flex;
			flex-direction: column;
			gap: 32px;
			align-items: flex-start;
			margin-bottom: 0;
		}

		.wca-version-pill {
			display: inline-flex;
			align-items: center;
			gap: 8px;
			padding: 6px 12px;
			border-radius: 20px;
			background: rgba(var(--wp-admin-theme-color-rgb, 34, 113, 177), 0.1);
			color: var(--wp-admin-theme-color);
			font-weight: 600;
			font-size: 13px;
			letter-spacing: 0.3px;
			margin-bottom: 16px;
		}

		.wca-version-pill .wca-dot {
			width: 8px;
			height: 8px;
			border-radius: 50%;
			background: var(--wp-admin-theme-color);
			box-shadow: 0 0 0 2px rgba(var(--wp-admin-theme-color-rgb, 34, 113, 177), 0.2);
			animation: wca-pulse 2s infinite;
		}

		.has-2-columns {
			display: flex;
			flex-direction: column;
			gap: 32px;
		}

		/* Components */
		hr {
			border: 0;
			border-top: 1px solid var(--wca-border);
			margin: 48px 0;
		}

		ul.ul-disc {
			list-style-type: disc;
			margin-left: 20px;
			line-height: 1.7;
			color: #3c434a;
			font-size: 15px;
		}

		ul.ul-disc li {
			margin-bottom: 10px;
		}

		ul.ul-disc li::marker {
			color: var(--wca-text-muted);
		}

		code {
			background: #f6f7f7;
			padding: 3px 6px;
			border-radius: 4px;
			font-size: 0.9em;
			font-family: 'SFMono-Regular', Consolas, 'Liberation Mono', Menlo, monospace;
			border: 1px solid var(--wca-border);
			color: #2c3338;
		}

		.wca-cta-links {
			display: flex;
			flex-direction: column;
			gap: 12px;
			margin: 24px 0 12px;
			align-items: stretch;
		}

		.wca-cta-links .button-primary {
			padding: 10px 20px;
			font-size: 15px;
			font-weight: 500;
			border-radius: 6px;
			text-align: center;
			height: auto;
			line-height: 1.4;
		}

		.wca-cta-links .button {
			padding: 10px 16px;
			font-size: 15px;
			border-radius: 6px;
			text-align: center;
			height: auto;
			line-height: 1.4;
		}

		.wca-new-badge {
			display: inline-flex;
			align-items: center;
			padding: 2px 8px;
			border-radius: 10px;
			background: #e8f5e9;
			color: #1b5e20;
			font-weight: 700;
			font-size: 10px;
			letter-spacing: 0.5px;
			margin-left: 8px;
			vertical-align: middle;
			text-transform: uppercase;
			border: 1px solid rgba(27, 94, 32, 0.1);
		}

		.wca-new-badge::before {
			content: 'NEW';
		}

		/* Roadmap */
		.wca-roadmap {
			position: relative;
			padding-left: 40px;
			margin-top: 40px;
		}

		.wca-roadmap::before {
			content: '';
			position: absolute;
			left: 11px;
			top: 0;
			bottom: 0;
			width: 2px;
			background: var(--wca-border);
		}

		.wca-roadmap-item {
			position: relative;
			padding: 0 0 40px 0;
		}
		
		.wca-roadmap-item:last-child {
			padding-bottom: 0;
		}

		.wca-roadmap-item::before {
			content: '';
			position: absolute;
			left: -36px;
			top: 4px;
			width: 14px;
			height: 14px;
			border-radius: 50%;
			background: #fff;
			border: 2px solid #c3c4c7;
			z-index: 2;
			transition: all 0.3s ease;
		}

		.wca-roadmap-item.is-complete::before {
			background: var(--wp-admin-theme-color);
			border-color: var(--wp-admin-theme-color);
			box-shadow: 0 0 0 3px #fff;
		}

		.wca-roadmap-item h3 {
			margin: 0 0 8px;
			font-size: 18px;
		}

		/* Accordion styles */
		.wca-changelog .wca-accordion {
			border: 1px solid var(--wca-border);
			border-radius: var(--wca-radius-lg);
			margin-bottom: 16px;
			background: #f5f5f5;
			box-shadow: var(--wca-shadow-sm);
			overflow: hidden;
			transition: all 0.2s ease;
		}

		.wca-changelog .wca-accordion[open] {
			box-shadow: var(--wca-shadow-md);
		}

		.wca-changelog .wca-accordion summary {
			padding: 16px 20px;
			cursor: pointer;
			font-weight: 600;
			font-size: 15px;
			color: var(--wca-text-main);
			border: none;
			background: transparent;
			list-style: none;
			display: flex;
			align-items: center;
			justify-content: space-between;
			transition: background-color 0.2s ease;
		}

		.wca-changelog .wca-accordion summary:hover {
			background: var(--wca-surface-secondary);
		}

		.wca-changelog .wca-accordion summary::-webkit-details-marker {
			display: none;
		}

		.wca-changelog .wca-summary-caret {
			display: inline-block;
			margin-right: 8px;
			font-size: 12px;
			transition: transform 0.2s ease;
			color: var(--wca-text-muted);
		}

		.wca-changelog .wca-accordion[open] .wca-summary-caret {
			transform: rotate(90deg);
		}

		.wca-changelog .wca-accordion ul {
			padding: 20px 37px 30px;
			margin: 0;
		}

		/* Loading animation for buttons */
		.wca-whats-new-page .button-primary.wca-loading {
			position: relative;
			color: transparent !important;
			pointer-events: none;
		}

		.wca-whats-new-page .button-primary.wca-loading::after {
			content: '';
			position: absolute;
			top: 50%;
			left: 50%;
			width: 16px;
			height: 16px;
			margin: -8px 0 0 -8px;
			border: 2px solid #ffffff;
			border-radius: 50%;
			border-top-color: transparent;
			animation: wca-spin 1s linear infinite;
		}

		/* Inline notes */
		.wca-inline-note {
			background: var(--wca-surface-secondary);
			border: 1px solid var(--wca-border);
			border-radius: var(--wca-radius-md);
			padding: 12px 16px;
			margin: 16px 0;
			font-size: 14px;
			color: var(--wca-text-muted);
		}

		.wca-inline-note p {
			display: inline-flex;
			margin: 0 10px 0 0;
		}

		.wca-inline-note strong {
			color: var(--wca-text-main);
		}

		.wca-inline-note-margin-top {
			margin-top: 20px;
		}

		/* Changelog specific styles */
		.wca-changelog-intro {
			max-width: 640px;
			margin-bottom: 28px;
			color: #50575e;
		}

		.wca-changelog .changelog-grid {
			display: grid;
			gap: 16px;
		}

		.wca-changelog .wca-highlights {
			background: #fff;
			border: 1px solid var(--wca-border);
			border-radius: var(--wca-radius-lg);
			padding: 20px;
		}

		.wca-changelog .wca-chip {
			display: inline-flex;
			align-items: center;
			gap: 8px;
			background: var(--wca-surface-secondary);
			padding: 6px 12px;
			border-radius: 16px;
			font-size: 13px;
			font-weight: 600;
			color: var(--wca-text-main);
			margin-bottom: 16px;
		}

		.wca-changelog .wca-chip .dot {
			width: 8px;
			height: 8px;
			border-radius: 50%;
			background: var(--wp-admin-theme-color);
		}

		.wca-changelog .ul-disc {
			margin: 0;
			padding-left: 20px;
		}

		.wca-changelog .ul-disc li {
			margin-bottom: 8px;
			line-height: 1.6;
			padding-left: 4px;
		}

		.wca-changelog .ul-disc li:last-child {
			margin-bottom: 0;
		}

		/* Accordion caret positioning for changelog */
		.wca-changelog .wca-accordion summary {
			padding-right: 40px;
		}

		.wca-changelog .wca-summary-caret {
			position: absolute;
			right: 20px;
			top: 50%;
			transform: translateY(-50%);
		}

		.wca-changelog .wca-accordion[open] .wca-summary-caret {
			transform: translateY(-50%) rotate(90deg);
		}

		/* Full changelog footer - uniform with feedback footer */
		.wca-full-changelog-footer {
			margin-top: 40px;
		}

		.wca-full-changelog-button {
			display: inline-flex;
			align-items: center;
			gap: 8px;
		}

		.wca-button-arrow {
			transition: transform 0.2s ease;
		}

		.wca-full-changelog-button:hover .wca-button-arrow {
			transform: translateX(2px);
		}

		/* Code examples grid */
		.wca-code-examples-grid {
			margin-top: 32px;
			display: grid;
			grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
			gap: 20px;
		}

		.wca-code-example-card {
			padding: 20px;
			background: #f6f7f7;
			border-radius: 12px;
			border-left: 4px solid var(--wp-admin-theme-color, #2271b1);
		}

		.wca-code-example-card p {
			margin: 0 0 12px;
			font-weight: 600;
			color: #101517;
			font-size: 15px;
		}

		.wca-code-example-card p.wca-code-label {
			margin: 0 0 6px;
			font-size: 13px;
			color: #50575e;
			font-weight: 500;
		}

		.wca-code-example-card code {
			display: block;
			padding: 10px 12px;
			background: #fff;
			border-radius: 6px;
			font-size: 13px;
			margin-bottom: 12px;
			color: #d63638;
			font-family: 'SFMono-Regular', Consolas, 'Liberation Mono', Menlo, monospace;
			white-space: pre-wrap;
			word-break: break-word;
			overflow-x: auto;
			border: 1px solid #e0e4e7;
		}

		.wca-code-example-card code.wca-success {
			color: #2e7d32;
			margin: 0;
		}

		.wca-code-examples-footer {
			margin-top: 24px;
			font-size: 14px;
			color: #646970;
			line-height: 1.6;
			text-align: left;
		}

		@media (min-width: 768px) {
			.wca-whats-new-page {
				margin: 40px auto;
				max-width: 900px;
				padding: 0 40px;
			}

			.wca-mobile-nav-select {
				display: none;
			}

			.wca-whats-new-page .nav-tab-wrapper {
				display: flex;
			}

			.about-header {
				display: grid;
				grid-template-columns: 1.2fr 1fr;
				gap: 60px;
				align-items: center;
			}

			.has-2-columns {
				display: grid;
				grid-template-columns: 1fr 1fr;
				gap: 48px;
			}
			
			.has-2-columns.is-wider-right {
				grid-template-columns: 1fr 1.4fr;
			}
			
			.has-2-columns.is-wider-left {
				grid-template-columns: 1.4fr 1fr;
			}

			.wca-improvements-nav {
				grid-template-columns: repeat(4, 1fr);
				gap: 16px;
			}
			
			.wca-improvements-nav-item {
				padding: 24px;
				height: 100%;
			}

			.wca-connector {
				display: block;
			}

			.wca-cta-links {
				flex-direction: row;
				align-items: center;
				justify-content: flex-start;
			}
			
			.wca-cta-links .button,
			.wca-cta-links .button-primary {
				width: auto;
			}
		}
	</style>

	<div class="about-header">
		<div class="about-header-title">
			<div class="wca-version-pill">
				<span class="wca-dot" aria-hidden="true"></span>
				<?php printf('New in %s', esc_html(WC_APPOINTMENTS_VERSION)); ?>
			</div>
			<h1><?php echo esc_html('Welcome to WooCommerce Appointments'); ?></h1>
			<p class="about-text" style="font-size: 18px; color: #50575e;"><?php echo esc_html('A powerful update focused on stability, speed, and a better admin experience.'); ?></p>
		</div>
		<div class="about-header-graphic" aria-hidden="true">
			<svg viewBox="0 0 360 240" role="img" focusable="false">
				<defs>
					<linearGradient id="wcaWpGradient" x1="0%" y1="0%" x2="100%" y2="100%">
						<stop offset="0%" stop-color="var(--wp-admin-theme-color, #2271b1)" stop-opacity="0.95" />
						<stop offset="100%" stop-color="var(--wp-admin-theme-color, #2271b1)" stop-opacity="0.5" />
					</linearGradient>
				</defs>
				<rect x="26" y="32" width="308" height="28" rx="8" fill="var(--wp-admin-theme-color, #2271b1)" />
				<circle cx="44" cy="46" r="5" fill="#f6f7f7" opacity="0.85" />
				<circle cx="60" cy="46" r="5" fill="#f6f7f7" opacity="0.65" />
				<rect x="80" y="40" width="84" height="12" rx="6" fill="var(--wp-admin-theme-color, #2271b1)"
					opacity="0.5" />

				<!-- Calendar grid -->
				<rect x="32" y="78" width="146" height="116" rx="10" fill="#fff" stroke="#e0e4e7" stroke-width="1.5" />
				<?php
				// Generate calendar squares (4 rows x 5 cols)
				for ($r = 0; 4 > $r; $r++) {
					for ($c = 0; 5 > $c; $c++) {
						$x = 42 + ($c * 27);
						$y = 92 + ($r * 26);
						$highlight = (1 === $r && 2 === $c);
						$fill = $highlight ? '#e8f1fb' : '#f6f7f7';
						$stroke = $highlight ? 'var(--wp-admin-theme-color, #2271b1)' : '#d8dadd';
						echo '<rect x="' . esc_attr($x) . '" y="' . esc_attr($y) . '" width="22" height="18" rx="4" fill="' . esc_attr($fill) . '" stroke="' . esc_attr($stroke) . '" stroke-width="1"/>';
					}
				}
				?>

				<!-- Appointment card and drag path -->
				<rect x="200" y="86" width="126" height="44" rx="10" fill="url(#wcaWpGradient)" opacity="0.15"
					stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="1.5" />
				<rect x="206" y="94" width="72" height="10" rx="5" fill="var(--wp-admin-theme-color, #2271b1)"
					opacity="0.8" />
				<rect x="206" y="112" width="44" height="8" rx="4" fill="var(--wp-admin-theme-color, #2271b1)"
					fill-opacity="0.5" />
				<path d="M168 118 C190 118, 200 118, 206 118" stroke="var(--wp-admin-theme-color, #2271b1)"
					stroke-width="3" stroke-dasharray="5 4" stroke-linecap="round" />
				<circle cx="168" cy="118" r="6" fill="var(--wp-admin-theme-color, #2271b1)" />
				<path d="M164 114 L172 122 M172 114 L164 122" stroke="#f6f7f7" stroke-width="2"
					stroke-linecap="round" />

				<!-- Drag handle -->
				<path d="M240 136 L252 150" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="3.5"
					stroke-linecap="round" />
				<circle cx="252" cy="150" r="7" fill="var(--wp-admin-theme-color, #2271b1)" />
				<path d="M248 146 L256 154 M256 146 L248 154" stroke="#f6f7f7" stroke-width="2"
					stroke-linecap="round" />

				<!-- Clock for time awareness -->
				<circle cx="120" cy="170" r="24" fill="#fff" stroke="var(--wp-admin-theme-color, #2271b1)"
					stroke-width="2" />
				<path d="M120 170 L120 154" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="3"
					stroke-linecap="round" />
				<path d="M120 170 L134 176" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="3"
					stroke-linecap="round" />
				<circle cx="120" cy="170" r="3" fill="var(--wp-admin-theme-color, #2271b1)" />

				<!-- Speed lines -->
				<path d="M214 64 H270" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5"
					stroke-width="4" stroke-linecap="round" />
				<path d="M226 58 H258" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="4"
					stroke-linecap="round" />
				<path d="M238 50 H248" stroke="#1d2327" stroke-width="3" stroke-linecap="round" opacity="0.6" />
			</svg>
		</div>
	</div>

	<!-- Mobile Navigation Select -->
	<select class="wca-mobile-nav-select" aria-label="<?php echo esc_attr('Select section'); ?>">
		<option value="improvements"><?php echo esc_html('Improvements'); ?> <?php echo esc_html('NEW'); ?></option>
		<option value="new-calendar"><?php echo esc_html('New Features'); ?> <?php echo esc_html('NEW'); ?></option>
		<option value="documentation"><?php echo esc_html('Documentation'); ?></option>
		<option value="future"><?php echo esc_html('What\'s Next'); ?></option>
		<option value="changelog"><?php echo esc_html('Changelog'); ?></option>
	</select>

	<nav class="nav-tab-wrapper wp-clearfix" aria-label="<?php echo esc_attr('Secondary menu'); ?>">
		<a href="#improvements" class="nav-tab nav-tab-active"><?php echo esc_html('Improvements'); ?><span
				class="wca-new-badge"></span></a>
		<a href="#new-calendar" class="nav-tab"><?php echo esc_html('New Features'); ?><span
				class="wca-new-badge"></span></a>
		<a href="#documentation" class="nav-tab"><?php echo esc_html('Documentation'); ?></a>
		<a href="#future" class="nav-tab"><?php echo esc_html('What\'s Next'); ?></a>
		<a href="#changelog" class="nav-tab"><?php echo esc_html('Changelog'); ?></a>
	</nav>

	<div id="improvements" class="about-section">
		<div class="wca-improvements-nav" role="tablist" aria-label="<?php echo esc_attr('Improvement categories'); ?>">
			<a href="#export-improvements" class="wca-improvements-nav-item is-active" role="tab" aria-selected="true"
				data-target="export-improvements">
				<div class="wca-chip"><span class="dot" aria-hidden="true"></span><?php echo esc_html('Export'); ?>
				</div><span class="wca-new-badge"></span>
				<h4><?php echo esc_html('Unified Export System'); ?></h4>
				<p><?php echo esc_html('CSV & ICS with unified filters'); ?></p>
			</a>
			<a href="#performance-improvements" class="wca-improvements-nav-item" role="tab" aria-selected="false" data-target="performance-improvements">
				<div class="wca-chip"><span class="dot" aria-hidden="true"></span><?php echo esc_html('Performance'); ?>
				</div><span class="wca-new-badge"></span>
				<h4><?php echo esc_html('Blazing Fast Queries'); ?></h4>
				<p><?php echo esc_html('10x faster with smart indexing'); ?></p>
			</a>
			<a href="#admin-improvements" class="wca-improvements-nav-item" role="tab" aria-selected="false" data-target="admin-improvements">
				<div class="wca-chip"><span class="dot" aria-hidden="true"></span><?php echo esc_html('Admin UX'); ?>
				</div><span class="wca-new-badge"></span>
				<h4><?php echo esc_html('Enhanced Admin Experience'); ?></h4>
				<p><?php echo esc_html('Better modal, calendar refinements'); ?></p>
			</a>
			<a href="#rest-api" class="wca-improvements-nav-item" role="tab" aria-selected="false"
				data-target="rest-api">
				<div class="wca-chip"><span class="dot" aria-hidden="true"></span><?php echo esc_html('API'); ?></div>
				<h4><?php echo esc_html('Build With the API'); ?></h4>
				<p><?php echo esc_html('Full CRUD & headless ready'); ?></p>
			</a>
		</div>
		<div class="wca-connector" id="wca-connector"></div>
		<div class="wca-improvements-content" id="wca-improvements-content">
		</div>
	</div>

	<div id="new-calendar" class="about-section is-hidden">
		<div class="has-2-columns is-wider-right">
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img" focusable="false" aria-hidden="true">
						<defs>
							<linearGradient id="wcaCalGrad" x1="0%" y1="0%" x2="100%" y2="100%">
								<stop offset="0%" stop-color="var(--wp-admin-theme-color, #2271b1)"
									stop-opacity="0.9" />
								<stop offset="100%" stop-color="var(--wp-admin-theme-color, #2271b1)"
									stop-opacity="0.5" />
							</linearGradient>
						</defs>
						<rect x="18" y="18" width="284" height="164" rx="14" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />
						<rect x="34" y="34" width="252" height="20" rx="6"
							fill="var(--wp-admin-theme-color, #2271b1)" />
						<rect x="44" y="38" width="78" height="8" rx="4" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.5" />
						<!-- Calendar grid -->
						<?php
						for ($r = 0; 3 > $r; $r++) {
							for ($c = 0; 6 > $c; $c++) {
								$x = 34 + ($c * 40);
								$y = 66 + ($r * 34);
								$highlight = (1 === $r && 2 === $c);
								$fill = $highlight ? '#e8f1fb' : '#ffffff';
								$stroke = $highlight ? 'var(--wp-admin-theme-color, #2271b1)' : '#d8dadd';
								echo '<rect x="' . esc_attr($x) . '" y="' . esc_attr($y) . '" width="32" height="26" rx="6" fill="' . esc_attr($fill) . '" stroke="' . esc_attr($stroke) . '" stroke-width="1.2"/>';
							}
						}
						?>
						<!-- Event chips -->
						<rect x="158" y="72" width="90" height="12" rx="6" fill="url(#wcaCalGrad)" opacity="0.9" />
						<rect x="158" y="90" width="68" height="10" rx="5" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.7" />
						<!-- Drag/resize cue -->
						<path d="M210 120 L244 142" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="3.5"
							stroke-linecap="round" stroke-dasharray="6 4" />
						<circle cx="244" cy="142" r="7" fill="var(--wp-admin-theme-color, #2271b1)" />
						<path d="M240 138 L248 146 M248 138 L240 146" stroke="#f6f7f7" stroke-width="2"
							stroke-linecap="round" />
						<!-- Speed lines -->
						<path d="M70 154 H126" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5"
							stroke-width="4" stroke-linecap="round" />
						<path d="M82 162 H132" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="4"
							stroke-linecap="round" opacity="0.8" />
					</svg>
				</div>
			</div>
			<div class="column">
				<h2><?php echo esc_html('A Modern Calendar Experience'); ?> <span class="wca-new-badge"></span></h2>
				<p><?php echo esc_html('Say goodbye to page reloads. The new admin calendar is built entirely with React, delivering an app-like experience right inside WordPress. It’s fluid, responsive, and designed to keep up with your busiest days.'); ?>
				</p>
				<p><?php echo esc_html('Whether you’re rescheduling an appointment or checking staff availability, interactions are instant. We’ve decluttered the interface to focus on what matters most—your schedule.'); ?>
				</p>
				<div class="wca-cta-links">
					<a class="button button-primary"
						href="<?php echo esc_url(admin_url('edit.php?post_type=wc_appointment&page=appointment_calendar')); ?>">
						<?php echo esc_html('Open the new Calendar'); ?>
					</a>
				</div>
			</div>
		</div>

		<hr />

		<div class="has-2-columns is-wider-left">
			<div class="column">
				<h3><?php echo esc_html('Inline Creating & Editing'); ?></h3>
				<p><?php echo esc_html('Click any slot to create or edit appointments instantly. No more navigating away to separate screens just to make a quick change. You can update appointment status and change times directly from the calendar view by simple drag & drop or resize action.'); ?>
				</p>
				<div class="wca-cta-links">
					<a href="#" class="button button-secondary wc-appointment-modal-trigger">
						<?php echo esc_html('Create an appointment inline', 'woocommerce-appointments'); ?>
					</a>
				</div>
			</div>
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img" focusable="false" aria-hidden="true">
						<rect x="18" y="24" width="284" height="152" rx="14" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />
						<rect x="30" y="36" width="90" height="10" rx="5" fill="var(--wp-admin-theme-color, #2271b1)" />
						<rect x="30" y="52" width="64" height="8" rx="4" fill="var(--wp-admin-theme-color, #2271b1)"
							fill-opacity="0.5" />
						<rect x="30" y="68" width="120" height="10" rx="5" fill="#d8dadd" />

						<!-- Row items -->
						<rect x="30" y="92" width="260" height="14" rx="6" fill="#fff" stroke="#e1e4e8"
							stroke-width="1" />
						<rect x="30" y="116" width="260" height="14" rx="6" fill="#fff" stroke="#e1e4e8"
							stroke-width="1" />

						<!-- Inline editor card -->
						<rect x="146" y="82" width="134" height="72" rx="10" fill="#ffffff"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="1.4" />
						<rect x="158" y="92" width="84" height="10" rx="5" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.9" />
						<rect x="158" y="110" width="104" height="10" rx="5" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.5" />
						<rect x="158" y="128" width="64" height="10" rx="5" fill="#d8dadd" />
						<rect x="230" y="126" width="36" height="12" rx="6"
							fill="var(--wp-admin-theme-color, #2271b1)" />

						<!-- Drag indicator -->
						<path d="M110 124 L146 124" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="3"
							stroke-dasharray="5 4" stroke-linecap="round" />
						<circle cx="110" cy="124" r="6" fill="var(--wp-admin-theme-color, #2271b1)" />
						<path d="M106 120 L114 128 M114 120 L106 128" stroke="#f6f7f7" stroke-width="2"
							stroke-linecap="round" />
					</svg>
				</div>
			</div>
		</div>

		<hr />

		<div class="has-2-columns is-wider-right">
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img" focusable="false" aria-hidden="true">
						<rect x="18" y="22" width="284" height="156" rx="14" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />
						<rect x="32" y="36" width="80" height="12" rx="6" fill="var(--wp-admin-theme-color, #2271b1)" />
						<rect x="120" y="36" width="72" height="12" rx="6" fill="var(--wp-admin-theme-color, #2271b1)"
							fill-opacity="0.5" />
						<rect x="208" y="36" width="70" height="12" rx="6" fill="#d8dadd" />

						<!-- Filter chips -->
						<rect x="32" y="60" width="90" height="16" rx="8" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.9" />
						<rect x="32" y="82" width="70" height="14" rx="7" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.5" />
						<rect x="32" y="102" width="62" height="14" rx="7" fill="#d8dadd" />

						<!-- Results list -->
						<rect x="128" y="64" width="154" height="14" rx="7" fill="#ffffff" stroke="#e1e4e8"
							stroke-width="1" />
						<rect x="128" y="86" width="154" height="14" rx="7" fill="#ffffff" stroke="#e1e4e8"
							stroke-width="1" />
						<rect x="128" y="108" width="154" height="14" rx="7" fill="#ffffff" stroke="#e1e4e8"
							stroke-width="1" />

						<!-- Active filter indicator -->
						<path d="M124 72 L116 64" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="3"
							stroke-linecap="round" />
						<circle cx="116" cy="64" r="6" fill="var(--wp-admin-theme-color, #2271b1)" />
						<path d="M112 60 L120 68 M120 60 L112 68" stroke="#f6f7f7" stroke-width="2"
							stroke-linecap="round" />

						<!-- Speed lines -->
						<path d="M180 138 H242" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5"
							stroke-width="4" stroke-linecap="round" />
						<path d="M194 148 H232" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="4"
							stroke-linecap="round" opacity="0.8" />
					</svg>
				</div>
			</div>
			<div class="column">
				<h3><?php echo esc_html('Smart Filtering & Views'); ?></h3>
				<p><?php echo esc_html('Find exactly what you need with improved filters for staff and products. The new view switching is faster and more intuitive, allowing you to drill down into specific appointments without losing context.'); ?>
				</p>
			</div>
		</div>

		<hr />

		<div class="has-2-columns is-wider-left">
			<div class="column">
				<h3><?php echo esc_html('Contextual Actions'); ?></h3>
				<p><?php echo esc_html('Select an appointment to surface the quick action menu—cancel, confirm, or jump to the order without leaving the calendar view. Stay in flow and handle updates in seconds.'); ?>
				</p>
			</div>
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img" focusable="false" aria-hidden="true">
						<rect x="18" y="22" width="284" height="156" rx="14" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />
						<!-- Card -->
						<rect x="36" y="48" width="180" height="52" rx="10" fill="#ffffff" stroke="#e1e4e8"
							stroke-width="1" />
						<rect x="48" y="58" width="96" height="10" rx="5" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.9" />
						<rect x="48" y="74" width="80" height="8" rx="4" fill="var(--wp-admin-theme-color, #2271b1)"
							fill-opacity="0.5" />

						<!-- Hover action menu -->
						<rect x="206" y="50" width="76" height="70" rx="10" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.96" />
						<rect x="216" y="62" width="52" height="10" rx="5" fill="#f6f7f7" opacity="0.95" />
						<rect x="216" y="78" width="48" height="8" rx="4" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.5" />
						<rect x="216" y="94" width="44" height="8" rx="4" fill="#d8dadd" opacity="0.9" />

						<!-- Hover cursor -->
						<path d="M96 118 L118 154 L128 130 L146 140 L96 118 Z"
							fill="var(--wp-admin-theme-color, #2271b1)" opacity="0.9" />
						<path d="M128 130 L136 146" stroke="#1d2327" stroke-width="3" stroke-linecap="round"
							opacity="0.6" />

						<!-- Speed lines -->
						<path d="M60 152 H126" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5"
							stroke-width="4" stroke-linecap="round" />
						<path d="M72 162 H118" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="4"
							stroke-linecap="round" opacity="0.8" />
					</svg>
				</div>
			</div>
		</div>
	</div>

	<div id="export-improvements" class="about-section wca-improvement-subsection" style="margin-top: 0;">
		<div class="has-2-columns is-wider-right">
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img" focusable="false" aria-hidden="true">
						<rect x="18" y="22" width="284" height="156" rx="14" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />
						<!-- Export form -->
						<rect x="34" y="38" width="252" height="124" rx="10" fill="#ffffff" stroke="#e1e4e8"
							stroke-width="1" />
						<rect x="48" y="50" width="120" height="12" rx="6" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.9" />
						<rect x="48" y="70" width="80" height="10" rx="5" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.5" />
						<!-- Format dropdown -->
						<rect x="48" y="90" width="100" height="24" rx="6" fill="#f6f7f7"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="1.5" />
						<rect x="52" y="96" width="60" height="8" rx="4" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.8" />
						<path d="M142 104 L150 96 L158 104" stroke="var(--wp-admin-theme-color, #2271b1)"
							stroke-width="2" fill="none" stroke-linecap="round" />
						<!-- Options -->
						<rect x="48" y="124" width="92" height="8" rx="4" fill="#d8dadd" opacity="0.6" />
						<rect x="48" y="138" width="76" height="8" rx="4" fill="#d8dadd" opacity="0.6" />
						<!-- Export button -->
						<rect x="180" y="138" width="90" height="28" rx="6"
							fill="var(--wp-admin-theme-color, #2271b1)" />
						<rect x="192" y="146" width="66" height="10" rx="5" fill="#f6f7f7" />
						<!-- File icons -->
						<rect x="220" y="70" width="48" height="48" rx="6" fill="#e8f5e9" stroke="#4caf50"
							stroke-width="1.5" opacity="0.8" />
						<rect x="234" y="84" width="20" height="20" rx="3" fill="#4caf50" opacity="0.6" />
						<rect x="240" y="90" width="8" height="8" rx="2" fill="#ffffff" />
						<rect x="250" y="90" width="8" height="8" rx="2" fill="#ffffff" />
					</svg>
				</div>
			</div>
			<div class="column">
				<h2><?php echo esc_html('Enhanced Export System'); ?> <span class="wca-new-badge"></span></h2>
				<p><?php echo esc_html('Version 5.1 introduces a completely redesigned export system with unified interface architecture and support for multiple export formats.'); ?>
				</p>
				<p><?php echo esc_html('Export your appointments in CSV format for spreadsheet analysis or ICS format for calendar applications—all from a single, intuitive interface.'); ?>
				</p>
				<div class="wca-cta-links">
					<a class="button button-primary"
						href="<?php echo esc_url(admin_url('edit.php?post_type=wc_appointment&page=appointment_exporter')); ?>">
						<?php echo esc_html('Try Export Now'); ?>
					</a>
				</div>
			</div>
		</div>

		<hr />

		<div class="has-2-columns is-wider-left">
			<div class="column">
				<h3><?php echo esc_html('Format Selection'); ?> <span class="wca-new-badge"></span></h3>
				<p><?php echo esc_html('Choose between CSV and ICS export formats directly from the export page. CSV exports are perfect for data analysis in Excel or Google Sheets, while ICS exports create calendar files compatible with Apple Calendar, Google Calendar, and Outlook.'); ?>
				</p>
				<ul class="ul-disc">
					<li><strong><?php echo esc_html('CSV Export:'); ?></strong>
						<?php echo esc_html('Full appointment data with customizable columns, perfect for reporting and analysis.'); ?>
					</li>
					<li><strong><?php echo esc_html('ICS Export:'); ?></strong>
						<?php echo esc_html('Calendar-ready files that can be imported into any calendar application.'); ?>
					</li>
				</ul>
			</div>
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img" focusable="false" aria-hidden="true">
						<rect x="18" y="22" width="284" height="156" rx="14" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />
						<!-- CSV file -->
						<rect x="48" y="50" width="100" height="64" rx="8" fill="#ffffff" stroke="#2271b1"
							stroke-width="1.5" />
						<rect x="60" y="62" width="76" height="8" rx="4" fill="#2271b1" opacity="0.8" />
						<rect x="60" y="76" width="68" height="6" rx="3" fill="#d8dadd" />
						<rect x="60" y="86" width="72" height="6" rx="3" fill="#d8dadd" />
						<rect x="60" y="96" width="64" height="6" rx="3" fill="#d8dadd" />
						<!-- ICS file -->
						<rect x="172" y="50" width="100" height="64" rx="8" fill="#ffffff" stroke="#4caf50"
							stroke-width="1.5" />
						<rect x="184" y="62" width="76" height="8" rx="4" fill="#4caf50" opacity="0.8" />
						<rect x="184" y="76" width="68" height="6" rx="3" fill="#d8dadd" />
						<rect x="184" y="86" width="72" height="6" rx="3" fill="#d8dadd" />
						<rect x="184" y="96" width="64" height="6" rx="3" fill="#d8dadd" />
						<!-- Arrow -->
						<path d="M148 82 L164 82" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="3"
							stroke-linecap="round" />
					</svg>
				</div>
			</div>
		</div>

		<hr />

		<div class="has-2-columns is-wider-right">
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img"
						aria-label="<?php echo esc_attr('Filter options interface with date range, product, staff filters and add-ons checkbox'); ?>"
						focusable="false">
						<!-- Background container -->
						<rect x="20" y="20" width="280" height="160" rx="12" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />

						<!-- Filter panel -->
						<rect x="36" y="36" width="248" height="128" rx="8" fill="#ffffff" stroke="#e1e4e8"
							stroke-width="1.5" />

						<!-- Header -->
						<rect x="48" y="44" width="100" height="10" rx="5" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.9" />

						<!-- Date range filter -->
						<rect x="48" y="64" width="224" height="22" rx="4" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1" />
						<rect x="54" y="70" width="50" height="6" rx="3" fill="#646970" />
						<rect x="110" y="70" width="40" height="6" rx="3" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.6" />
						<rect x="156" y="70" width="40" height="6" rx="3" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.6" />

						<!-- Product filter -->
						<rect x="48" y="94" width="224" height="22" rx="4" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1" />
						<rect x="54" y="100" width="60" height="6" rx="3" fill="#646970" />
						<rect x="120" y="100" width="80" height="6" rx="3" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.6" />

						<!-- Staff filter -->
						<rect x="48" y="124" width="224" height="22" rx="4" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1" />
						<rect x="54" y="130" width="56" height="6" rx="3" fill="#646970" />
						<rect x="116" y="130" width="70" height="6" rx="3" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.6" />

						<!-- Add-ons checkbox -->
						<rect x="48" y="152" width="18" height="18" rx="4" fill="#ffffff"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="2" />
						<path d="M52 156 L58 162 L66 152" stroke="var(--wp-admin-theme-color, #2271b1)"
							stroke-width="2.5" fill="none" stroke-linecap="round" stroke-linejoin="round" />
						<rect x="74" y="155" width="80" height="8" rx="4" fill="#646970" />
					</svg>
				</div>
			</div>
			<div class="column">
				<h3><?php echo esc_html('Unified Filter Options'); ?> <span class="wca-new-badge"></span></h3>
				<p><?php echo esc_html('Both CSV and ICS exports now support the same comprehensive filter options, giving you complete control over what gets exported.'); ?>
				</p>
				<ul class="ul-disc">
					<li><strong><?php echo esc_html('Date Range:'); ?></strong>
						<?php echo esc_html('Filter appointments by start and end dates.'); ?></li>
					<li><strong><?php echo esc_html('Product Filter:'); ?></strong>
						<?php echo esc_html('Export appointments for specific products only.'); ?></li>
					<li><strong><?php echo esc_html('Staff Filter:'); ?></strong>
						<?php echo esc_html('Export appointments for specific staff members.'); ?></li>
					<li><strong><?php echo esc_html('Add-ons Support:'); ?></strong>
						<?php echo esc_html('Optionally include product add-on data in both CSV and ICS exports.'); ?>
					</li>
				</ul>
			</div>
		</div>

		<hr />

		<div class="has-2-columns is-wider-left">
			<div class="column">
				<h2><?php echo esc_html('Improved Architecture'); ?> <span class="wca-new-badge"></span></h2>
				<p><?php echo esc_html('Version 5.1 brings significant code architecture improvements that make the plugin more maintainable, performant, and developer-friendly. We\'ve refactored core systems, optimized database queries, and introduced better code patterns throughout.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('Centralized constants eliminate magic strings and improve code clarity.'); ?>
					</li>
					<li><?php echo esc_html('Dedicated booking handler class with exponential backoff retry mechanism prevents double bookings.'); ?>
					</li>
					<li><?php echo esc_html('Optimized database queries using EXISTS subqueries instead of JOINs for 60% faster performance.'); ?>
					</li>
					<li><?php echo esc_html('Improved PHPDoc and return types make code easier to understand and extend.'); ?>
					</li>
					<li><?php echo esc_html('Better file organization with single responsibility principle applied throughout.'); ?>
					</li>
				</ul>
			</div>
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img"
						aria-label="<?php echo esc_attr('Code architecture improvements showing organized classes, optimized queries, and better structure'); ?>"
						focusable="false">
						<!-- Background -->
						<rect x="20" y="20" width="280" height="160" rx="12" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />

						<!-- Constants class (top left) -->
						<rect x="32" y="32" width="110" height="48" rx="8" fill="#ffffff"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="2" />
						<rect x="42" y="40" width="90" height="9" rx="4" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.9" />
						<rect x="42" y="54" width="70" height="7" rx="3" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.6" />
						<rect x="42" y="65" width="60" height="7" rx="3" fill="#d8dadd" opacity="0.7" />

						<!-- Booking Handler (top right) -->
						<rect x="158" y="32" width="110" height="48" rx="8" fill="#ffffff" stroke="#4caf50"
							stroke-width="2" />
						<rect x="168" y="40" width="90" height="9" rx="4" fill="#4caf50" opacity="0.9" />
						<rect x="168" y="54" width="70" height="7" rx="3" fill="#4caf50" opacity="0.6" />
						<rect x="168" y="65" width="60" height="7" rx="3" fill="#d8dadd" opacity="0.7" />

						<!-- Optimized Query (middle left) -->
						<rect x="32" y="96" width="110" height="36" rx="6" fill="#e8f5e9" stroke="#4caf50"
							stroke-width="1.5" />
						<rect x="42" y="104" width="90" height="8" rx="4" fill="#4caf50" opacity="0.8" />
						<rect x="42" y="116" width="75" height="6" rx="3" fill="#4caf50" opacity="0.5" />

						<!-- Database icon (middle right) -->
						<rect x="158" y="96" width="110" height="36" rx="6" fill="#fff3cd" stroke="#f57c00"
							stroke-width="1.5" />
						<circle cx="213" cy="114" r="12" fill="none" stroke="#f57c00" stroke-width="2" />
						<rect x="201" y="114" width="24" height="2" fill="#f57c00" opacity="0.7" />
						<rect x="201" y="118" width="24" height="2" fill="#f57c00" opacity="0.5" />
						<rect x="201" y="122" width="24" height="2" fill="#f57c00" opacity="0.3" />

						<!-- Organized files (bottom) -->
						<rect x="32" y="148" width="72" height="24" rx="4" fill="#e8f1fb"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="1.5" />
						<rect x="38" y="154" width="60" height="6" rx="3" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.7" />
						<rect x="38" y="162" width="50" height="4" rx="2" fill="#d8dadd" opacity="0.6" />

						<rect x="116" y="148" width="72" height="24" rx="4" fill="#e8f1fb"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="1.5" />
						<rect x="122" y="154" width="60" height="6" rx="3" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.7" />
						<rect x="122" y="162" width="50" height="4" rx="2" fill="#d8dadd" opacity="0.6" />

						<rect x="200" y="148" width="68" height="24" rx="4" fill="#e8f1fb"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="1.5" />

						<!-- Connection arrows -->
						<path d="M142 56 L158 56" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="2.5"
							fill="none" stroke-linecap="round" marker-end="url(#archArrow)" />
						<path d="M87 80 L87 96" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="2.5"
							fill="none" stroke-linecap="round" marker-end="url(#archArrow)" />
						<path d="M213 80 L213 96" stroke="#4caf50" stroke-width="2.5" fill="none" stroke-linecap="round"
							marker-end="url(#archArrow)" />

						<!-- Success indicators -->
						<circle cx="280" cy="44" r="7" fill="#4caf50" />
						<path d="M277 44 L280 47 L283 40" stroke="#fff" stroke-width="1.8" fill="none"
							stroke-linecap="round" stroke-linejoin="round" />

						<circle cx="280" cy="114" r="7" fill="#4caf50" />
						<path d="M277 114 L280 117 L283 110" stroke="#fff" stroke-width="1.8" fill="none"
							stroke-linecap="round" stroke-linejoin="round" />

						<defs>
							<marker id="archArrow" markerWidth="7" markerHeight="7" refX="6" refY="3.5" orient="auto">
								<polygon points="0,0 7,3.5 0,7" fill="var(--wp-admin-theme-color, #2271b1)" />
							</marker>
						</defs>
					</svg>
				</div>
			</div>
		</div>

		<!-- Code examples spanning full width -->
		<div class="wca-code-examples-grid">
			<div class="wca-code-example-card">
				<p>
					<?php echo esc_html('Example 1: Constants Instead of Magic Strings'); ?>
				</p>
				<p class="wca-code-label">
					<?php echo esc_html('Before:'); ?>
				</p>
				<code>if ( $status === 'confirmed' ) { ... }</code>
				<p class="wca-code-label">
					<?php echo esc_html('After:'); ?>
				</p>
				<code class="wca-success">if ( $status === WC_Appointments_Constants::STATUS_CONFIRMED ) { ... }</code>
			</div>

			<div class="wca-code-example-card">
				<p>
					<?php echo esc_html('Example 2: Booking Handler Class'); ?>
				</p>
				<p class="wca-code-label">
					<?php echo esc_html('Before (scattered logic):'); ?>
				</p>
				<code>function create_appointment() {
  // 200+ lines of mixed logic
  // Lock handling, validation, creation
}</code>
				<p class="wca-code-label">
					<?php echo esc_html('After (organized classes):'); ?>
				</p>
				<code class="wca-success">$handler = new WC_Appointment_Booking_Handler();
$handler->create( $data );</code>
			</div>

			<div class="wca-code-example-card">
				<p>
					<?php echo esc_html('Example 3: Optimized Database Queries'); ?>
				</p>
				<p class="wca-code-label">
					<?php echo esc_html('Before (slow JOINs):'); ?>
				</p>
				<code>SELECT * FROM posts
LEFT JOIN postmeta ON ...
WHERE postmeta.meta_key = 'status'</code>
				<p class="wca-code-label">
					<?php echo esc_html('After (fast EXISTS):'); ?>
				</p>
				<code class="wca-success">SELECT * FROM posts
WHERE EXISTS (
  SELECT 1 FROM postmeta
  WHERE postmeta.post_id = posts.ID
  AND postmeta.meta_key = 'status'
)</code>
			</div>

			<div class="wca-code-example-card">
				<p>
					<?php echo esc_html('Example 4: Clear Return Types'); ?>
				</p>
				<p class="wca-code-label">
					<?php echo esc_html('Before:'); ?>
				</p>
				<code>function get_statuses() {
  return [...];
}</code>
				<p class="wca-code-label">
					<?php echo esc_html('After:'); ?>
				</p>
				<code class="wca-success">/**
 * @return array<string> Valid appointment statuses
 */
function get_statuses(): array {
  return WC_Appointments_Constants::get_appointment_statuses();
}</code>
			</div>
		</div>

		<p class="wca-code-examples-footer">
			<?php echo esc_html('These architectural improvements make the codebase more maintainable, reduce bugs, improve performance, and help both developers and AI tools understand the code better.'); ?>
		</p>
	</div>

	<div id="performance-improvements" class="about-section wca-improvement-subsection is-hidden">
		<div class="has-2-columns is-wider-right">
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img" focusable="false" aria-hidden="true">
						<!-- Background -->
						<rect x="20" y="20" width="280" height="160" rx="12" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />

						<!-- Database with index indicators -->
						<rect x="36" y="36" width="100" height="80" rx="8" fill="#ffffff"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="2" />
						<rect x="46" y="46" width="80" height="8" rx="4" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.9" />
						<rect x="46" y="58" width="60" height="6" rx="3" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.6" />
						
						<!-- Index bars -->
						<rect x="46" y="70" width="75" height="4" rx="2" fill="#4caf50" opacity="0.8" />
						<rect x="46" y="76" width="65" height="4" rx="2" fill="#4caf50" opacity="0.7" />
						<rect x="46" y="82" width="70" height="4" rx="2" fill="#4caf50" opacity="0.6" />
						<rect x="46" y="88" width="80" height="4" rx="2" fill="#4caf50" opacity="0.5" />

						<!-- Query optimization -->
						<rect x="154" y="36" width="130" height="80" rx="8" fill="#e8f5e9" stroke="#4caf50"
							stroke-width="2" />
						<rect x="164" y="46" width="110" height="8" rx="4" fill="#4caf50" opacity="0.9" />
						<rect x="164" y="58" width="90" height="6" rx="3" fill="#4caf50" opacity="0.7" />
						
						<!-- Performance metrics -->
						<circle cx="180" cy="80" r="16" fill="#ffffff" stroke="#4caf50" stroke-width="2" />
						<path d="M180 70 L180 80 L188 88" stroke="#4caf50" stroke-width="2" 
							stroke-linecap="round" fill="none" />
						<text x="180" y="84" text-anchor="middle" fill="#4caf50" font-size="10" font-weight="bold">10x</text>

						<!-- Speed lines -->
						<path d="M80 140 H240" stroke="#4caf50" stroke-opacity="0.6"
							stroke-width="3" stroke-linecap="round" />
						<path d="M100 150 H220" stroke="#4caf50" stroke-width="3"
							stroke-linecap="round" opacity="0.8" />
						<path d="M120 160 H200" stroke="#4caf50" stroke-width="3"
							stroke-linecap="round" opacity="0.6" />
					</svg>
				</div>
			</div>
			<div class="column">
				<h3><?php echo esc_html('Blazing Fast Performance'); ?> <span class="wca-new-badge"></span></h3>
				<p><?php echo esc_html('Version 5.1 delivers massive performance improvements with smart indexing and query optimization. Appointment queries are now up to 10x faster, even with millions of records.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('Automatic composite indexes on postmeta table for lightning-fast queries.'); ?>
					</li>
					<li><?php echo esc_html('Query optimization using EXISTS subqueries instead of JOINs where possible.'); ?>
					</li>
					<li><?php echo esc_html('Optimized get_qty_input_max() with UNION instead of OR conditions.'); ?>
					</li>
					<li><?php echo esc_html('Reduced appointment lookup queries from 3 JOINs to 1 JOIN + 2 EXISTS.'); ?>
					</li>
					<li><?php echo esc_html('Index health monitoring with automatic verification and logging.'); ?>
					</li>
				</ul>
			</div>
		</div>

		<hr />

		<div class="has-2-columns is-wider-left">
			<div class="column">
				<h3><?php echo esc_html('Atomic Booking Locks'); ?> <span class="wca-new-badge"></span></h3>
				<p><?php echo esc_html('Prevent double bookings and race conditions with exponential backoff retry mechanism. Handles high-traffic scenarios gracefully.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('Exponential backoff prevents system overload.'); ?></li>
					<li><?php echo esc_html('Automatic retry with configurable attempts.'); ?></li>
					<li><?php echo esc_html('Zero performance impact on normal operations.'); ?></li>
				</ul>
			</div>
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img" focusable="false" aria-hidden="true">
						<!-- Background -->
						<rect x="20" y="20" width="280" height="160" rx="12" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />

						<!-- Lock icon with success state -->
						<rect x="140" y="70" width="40" height="32" rx="4" fill="#e8f5e9" stroke="#4caf50"
							stroke-width="2" />
						<path d="M150 70 v-8 a10 10 0 0 1 20 0 v8" stroke="#4caf50" stroke-width="2" 
							fill="none" stroke-linecap="round" />
						<circle cx="160" cy="82" r="3" fill="#4caf50" />
						<path d="M160 82 v4 l2 2" stroke="#4caf50" stroke-width="1.5" 
							stroke-linecap="round" fill="none" />

						<!-- Retry indicators -->
						<circle cx="100" cy="86" r="8" fill="#fff3cd" stroke="#f57c00" stroke-width="1.5" />
						<text x="100" y="89" text-anchor="middle" fill="#f57c00" font-size="8" font-weight="bold">1</text>
						
						<circle cx="120" cy="86" r="8" fill="#fff3cd" stroke="#f57c00" stroke-width="1.5" />
						<text x="120" y="89" text-anchor="middle" fill="#f57c00" font-size="8" font-weight="bold">2</text>
						
						<circle cx="220" cy="86" r="8" fill="#e8f5e9" stroke="#4caf50" stroke-width="1.5" />
						<text x="220" y="89" text-anchor="middle" fill="#4caf50" font-size="8" font-weight="bold">✓</text>

						<!-- Connection lines -->
						<path d="M108 86 L132 86" stroke="#f57c00" stroke-width="2" 
							stroke-dasharray="3 2" opacity="0.6" />
						<path d="M128 86 L140 86" stroke="#f57c00" stroke-width="2" 
							stroke-dasharray="3 2" opacity="0.4" />
						<path d="M180 86 L212 86" stroke="#4caf50" stroke-width="2" opacity="0.8" />

						<!-- Success indicator -->
						<rect x="80" y="120" width="160" height="24" rx="12" fill="#e8f5e9" stroke="#4caf50"
							stroke-width="1.5" />
						<text x="160" y="136" text-anchor="middle" fill="#4caf50" font-size="12" font-weight="600">
							Booking Secured
						</text>
					</svg>
				</div>
			</div>
		</div>
	</div>

	<div id="admin-improvements" class="about-section wca-improvement-subsection is-hidden">
		<div class="has-2-columns is-wider-right">
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img" focusable="false" aria-hidden="true">
						<!-- Background -->
						<rect x="20" y="20" width="280" height="160" rx="12" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />

						<!-- Admin modal -->
						<rect x="40" y="40" width="240" height="120" rx="8" fill="#ffffff"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="2" />
						<rect x="50" y="50" width="220" height="12" rx="6" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.9" />
						
						<!-- Form fields -->
						<rect x="50" y="72" width="100" height="8" rx="4" fill="#d8dadd" />
						<rect x="160" y="72" width="100" height="8" rx="4" fill="#4caf50" opacity="0.7" />
						
						<rect x="50" y="86" width="100" height="8" rx="4" fill="#d8dadd" />
						<rect x="160" y="86" width="100" height="8" rx="4" fill="#4caf50" opacity="0.7" />
						
						<rect x="50" y="100" width="210" height="8" rx="4" fill="#d8dadd" />
						<rect x="50" y="114" width="180" height="8" rx="4" fill="#4caf50" opacity="0.7" />
						
						<!-- Save button -->
						<rect x="200" y="135" width="60" height="16" rx="8" fill="var(--wp-admin-theme-color, #2271b1)" />
						<text x="230" y="145" text-anchor="middle" fill="#ffffff" font-size="10" font-weight="600">Save</text>

						<!-- Improvement indicators -->
						<circle cx="30" cy="60" r="6" fill="#4caf50" />
						<path d="M27 57 l3 3 6-6" stroke="#ffffff" stroke-width="1.5" 
							stroke-linecap="round" fill="none" />
						
						<circle cx="30" cy="90" r="6" fill="#4caf50" />
						<path d="M27 87 l3 3 6-6" stroke="#ffffff" stroke-width="1.5" 
							stroke-linecap="round" fill="none" />
						
						<circle cx="30" cy="120" r="6" fill="#4caf50" />
						<path d="M27 117 l3 3 6-6" stroke="#ffffff" stroke-width="1.5" 
							stroke-linecap="round" fill="none" />
					</svg>
				</div>
			</div>
			<div class="column">
				<h3><?php echo esc_html('Enhanced Admin Experience'); ?> <span class="wca-new-badge"></span></h3>
				<p><?php echo esc_html('The admin modal for creating appointments has been significantly improved with better customer handling, staff selection, and data management.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('Customer creation now saves all billing fields, matching checkout behavior.'); ?>
					</li>
					<li><?php echo esc_html('Staff selection properly handles multiple staff scenarios.'); ?>
					</li>
					<li><?php echo esc_html('"Create account" checkbox automatically hides when customer is selected.'); ?>
					</li>
					<li><?php echo esc_html('Admin calendar shows past appointments in grayscale for better visual hierarchy.'); ?>
					</li>
					<li><?php echo esc_html('Hover effects and improved visual feedback throughout admin interface.'); ?>
					</li>
				</ul>
			</div>
		</div>

		<hr />

		<div class="has-2-columns is-wider-left">
			<div class="column">
				<h3><?php echo esc_html('Better Compatibility'); ?> <span class="wca-new-badge"></span></h3>
				<p><?php echo esc_html('Improved compatibility with popular plugins and WooCommerce updates, ensuring smooth operation in various environments.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('WooCommerce 10.4 compatibility with deprecated function fixes.'); ?></li>
					<li><?php echo esc_html('PayPal Payments plugin compatibility - smart buttons disabled on appointment pages.'); ?></li>
					<li><?php echo esc_html('WooCommerce Deposits integration fixes for partial payments.'); ?></li>
					<li><?php echo esc_html('Improved plugin compatibility for popular extensions.'); ?></li>
				</ul>
			</div>
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img" focusable="false" aria-hidden="true">
						<!-- Background -->
						<rect x="20" y="20" width="280" height="160" rx="12" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />

						<!-- Plugin compatibility grid -->
						<rect x="40" y="40" width="60" height="40" rx="6" fill="#ffffff" stroke="#4caf50" stroke-width="1.5" />
						<text x="70" y="58" text-anchor="middle" fill="#4caf50" font-size="8" font-weight="bold">WC</text>
						<text x="70" y="70" text-anchor="middle" fill="#4caf50" font-size="6">10.4</text>

						<rect x="110" y="40" width="60" height="40" rx="6" fill="#ffffff" stroke="#4caf50" stroke-width="1.5" />
						<text x="140" y="58" text-anchor="middle" fill="#4caf50" font-size="8" font-weight="bold">PayPal</text>
						<text x="140" y="70" text-anchor="middle" fill="#4caf50" font-size="6">✓</text>

						<rect x="180" y="40" width="60" height="40" rx="6" fill="#ffffff" stroke="#4caf50" stroke-width="1.5" />
						<text x="210" y="58" text-anchor="middle" fill="#4caf50" font-size="8" font-weight="bold">Deposits</text>
						<text x="210" y="70" text-anchor="middle" fill="#4caf50" font-size="6">✓</text>

						<rect x="250" y="40" width="60" height="40" rx="6" fill="#ffffff" stroke="#4caf50" stroke-width="1.5" />
						<text x="280" y="58" text-anchor="middle" fill="#4caf50" font-size="8" font-weight="bold">More</text>
						<text x="280" y="70" text-anchor="middle" fill="#4caf50" font-size="6">✓</text>

						<!-- Central connector -->
						<circle cx="160" cy="110" r="20" fill="#e8f5e9" stroke="#4caf50" stroke-width="2" />
						<text x="160" y="113" text-anchor="middle" fill="#4caf50" font-size="10" font-weight="bold">5.1</text>

						<!-- Connection lines -->
						<path d="M70 80 L145 95" stroke="#4caf50" stroke-width="1.5" opacity="0.6" />
						<path d="M140 80 L150 95" stroke="#4caf50" stroke-width="1.5" opacity="0.6" />
						<path d="M210 80 L175 95" stroke="#4caf50" stroke-width="1.5" opacity="0.6" />
						<path d="M280 80 L175 95" stroke="#4caf50" stroke-width="1.5" opacity="0.6" />
					</svg>
				</div>
			</div>
		</div>
	</div>

	
	
	<div id="rest-api" class="about-section wca-improvement-subsection is-hidden">
		<div class="has-2-columns is-wider-right">
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img" focusable="false" aria-hidden="true">
						<rect x="18" y="22" width="284" height="156" rx="14" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />
						<!-- Axes -->
						<path d="M96 104 C96 86 112 76 126 82 C132 68 154 68 162 82 C176 80 190 92 186 108 C198 108 206 116 206 128 C206 140 196 150 182 150 H118 C102 150 92 142 92 128 C92 116 100 108 112 106"
							fill="#ffffff" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5"
							stroke-width="1.5" />
						<rect x="126" y="116" width="36" height="10" rx="5"
							fill="var(--wp-admin-theme-color, #2271b1)" />

						<!-- Devices -->
						<rect x="40" y="56" width="54" height="34" rx="8" fill="#ffffff"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="1.4" />
						<rect x="226" y="60" width="60" height="48" rx="10" fill="#ffffff" stroke="#1d2327"
							stroke-width="1.4" opacity="0.85" />
						<rect x="130" y="44" width="60" height="22" rx="6" fill="#ffffff"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="1.2" />

						<!-- Lines -->
						<path d="M94 72 L130 60" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="2.5"
							marker-end="url(#apiArrow)" />
						<path d="M190 60 L230 72" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="2.5"
							marker-end="url(#apiArrow)" />
						<path d="M160 128 L246 128" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5"
							stroke-width="3" stroke-dasharray="6 4" marker-end="url(#apiArrow)" />
						<path d="M124 128 L70 128" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="3"
							marker-end="url(#apiArrow)" />

						<!-- Speed lines -->
						<path d="M226 40 H282" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5"
							stroke-width="4" stroke-linecap="round" opacity="0.8" />
						<path d="M236 32 H268" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="4"
							stroke-linecap="round" opacity="0.8" />

						<defs>
							<marker id="apiArrow" markerWidth="6" markerHeight="6" refX="5" refY="3" orient="auto">
								<path d="M0,0 L6,3 L0,6 z" fill="var(--wp-admin-theme-color, #2271b1)" />
							</marker>
						</defs>
					</svg>
				</div>
			</div>
			<div class="column">
				<h2><?php echo esc_html('Powered by a Robust REST API'); ?></h2>
				<p><?php echo esc_html("Version 5.0 introduces a comprehensive REST API that exposes every aspect of the Appointments system. This isn't just for us—it’s for you."); ?>
				</p>
				<p><?php echo esc_html('Build custom dashboards, mobile apps, or third-party integrations with full read/write access to appointments, availability rules, and slots.'); ?>
				</p>
				<div class="wca-cta-links">
					<a class="button button-primary"
						href="<?php echo esc_url('https://docs.bookingwp.com/appointments/developer/api'); ?>"
						target="_blank" rel="noopener noreferrer">
						<?php echo esc_html('View REST API documentation'); ?>
					</a>
				</div>
				<div class="wca-inline-note">
					<?php
					printf(
						'%s <a href="%s">%s</a>',
						esc_html__('Generate API keys in WooCommerce → Settings → Advanced → REST API before making requests.', 'woocommerce-appointments'),
						esc_url(admin_url('admin.php?page=wc-settings&tab=advanced&section=keys')),
						esc_html__('Open REST API keys', 'woocommerce-appointments'),
					);
					?>
				</div>
			</div>
		</div>

		<hr />

		<div class="has-2-columns is-wider-left">
			<div class="column">
				<h3><?php echo esc_html('Full CRUD & Coverage'); ?></h3>
				<p><?php echo esc_html('You now have complete control over every appointments resource, with dedicated endpoints for slots, availability, staff, products, categories, and indexed data.'); ?>
				</p>
				<ul class="ul-disc">
					<li><code>POST /wp-json/wc-appointments/v2/appointments</code><br><?php echo esc_html('Create appointments from custom forms or mobile apps.'); ?>
					</li>
					<li><code>GET /wp-json/wc-appointments/v2/appointments/{id}</code><br><?php echo esc_html('Retrieve appointment details, status, and metadata.'); ?>
					</li>
					<li><code>PUT /wp-json/wc-appointments/v2/appointments/{id}</code><br><?php echo esc_html('Update timing, status, staff, and customer notes.'); ?>
					</li>
					<li><code>DELETE /wp-json/wc-appointments/v2/appointments/{id}</code><br><?php echo esc_html('Remove appointments with full cleanup.'); ?>
					</li>
					<li><code>GET /wp-json/wc-appointments/v2/slots</code><br><?php echo esc_html('Query available slots in real time for any product or staff.'); ?>
					</li>
					<li><code>GET|POST|PUT|DELETE /wp-json/wc-appointments/v2/availabilities</code><br><?php echo esc_html('Manage availability rules programmatically.'); ?>
					</li>
					<li><code>GET /wp-json/wc-appointments/v2/index</code><br><?php echo esc_html('Read the indexed availability/appointment cache for fast, headless reads.'); ?>
					</li>
					<li><code>GET /wp-json/wc-appointments/v2/sse</code><br><?php echo esc_html('Subscribe to server-sent events for live updates in dashboards.'); ?>
					</li>
					<li><code>GET /wp-json/wc-appointments/v1/staff</code><br><?php echo esc_html('List staff with appointment-specific data.'); ?>
					</li>
					<li><code>GET /wp-json/wc-appointments/v1/products</code><br><?php echo esc_html('Surface appointable products with pricing and staff links.'); ?>
					</li>
					<li><code>GET /wp-json/wc-appointments/v1/products/categories</code><br><?php echo esc_html('Filter and group appointment products by category.'); ?>
					</li>
				</ul>
			</div>
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img" focusable="false" aria-hidden="true">
						<rect x="18" y="22" width="284" height="156" rx="14" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />
						<!-- Steps -->
						<rect x="38" y="52" width="64" height="36" rx="8" fill="#ffffff"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="1.4" />
						<rect x="128" y="52" width="64" height="36" rx="8" fill="#ffffff"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5" stroke-width="1.4" />
						<rect x="218" y="52" width="64" height="36" rx="8" fill="#ffffff" stroke="#1d2327"
							stroke-width="1.4" opacity="0.85" />

						<rect x="38" y="116" width="64" height="28" rx="8" fill="#d8dadd" />
						<rect x="128" y="116" width="64" height="28" rx="8"
							fill="var(--wp-admin-theme-color, #2271b1)" />
						<rect x="218" y="116" width="64" height="28" rx="8" fill="var(--wp-admin-theme-color, #2271b1)"
							fill-opacity="0.5" />

						<rect x="52" y="62" width="36" height="10" rx="5" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.9" />
						<rect x="142" y="62" width="36" height="10" rx="5" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.5" />
						<rect x="232" y="62" width="36" height="10" rx="5" fill="#1d2327" opacity="0.8" />

						<!-- Arrows -->
						<path d="M102 70 L128 70" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="3"
							marker-end="url(#crudArrow)" />
						<path d="M192 70 L218 70" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5"
							stroke-width="3" marker-end="url(#crudArrow)" />
						<path d="M70 116 L70 80" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5"
							stroke-width="3" stroke-dasharray="6 4" marker-end="url(#crudArrow)" />
						<path d="M160 116 L160 88" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="3"
							stroke-dasharray="6 4" marker-end="url(#crudArrow)" />
						<path d="M250 116 L250 88" stroke="#1d2327" stroke-width="3" stroke-dasharray="6 4"
							marker-end="url(#crudArrow)" />

						<!-- Speed lines -->
						<path d="M226 40 H282" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5"
							stroke-width="4" stroke-linecap="round" opacity="0.8" />
						<path d="M236 32 H268" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="4"
							stroke-linecap="round" opacity="0.8" />

						<defs>
							<marker id="crudArrow" markerWidth="6" markerHeight="6" refX="5" refY="3" orient="auto">
								<path d="M0,0 L6,3 L0,6 z" fill="var(--wp-admin-theme-color, #2271b1)" />
							</marker>
						</defs>
					</svg>
				</div>
			</div>
		</div>

		<hr />

		<div class="has-2-columns is-wider-right">
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img" focusable="false" aria-hidden="true">
						<rect x="18" y="22" width="284" height="156" rx="14" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />
						<!-- Backend -->
						<rect x="34" y="60" width="96" height="72" rx="12" fill="#ffffff"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="1.4" />
						<rect x="48" y="74" width="68" height="10" rx="5" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.9" />
						<rect x="48" y="92" width="54" height="8" rx="4" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.5" />
						<rect x="48" y="108" width="42" height="8" rx="4" fill="#d8dadd" />

						<!-- API pipe -->
						<path d="M130 96 C170 96, 170 96, 210 96" stroke="var(--wp-admin-theme-color, #2271b1)"
							stroke-width="3.4" marker-end="url(#headlessArrow)" />
						<path d="M130 112 C172 120, 180 128, 210 136" stroke="var(--wp-admin-theme-color, #2271b1)"
							stroke-opacity="0.5" stroke-width="3.4" stroke-dasharray="6 4"
							marker-end="url(#headlessArrow)" />

						<!-- Frontend -->
						<rect x="210" y="60" width="78" height="94" rx="14" fill="#ffffff" stroke="#1d2327"
							stroke-width="1.4" opacity="0.85" />
						<rect x="222" y="72" width="56" height="10" rx="5" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.9" />
						<rect x="222" y="90" width="48" height="8" rx="4" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.5" />
						<rect x="222" y="106" width="44" height="8" rx="4" fill="#d8dadd" />
						<rect x="222" y="124" width="52" height="10" rx="5" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.9" />

						<!-- Speed lines -->
						<path d="M226 40 H282" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5"
							stroke-width="4" stroke-linecap="round" opacity="0.8" />
						<path d="M236 32 H268" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="4"
							stroke-linecap="round" opacity="0.8" />

						<defs>
							<marker id="headlessArrow" markerWidth="6" markerHeight="6" refX="5" refY="3" orient="auto">
								<path d="M0,0 L6,3 L0,6 z" fill="var(--wp-admin-theme-color, #2271b1)" />
							</marker>
						</defs>
					</svg>
				</div>
			</div>
			<div class="column">
				<h3><?php echo esc_html('Headless Ready'); ?></h3>
				<p><?php echo esc_html('Perfect for headless WordPress setups. Fetch availability, create appointments, and manage customers entirely via API, allowing you to build front-end experiences in any framework.'); ?>
				</p>
			</div>
		</div>

		<hr />

		<div class="has-2-columns is-wider-left">
			<div class="column">
				<h3><?php echo esc_html('Developer Friendly'); ?></h3>
				<p><?php echo esc_html('We have added extensive hooks and filters alongside the API. Customizing the appointment flow has never been easier for developers. Detailed documentation and examples help you get started quickly.'); ?>
				</p>
			</div>
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img" focusable="false" aria-hidden="true">
						<rect x="18" y="22" width="284" height="156" rx="14" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />
						<!-- Console -->
						<rect x="34" y="44" width="252" height="42" rx="10" fill="#1d2327" opacity="0.9" />
						<rect x="46" y="56" width="70" height="8" rx="4" fill="var(--wp-admin-theme-color, #2271b1)"
							fill-opacity="0.5" />
						<rect x="122" y="56" width="54" height="8" rx="4" fill="var(--wp-admin-theme-color, #2271b1)" />
						<rect x="182" y="56" width="34" height="8" rx="4" fill="#d8dadd" />

						<!-- Hooks list -->
						<rect x="34" y="98" width="120" height="70" rx="10" fill="#ffffff"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="1.4" />
						<rect x="48" y="110" width="90" height="10" rx="5" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.9" />
						<rect x="48" y="128" width="78" height="8" rx="4" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.5" />
						<rect x="48" y="146" width="68" height="8" rx="4" fill="#d8dadd" />

						<!-- IDE panel -->
						<rect x="178" y="98" width="108" height="70" rx="10" fill="#ffffff"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5" stroke-width="1.4" />
						<rect x="192" y="110" width="84" height="10" rx="5" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.9" />
						<rect x="192" y="128" width="70" height="8" rx="4" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.5" />
						<rect x="192" y="146" width="62" height="8" rx="4" fill="#d8dadd" />

						<!-- Speed lines -->
						<path d="M226 40 H282" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5"
							stroke-width="4" stroke-linecap="round" opacity="0.8" />
						<path d="M236 32 H268" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="4"
							stroke-linecap="round" opacity="0.8" />
					</svg>
				</div>
			</div>
		</div>
	</div>

	<div id="documentation" class="about-section is-hidden">
		<div class="has-2-columns is-wider-right">
			<div class="column">
				<div class="wca-placeholder">
					<svg viewBox="0 0 320 200" role="img"
						aria-label="<?php echo esc_attr('Documentation book with pages and bookmark'); ?>"
						focusable="false">
						<!-- Background container -->
						<rect x="20" y="20" width="280" height="160" rx="12" fill="#f6f7f7" stroke="#d8dadd"
							stroke-width="1.5" />

						<!-- Book/Documentation -->
						<rect x="70" y="40" width="180" height="120" rx="6" fill="#ffffff"
							stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="2" />

						<!-- Book spine -->
						<rect x="70" y="40" width="36" height="120" rx="6" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.12" />
						<path d="M106 40 L106 160" stroke="#e0e4e7" stroke-width="1.5" />

						<!-- Text lines on pages -->
						<rect x="120" y="58" width="110" height="7" rx="3" fill="var(--wp-admin-theme-color, #2271b1)"
							opacity="0.9" />
						<rect x="120" y="72" width="85" height="6" rx="3" fill="#d8dadd" opacity="0.7" />
						<rect x="120" y="84" width="95" height="6" rx="3" fill="#d8dadd" opacity="0.7" />
						<rect x="120" y="96" width="75" height="6" rx="3" fill="#d8dadd" opacity="0.7" />
						<rect x="120" y="108" width="100" height="6" rx="3" fill="#d8dadd" opacity="0.7" />
						<rect x="120" y="120" width="70" height="6" rx="3" fill="#d8dadd" opacity="0.7" />

						<!-- Bookmark ribbon -->
						<path d="M220 40 L220 68 L228 58 L236 68 L236 40 Z"
							fill="var(--wp-admin-theme-color, #2271b1)" />

						<!-- Decorative elements -->
						<circle cx="260" cy="60" r="4" fill="var(--wp-admin-theme-color, #2271b1)" opacity="0.3" />
						<circle cx="270" cy="80" r="3" fill="var(--wp-admin-theme-color, #2271b1)" opacity="0.2" />
					</svg>
				</div>
			</div>
			<div class="column">
				<h2><?php echo esc_html('New Documentation Hub'); ?></h2>
				<p><?php echo esc_html('We have completely overhauled our documentation. The new site at docs.bookingwp.com offers improved tutorials, better navigation, and a comprehensive overview of all features.'); ?>
				</p>
				<p><?php echo esc_html('Whether you are setting up your first calendar or diving into advanced API integrations, you will find everything you need in one place.'); ?>
				</p>
				<div class="wca-cta-links">
					<a class="button button-primary" href="https://docs.bookingwp.com" target="_blank"
						rel="noopener noreferrer">
						<?php echo esc_html('Visit New Documentation'); ?>
					</a>
				</div>
			</div>
		</div>
	</div>

	<div id="future" class="about-section is-hidden">
		<h2><?php echo esc_html('Product Roadmap'); ?></h2>
		<p style="max-width: 640px; margin-bottom: 32px;">
			<?php echo esc_html('With the new React architecture and API-first approach, we can ship features faster than ever. Here is what we are working on—timing may shift based on feedback and priorities.'); ?>
		</p>

		<div class="wca-roadmap">
			<!-- Phase 0: Completed Foundation -->
			<div class="wca-roadmap-item is-complete">
				<div class="wca-roadmap-header">
					<h3><?php echo esc_html('Phase 0: Foundation & Code Modernization'); ?></h3>
					<span class="wca-roadmap-status is-complete"><?php echo esc_html('Shipped in 5.0-5.1'); ?></span>
				</div>
				<p><?php echo esc_html('Standardized status values, duration units, and core helpers behind shared constants. Clearer type hints make the codebase easier to extend and safer to change.'); ?>
				</p>
				<p style="margin-bottom: 16px;">
					<strong><?php echo esc_html('Over 35% of the codebase has been refactored since version 5.0'); ?></strong>
					<?php echo esc_html('with improved patterns, better documentation, and standardized constants.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('Centralized constants eliminate magic strings for statuses and duration units.'); ?>
					</li>
					<li><?php echo esc_html('Improved PHPDoc and structured return types for IDE predictability.'); ?>
					</li>
					<li><?php echo esc_html('PHPUnit coverage validates patterns for safe customization.'); ?></li>
					<li><?php echo esc_html('Manager trait pattern for consistent hook registration.'); ?></li>
					<li><?php echo esc_html('Unified export interface for CSV and ICS formats.'); ?></li>
					<li><?php echo esc_html('Atomic booking locks prevent race conditions at high traffic.'); ?></li>
					<li><?php echo esc_html('Real-time admin calendar with React and Server-Sent Events.'); ?></li>
				</ul>
			</div>

			<!-- Phase 1: Timezone Management -->
			<div class="wca-roadmap-item">
				<div class="wca-roadmap-header">
					<h3><?php echo esc_html('Phase 1: Timezone Management'); ?></h3>
					<span class="wca-roadmap-status is-next"><?php echo esc_html('Up Next'); ?></span>
				</div>
				<p><?php echo esc_html('Centralized timezone handling with customer preferences. Appointments tagged with creation timezone for accurate display across regions. Browser detection on booking form.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('Customer timezone selector in My Account.'); ?></li>
					<li><?php echo esc_html('Browser timezone detection with switch option.'); ?></li>
					<li><?php echo esc_html('REST API returns normalized UTC timestamps.'); ?></li>
					<li><?php echo esc_html('Admin wizard for safe site timezone changes.'); ?></li>
				</ul>
			</div>

			<!-- Phase 2: Locations -->
			<div class="wca-roadmap-item">
				<div class="wca-roadmap-header">
					<h3><?php echo esc_html('Phase 2: Multi-Location Support'); ?></h3>
					<span class="wca-roadmap-status"><?php echo esc_html('Planned'); ?></span>
				</div>
				<p><?php echo esc_html('Set up multiple locations for your business with physical addresses, virtual meeting links, or no location option. Perfect for businesses operating from multiple offices, offering virtual services, or providing on-site appointments.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('Create and manage multiple locations with unique settings.'); ?></li>
					<li><?php echo esc_html('Product-level location configuration with multi-location support.'); ?>
					</li>
					<li><?php echo esc_html('Frontend location picker during booking for customers to choose their preferred location.'); ?>
					</li>
					<li><?php echo esc_html('Location display in emails, calendar sync, and admin views.'); ?></li>
					<li><?php echo esc_html('Google Calendar location integration for each location.'); ?></li>
				</ul>
			</div>

			<!-- Phase 3: Slots Architecture -->
			<div class="wca-roadmap-item">
				<div class="wca-roadmap-header">
					<h3><?php echo esc_html('Phase 3: Slots Architecture Refactoring'); ?></h3>
					<span class="wca-roadmap-status"><?php echo esc_html('Planned'); ?></span>
				</div>
				<p><?php echo esc_html('Unified slots API with hierarchical responses. Single entry point for JS, REST, and PHP. Removes 1,500+ lines of duplicate JavaScript rule checking.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('Single WC_Appointment_Slots_API facade.'); ?></li>
					<li><?php echo esc_html('Hierarchical response format (months → days → slots).'); ?></li>
					<li><?php echo esc_html('Progressive loading levels for performance.'); ?></li>
					<li><?php echo esc_html('85% code reduction, 10x faster queries.'); ?></li>
				</ul>
			</div>

			<!-- Phase 4: Virtual Meetings -->
			<div class="wca-roadmap-item">
				<div class="wca-roadmap-header">
					<h3><?php echo esc_html('Phase 4: Virtual Meeting Integration'); ?></h3>
					<span class="wca-roadmap-status"><?php echo esc_html('Planned'); ?></span>
				</div>
				<p><?php echo esc_html('Zoom, Google Meet, and Microsoft Teams integration with automatic meeting link generation. Natural extension of the Locations system for virtual appointments.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('Zoom OAuth integration with auto meeting creation.'); ?></li>
					<li><?php echo esc_html('Google Meet and Microsoft Teams support.'); ?></li>
					<li><?php echo esc_html('Meeting links in confirmation emails and My Account.'); ?></li>
					<li><?php echo esc_html('Auto-cancel meeting on appointment cancellation.'); ?></li>
				</ul>
			</div>

			<!-- Phase 5: Enhanced Group Bookings -->
			<div class="wca-roadmap-item">
				<div class="wca-roadmap-header">
					<h3><?php echo esc_html('Phase 5: Enhanced Group Bookings & Classes'); ?></h3>
					<span class="wca-roadmap-status"><?php echo esc_html('Planned'); ?></span>
				</div>
				<p><?php echo esc_html('Multi-person booking interface with visual capacity indicators. Opens fitness, education, and workshop market segments with waitlist functionality.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('Multi-person booking interface.'); ?></li>
					<li><?php echo esc_html('Visual capacity indicators and limits.'); ?></li>
					<li><?php echo esc_html('Waitlist functionality with auto-promote.'); ?></li>
					<li><?php echo esc_html('Recurring class series support.'); ?></li>
					<li><?php echo esc_html('Attendance tracking and analytics.'); ?></li>
				</ul>
			</div>

			<!-- Phase 6: Recurring Appointments -->
			<div class="wca-roadmap-item">
				<div class="wca-roadmap-header">
					<h3><?php echo esc_html('Phase 6: Recurring Appointments'); ?></h3>
					<span class="wca-roadmap-status"><?php echo esc_html('Planned'); ?></span>
				</div>
				<p><?php echo esc_html('Powerful RRULE-based recurrence for daily, weekly, or monthly schedules. Perfect for subscription-based services and ongoing client relationships.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('Virtual instances with composite IDs.'); ?></li>
					<li><?php echo esc_html('Cancel single instance, from here, or entire series.'); ?></li>
					<li><?php echo esc_html('WooCommerce Subscriptions integration.'); ?></li>
					<li><?php echo esc_html('ICS export with RRULE support.'); ?></li>
					<li><?php echo esc_html('Analytics for recurring series performance.'); ?></li>
				</ul>
			</div>

			<!-- Phase 7: Modern Date Picker -->
			<div class="wca-roadmap-item">
				<div class="wca-roadmap-header">
					<h3><?php echo esc_html('Phase 7: Modern Date/Time Picker'); ?></h3>
					<span class="wca-roadmap-status"><?php echo esc_html('Planned'); ?></span>
				</div>
				<p><?php echo esc_html('A touch-optimized frontend booking experience with visual availability indicators, skeleton loading states, and improved accessibility.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('Progressive slot loading from new API.'); ?></li>
					<li><?php echo esc_html('Visual availability calendar with color indicators.'); ?></li>
					<li><?php echo esc_html('Touch gestures and mobile-first design.'); ?></li>
					<li><?php echo esc_html('Full keyboard navigation and ARIA support.'); ?></li>
				</ul>
			</div>

			<!-- Phase 8: Customer Self-Service Portal -->
			<div class="wca-roadmap-item">
				<div class="wca-roadmap-header">
					<h3><?php echo esc_html('Phase 8: Customer Self-Service Portal'); ?></h3>
					<span class="wca-roadmap-status"><?php echo esc_html('Planned'); ?></span>
				</div>
				<p><?php echo esc_html('Modern customer dashboard with visual appointment calendar, one-click rescheduling, and easy cancellation. Reduces support burden by 30%+.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('Visual appointment calendar (upcoming/past).'); ?></li>
					<li><?php echo esc_html('One-click rescheduling interface.'); ?></li>
					<li><?php echo esc_html('Easy cancellation with policy display.'); ?></li>
					<li><?php echo esc_html('Appointment history with filters.'); ?></li>
					<li><?php echo esc_html('Receipt/invoice download.'); ?></li>
				</ul>
			</div>

			<!-- Phase 9: Advanced Analytics -->
			<div class="wca-roadmap-item">
				<div class="wca-roadmap-header">
					<h3><?php echo esc_html('Phase 9: Advanced Analytics Dashboard'); ?></h3>
					<span class="wca-roadmap-status"><?php echo esc_html('Planned'); ?></span>
				</div>
				<p><?php echo esc_html('Business intelligence dashboard with revenue trends, staff performance metrics, and no-show rate patterns. Premium feature for enterprise customers.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('Revenue trends and forecasting.'); ?></li>
					<li><?php echo esc_html('Staff performance metrics.'); ?></li>
					<li><?php echo esc_html('No-show rate tracking with patterns.'); ?></li>
					<li><?php echo esc_html('Booking source attribution.'); ?></li>
					<li><?php echo esc_html('Custom report builder and exports.'); ?></li>
				</ul>
			</div>

			<!-- Phase 10: Automation Workflows -->
			<div class="wca-roadmap-item">
				<div class="wca-roadmap-header">
					<h3><?php echo esc_html('Phase 10: Automation Workflows'); ?></h3>
					<span class="wca-roadmap-status"><?php echo esc_html('Future'); ?></span>
				</div>
				<p><?php echo esc_html('Visual workflow builder for automating reminder sequences, follow-ups, conditional logic, and integrations. High-value feature building on existing hooks.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('Visual workflow builder.'); ?></li>
					<li><?php echo esc_html('Trigger-based automation (booked, confirmed, cancelled).'); ?></li>
					<li><?php echo esc_html('Email/SMS sequences with conditions.'); ?></li>
					<li><?php echo esc_html('Webhook integrations for external services.'); ?></li>
				</ul>
			</div>

			<!-- Future: Advanced Features -->
			<div class="wca-roadmap-item">
				<div class="wca-roadmap-header">
					<h3><?php echo esc_html('Future: Advanced Integrations'); ?></h3>
					<span class="wca-roadmap-status"><?php echo esc_html('Exploring'); ?></span>
				</div>
				<p><?php echo esc_html('Advanced features for enterprise customers and specific use cases including 2-way calendar sync, subscription packages, mobile staff app, and AI-powered scheduling.'); ?>
				</p>
				<ul class="ul-disc">
					<li><?php echo esc_html('2-Way Calendar Sync (Outlook, Apple Calendar).'); ?></li>
					<li><?php echo esc_html('Subscription & Package Bookings.'); ?></li>
					<li><?php echo esc_html('Mobile Staff App (Progressive Web App).'); ?></li>
					<li><?php echo esc_html('AI-Powered Smart Scheduling.'); ?></li>
					<li><?php echo esc_html('CRM Integration Hub (HubSpot, Salesforce).'); ?></li>
				</ul>
			</div>
		</div>

		<hr />


		<div class="wca-feedback-footer">
			<div class="has-2-columns is-wider-left">
				<div class="column">
					<h3><?php echo esc_html('Help Shape What Comes Next'); ?></h3>
					<p><?php echo esc_html('Spotted an issue or have an idea? Share it with us so we can prioritize the fixes and improvements that matter most to you and the community.'); ?>
					</p>
					<div class="wca-cta-links">
						<a class="button button-primary"
							href="<?php echo esc_url('https://bitbucket.org/bookingwp/woocommerce-appointments/issues'); ?>"
							target="_blank" rel="noopener noreferrer">
							<?php echo esc_html('Report an Issue on Bitbucket'); ?>
						</a>
						<a class="button secondary-equal"
							href="<?php echo esc_url('https://bitbucket.org/bookingwp/woocommerce-appointments/issues?status=new&status=open'); ?>"
							target="_blank" rel="noopener noreferrer">
							<?php echo esc_html('View Open Issues'); ?>
						</a>
					</div>
				</div>
				<div class="column">
					<div class="wca-placeholder">
						<svg viewBox="0 0 320 200" role="img" focusable="false" aria-hidden="true">
							<rect x="18" y="22" width="284" height="156" rx="14" fill="#f6f7f7" stroke="#d8dadd"
								stroke-width="1.5" />
							<!-- Issue card -->
							<rect x="42" y="50" width="110" height="64" rx="12" fill="#ffffff"
								stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="1.4" />
							<rect x="56" y="62" width="74" height="10" rx="5"
								fill="var(--wp-admin-theme-color, #2271b1)" opacity="0.9" />
							<rect x="56" y="80" width="58" height="8" rx="4" fill="var(--wp-admin-theme-color, #2271b1)"
								opacity="0.5" />
							<rect x="56" y="96" width="42" height="8" rx="4" fill="#d8dadd" />
							<path d="M96 114 L106 128 L88 116" fill="#ffffff"
								stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="1.2" />

							<!-- Activity / comments -->
							<rect x="176" y="66" width="110" height="72" rx="12" fill="#ffffff"
								stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5" stroke-width="1.4" />
							<rect x="190" y="78" width="78" height="10" rx="5"
								fill="var(--wp-admin-theme-color, #2271b1)" opacity="0.9" />
							<rect x="190" y="94" width="64" height="8" rx="4"
								fill="var(--wp-admin-theme-color, #2271b1)" opacity="0.5" />
							<rect x="190" y="110" width="54" height="8" rx="4" fill="#d8dadd" />
							<circle cx="214" cy="130" r="6" fill="var(--wp-admin-theme-color, #2271b1)" />
							<circle cx="232" cy="130" r="6" fill="var(--wp-admin-theme-color, #2271b1)"
								fill-opacity="0.5" />

							<!-- Link/branch to tracker -->
							<path d="M152 92 C168 92, 180 92, 188 92" stroke="var(--wp-admin-theme-color, #2271b1)"
								stroke-width="3" marker-end="url(#issueArrow)" />
							<path d="M152 108 C172 116, 178 124, 188 132" stroke="var(--wp-admin-theme-color, #2271b1)"
								stroke-opacity="0.5" stroke-width="3" stroke-dasharray="6 4"
								marker-end="url(#issueArrow)" />

							<!-- Speed lines -->
							<path d="M226 40 H282" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-opacity="0.5"
								stroke-width="4" stroke-linecap="round" opacity="0.8" />
							<path d="M236 32 H268" stroke="var(--wp-admin-theme-color, #2271b1)" stroke-width="4"
								stroke-linecap="round" opacity="0.8" />

							<defs>
								<marker id="issueArrow" markerWidth="6" markerHeight="6" refX="5" refY="3"
									orient="auto">
									<path d="M0,0 L6,3 L0,6 z" fill="var(--wp-admin-theme-color, #2271b1)" />
								</marker>
							</defs>
						</svg>
					</div>
				</div>
			</div>
			<!-- Quick tips spanning full width -->
			<div class="wca-inline-note wca-inline-note-margin-top">
				<strong><?php echo esc_html('Quick tips:'); ?></strong>
				<?php echo esc_html('Add a summary, steps to reproduce, and screenshots/logs if available. Your feedback directly shapes our next sprint.'); ?>
			</div>
		</div>
	</div>

	<div id="changelog" class="about-section is-hidden">
		<h2><?php echo esc_html('Recent Changes'); ?></h2>
		<p class="wca-changelog-intro">
			<?php echo esc_html('A summary of the most important updates, improvements, and bug fixes across recent releases. Expand each category to see details.'); ?>
		</p>
		<div class="wca-changelog">
			<div class="changelog-grid">
				<div class="wca-highlights changelog-card">
					<div class="wca-chip"><span class="dot"
							aria-hidden="true"></span><?php echo esc_html('Highlights'); ?></div>
					<ul class="ul-disc">
						<li><?php echo esc_html('Real-time admin calendar with live create/move/cancel, Webhooks + SSE, and instant loading states.'); ?>
						</li>
						<li><?php echo esc_html('Indexed availability pipeline with atomic reservations, health checks, and safer backfills for high volume stores.'); ?>
						</li>
						<li><?php echo esc_html('REST API v2 with full CRUD plus internal API consolidation; admin warnings when REST is disabled.'); ?>
						</li>
						<li><?php echo esc_html('New booking blocks (Availability Filter, Appointment Form) and a modern admin creation modal with COGs support.'); ?>
						</li>
						<li><?php echo esc_html('Lean build pipeline (pure NPM), hook validation, PHPUnit coverage, and ~20% smaller bundles.'); ?>
						</li>
						<li><?php echo esc_html('Guest account creation, WC 10.4 compatibility, and improved multi-currency support.'); ?>
						</li>
					</ul>
				</div>

				<details class="wca-accordion changelog-card" open>
					<summary><?php echo esc_html('Version 5.1.0 - Export Improvements'); ?><span class="wca-new-badge"></span><span class="wca-summary-caret">›</span></summary>
					<ul class="ul-disc">
						<li><?php echo esc_html('Export system refactoring: Implemented unified exporter interface for CSV and ICS formats.'); ?>
						</li>
						<li><?php echo esc_html('Added Export Manager class to centralize exporter registration and routing.'); ?>
						</li>
						<li><?php echo esc_html('Reorganized all exporter files under includes/admin/export/ for better organization.'); ?>
						</li>
						<li><?php echo esc_html('Added format selection (CSV/ICS) to admin export page with intuitive dropdown interface.'); ?>
						</li>
						<li><?php echo esc_html('ICS export now respects all filter options (date range, products, staff, add-ons).'); ?>
						</li>
						<li><?php echo esc_html('Add-ons option now available for both CSV and ICS export formats.'); ?>
						</li>
						<li><?php echo esc_html('Fixed ICS filename generation to remove redundant "-ics" suffix.'); ?>
						</li>
						<li><?php echo esc_html('Fixed footer positioning on export page to prevent viewport overlap.'); ?>
						</li>
						<li><?php echo esc_html('Renamed WC_Appointment_CSV_Exporter to WC_Appointments_CSV_Exporter for consistency.'); ?>
						</li>
					</ul>
				</details>

				<details class="wca-accordion changelog-card" open>
					<summary><?php echo esc_html('Admin calendar & UX'); ?><span class="wca-summary-caret">›</span></summary>
					<ul class="ul-disc">
						<li><?php echo esc_html('Screen Options toggle to temporarily use the legacy calendar; admin color scheme applied across pages.'); ?>
						</li>
						<li><?php echo esc_html('Faster initial load, single AJAX call for staff filters, skeleton loading, and consistent animations.'); ?>
						</li>
						<li><?php echo esc_html('Inline confirm/cancel, immediate order notes on edits, avatars in filters/modals, and better readability in popups.'); ?>
						</li>
						<li><?php echo esc_html('Unavailability now respects rules/exceptions across views; reload prompt on 403s; warning when REST is off.'); ?>
						</li>
						<li><?php echo esc_html('Week view defaults with month-level preloading; improved license activation UX.'); ?>
						</li>
					</ul>
				</details>

				<details class="wca-accordion changelog-card" open>
					<summary><?php echo esc_html('Availability, indexing & performance'); ?><span class="wca-summary-caret">›</span></summary>
					<ul class="ul-disc">
						<li><?php echo esc_html('Indexed path defaults with health checks, batch-progress backfill, and fail-safe recovery.'); ?>
						</li>
						<li><?php echo esc_html('Atomic reservation operations to prevent double bookings during spikes.'); ?>
						</li>
						<li><?php echo esc_html('Faster slot generation (daily buckets, preloaded views, instant admin calendar data).'); ?>
						</li>
						<li><?php echo esc_html('Support for overlapping range handling, horizon coverage, and better cache/availability validation.'); ?>
						</li>
						<li><?php echo esc_html('Performance tuning for REST /slots, appointment-day bucketing, and reduced bundle size.'); ?>
						</li>
						<li><?php echo esc_html('API v2 optimizations: reduced meta queries and elimination of N+1 issues.'); ?>
						</li>
					</ul>
				</details>

				<details class="wca-accordion changelog-card" open>
					<summary><?php echo esc_html('API & integrations'); ?><span class="wca-summary-caret">›</span></summary>
					<ul class="ul-disc">
						<li><?php echo esc_html('REST API v2: full CRUD for appointments, availabilities, slots; ISO 8601 UTC fields; WC permission checks.'); ?>
						</li>
						<li><?php echo esc_html('Webhooks + SSE for live updates; internal REST consolidation for a single source of truth.'); ?>
						</li>
						<li><?php echo esc_html('Warnings when REST API is disabled; multisite-safe SSE reconnects.'); ?>
						</li>
						<li><?php echo esc_html('WooPayments multi-currency fixed in cart/checkout; Twilio SMS & Abandoned Cart email fixes.'); ?>
						</li>
						<li><?php echo esc_html('API hook validation scripts and documentation to keep integrations stable.'); ?>
						</li>
						<li><?php echo esc_html('WooCommerce 10.4 compatibility (wc_enqueue_js deprecation).'); ?>
						</li>
					</ul>
				</details>

				<details class="wca-accordion changelog-card" open>
					<summary><?php echo esc_html('Booking, pricing & orders'); ?><span class="wca-summary-caret">›</span></summary>
					<ul class="ul-disc">
						<li><?php echo esc_html('New "Quantity applies to" setting lets you enforce capacity per day or per slot; daily caps turn every slot on that date into sold out once exhausted.'); ?>
						</li>
						<li><?php echo esc_html('Inventory max now enforced in validation and cost calculations; normalized quantities across staff/rules.'); ?>
						</li>
						<li><?php echo esc_html('Custom pricing rules improved (base/slot costs), cost of goods on edit screen, and clearer manual re-index workflows.'); ?>
						</li>
						<li><?php echo esc_html('Order notes added for admin edits; downloadable items included in confirmations; safer email duplication handling.'); ?>
						</li>
						<li><?php echo esc_html('Appointment creation modal refinements: payment methods, time dropdowns, formatted dates, faster product search.'); ?>
						</li>
						<li><?php echo esc_html('Option to create user accounts for guest customers in the admin modal.'); ?>
						</li>
					</ul>
				</details>

				<details class="wca-accordion changelog-card" open>
					<summary><?php echo esc_html('Compatibility, tooling & build'); ?><span class="wca-summary-caret">›</span></summary>
					<ul class="ul-disc">
						<li><?php echo esc_html('Compatibility updates for WordPress 6.9 and WooCommerce 10.3.'); ?>
						</li>
						<li><?php echo esc_html('Build pipeline switched to pure NPM, added hook validation, PHPUnit coverage, and safer minification.'); ?>
						</li>
						<li><?php echo esc_html('Updated Product Add-ons (8.1.0 → 8.1.2) and translation refreshes across releases.'); ?>
						</li>
						<li><?php echo esc_html('Readme/build documentation refreshed; NPM protected from unintended git commands.'); ?>
						</li>
					</ul>
				</details>

				<details class="wca-accordion changelog-card" open>
					<summary><?php echo esc_html('Fixes & reliability'); ?><span class="wca-summary-caret">›</span></summary>
					<ul class="ul-disc">
						<li><?php echo esc_html('Staff assignment, overlapping slots, and unavailability rendering fixed across calendar views.'); ?>
						</li>
						<li><?php echo esc_html('Minification, hook integrity, and PHP 7.4 compatibility issues resolved.'); ?>
						</li>
						<li><?php echo esc_html('Cart, pricing, tax, and duration edge cases corrected; prevents double bookings and null statuses.'); ?>
						</li>
						<li><?php echo esc_html('Memcached race conditions addressed (emails, status transitions, GCal sync).'); ?>
						</li>
						<li><?php echo esc_html('General polish: notices, dropdown rendering, avatar display, and reliable rule/index syncing.'); ?>
						</li>
						<li><?php echo esc_html('Fixed My Account pagination, WP 6.9 Command Palette, and checkout save issues.'); ?>
						</li>
						<li><?php echo esc_html('Restored legacy hooks for backward compatibility.'); ?></li>
					</ul>
				</details>
			</div>
			<!-- Full changelog link -->
			<div class="wca-full-changelog-footer">
				<div class="wca-inline-note wca-inline-note-margin-top">
					<p><?php echo esc_html('This is a summary of recent changes. For complete version history and detailed release notes:'); ?></p>
					<a class="button button-primary wca-full-changelog-button" href="https://docs.bookingwp.com/appointments/changelog"
					target="_blank" rel="noopener noreferrer">
						<?php echo esc_html('View Full Changelog'); ?>
						<span aria-hidden="true" class="wca-button-arrow">→</span>
					</a>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
	(function () {
		// Main navigation tabs
		const tabs = document.querySelectorAll('.nav-tab-wrapper .nav-tab');
		const mobileSelect = document.querySelector('.wca-mobile-nav-select');
		const mainSections = ['improvements', 'new-calendar', 'documentation', 'future', 'changelog'];
		const improvementSubsections = ['export-improvements', 'performance-improvements', 'admin-improvements', 'rest-api'];

		// Improvements sub-navigation
		const improvementNavItems = document.querySelectorAll('.wca-improvements-nav-item');
		const improvementsContent = document.getElementById('wca-improvements-content');
		const connector = document.getElementById('wca-connector');

		// Get section by ID
		function getSection(id) {
			return document.getElementById(id);
		}

		// Update connector position
		function updateConnector(navItem) {
			if (!connector || !navItem) return;
			const navRect = navItem.getBoundingClientRect();
			const parentRect = navItem.parentElement.getBoundingClientRect();
			const centerX = (navRect.left - parentRect.left) + (navRect.width / 2);
			const percentage = (centerX / parentRect.width) * 100;
			connector.style.setProperty('--connector-x', percentage + '%');
		}

		// Robust switching function that handles rapid clicks
		function switchSection(containerIds, targetId) {
			containerIds.forEach(id => {
				const el = getSection(id);
				if (!el) return;

				if (id === targetId) {
					// Activate target
					if (el.classList.contains('is-hidden') || el.classList.contains('is-animating-out')) {
						el.classList.remove('is-hidden');
						el.classList.remove('is-animating-out');
						el.classList.add('is-animating-in');
						
						// Cleanup after animation
						const onEnd = () => {
							el.classList.remove('is-animating-in');
							el.removeEventListener('animationend', onEnd);
						};
						el.addEventListener('animationend', onEnd);
					}
				} else {
					// Deactivate others
					if (!el.classList.contains('is-hidden')) {
						if (!el.classList.contains('is-animating-out')) {
							el.classList.remove('is-animating-in');
							el.classList.add('is-animating-out');
							
							const onEnd = () => {
								// Only hide if it's still marked as animating out (hasn't been reactivated)
								if (el.classList.contains('is-animating-out')) {
									el.classList.add('is-hidden');
									el.classList.remove('is-animating-out');
								}
								el.removeEventListener('animationend', onEnd);
							};
							el.addEventListener('animationend', onEnd);
						}
					}
				}
			});
		}

		// Activate main tab
		function activateMainTab(targetId) {
			// Update tab active states
			tabs.forEach(tab => tab.classList.remove('nav-tab-active'));
			const activeTab = document.querySelector(`.nav-tab-wrapper .nav-tab[href="#${targetId}"]`);
			if (activeTab) {
				activeTab.classList.add('nav-tab-active');
			}

			// Update mobile select
			if (mobileSelect) {
				mobileSelect.value = targetId;
			}

			// Switch section
			switchSection(mainSections, targetId);

			// Special handling for improvements tab
			if (targetId === 'improvements') {
				// Find currently active improvement subsection or default to first
				const activeSub = document.querySelector('.wca-improvements-nav-item.is-active');
				const subTarget = activeSub ? activeSub.getAttribute('data-target') : 'export-improvements';
				loadImprovementSubsection(subTarget);
			}
		}

		// Load improvement subsection
		function loadImprovementSubsection(targetId) {
			const targetSection = getSection(targetId);
			if (!targetSection) return;

			// Update nav item states
			improvementNavItems.forEach(item => {
				item.classList.remove('is-active');
				item.setAttribute('aria-selected', 'false');
			});
			const activeNavItem = document.querySelector(`.wca-improvements-nav-item[data-target="${targetId}"]`);
			if (activeNavItem) {
				activeNavItem.classList.add('is-active');
				activeNavItem.setAttribute('aria-selected', 'true');
				updateConnector(activeNavItem);
			}

			// Ensure it's in the DOM
			if (targetSection.parentElement !== improvementsContent) {
				improvementsContent.appendChild(targetSection);
			}

			// Switch subsection
			switchSection(improvementSubsections, targetId);
		}

		// Main tab click handlers
		tabs.forEach(tab => {
			tab.addEventListener('click', function (e) {
				e.preventDefault();
				const targetId = this.getAttribute('href').substring(1);
				activateMainTab(targetId);
				history.pushState(null, '', '#' + targetId);
			});
		});

		// Mobile select handler
		if (mobileSelect) {
			mobileSelect.addEventListener('change', function () {
				const targetId = this.value;
				activateMainTab(targetId);
				history.pushState(null, '', '#' + targetId);
			});
		}

		// Improvement nav item click handlers
		improvementNavItems.forEach(item => {
			item.addEventListener('click', function (e) {
				e.preventDefault();
				const targetId = this.getAttribute('data-target');
				loadImprovementSubsection(targetId);
			});
		});

		// Initialize on page load
		function initialize() {
			// Move subsections
			improvementSubsections.forEach(id => {
				const section = getSection(id);
				if (section && section.parentElement !== improvementsContent) {
					improvementsContent.appendChild(section);
				}
			});

			const hash = window.location.hash.substring(1);

			// Determine start state
			if (improvementSubsections.includes(hash)) {
				activateMainTab('improvements');
				// Small timeout to allow main tab to render before switching sub
				setTimeout(() => loadImprovementSubsection(hash), 0);
			} else if (mainSections.includes(hash)) {
				activateMainTab(hash);
			} else {
				activateMainTab('improvements');
				loadImprovementSubsection('export-improvements');
			}
		}

		// Handle hash changes
		window.addEventListener('hashchange', () => {
			const hash = window.location.hash.substring(1);
			if (improvementSubsections.includes(hash)) {
				activateMainTab('improvements');
				loadImprovementSubsection(hash);
			} else if (mainSections.includes(hash)) {
				activateMainTab(hash);
			}
		});

		// Primary button loading indicator
		const primaryButtons = document.querySelectorAll('.wca-whats-new-page .button-primary');
		const clearLoading = () => {
			primaryButtons.forEach(btn => {
				btn.classList.remove('wca-loading');
				btn.removeAttribute('aria-busy');
			});
		};

		primaryButtons.forEach(btn => {
			btn.addEventListener('click', function () {
				if (this.getAttribute('href')?.startsWith('#')) return;
				this.classList.add('wca-loading');
				this.setAttribute('aria-busy', 'true');
			});
		});

		window.addEventListener('pageshow', clearLoading);

		// Roadmap lines
		function updateRoadmapCompletedLine() {
			const roadmap = document.querySelector('.wca-roadmap');
			if (!roadmap) return;

			const completedItems = Array.from(roadmap.querySelectorAll('.wca-roadmap-item.is-complete'));
			if (completedItems.length === 0) {
				roadmap.style.setProperty('--completed-line-height', '0px');
				return;
			}

			const firstCompleted = completedItems[0];
			const lastCompleted = completedItems[completedItems.length - 1];
			const firstTop = firstCompleted.offsetTop;
			const lastBottom = lastCompleted.offsetTop + lastCompleted.offsetHeight;
			const lineHeight = lastBottom - firstTop;
			const lineTop = firstTop;

			// Use style tag for pseudo-element
			const styleId = 'wca-roadmap-completed-line';
			let styleEl = document.getElementById(styleId);
			if (!styleEl) {
				styleEl = document.createElement('style');
				styleEl.id = styleId;
				document.head.appendChild(styleEl);
			}
			styleEl.textContent = `
				.wca-roadmap::after {
					height: ${lineHeight}px !important;
					top: ${lineTop}px !important;
				}
			`;
		}

		function initializeRoadmap() {
			updateRoadmapCompletedLine();
			const futureSection = document.getElementById('future');
			if (futureSection) {
				const observer = new MutationObserver(() => {
					if (!futureSection.classList.contains('is-hidden')) {
						setTimeout(updateRoadmapCompletedLine, 100);
					}
				});
				observer.observe(futureSection, { attributes: true, attributeFilter: ['class'] });
			}
			window.addEventListener('resize', () => {
				setTimeout(updateRoadmapCompletedLine, 100);
			});
		}

		// Run
		initialize();
		initializeRoadmap();
	})();
</script>
