<?php
/**
 * Custom messenger for the EDD SDK using this plugin's text domain.
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'WC_Appointments_License_Messenger' ) && class_exists( \EasyDigitalDownloads\Updater\Messenger::class ) ) {
	class WC_Appointments_License_Messenger extends \EasyDigitalDownloads\Updater\Messenger {
		protected $text_domain = 'woocommerce-appointments';

		/**
		 * Gets the message for an expired license activation attempt.
		 * Excites users about renewal with benefits.
		 *
		 * @since 5.1.0
		 * @param string $expiration_date The expiration date (optional).
		 * @return string
		 */
		public function get_expired_activation_message( $expiration_date = '' ) {
			if ( ! empty( $expiration_date ) ) {
				$message = sprintf(
					/* translators: %s: license expiration date */
					__( 'Your license expired on %s. Renew now to unlock the latest features, priority support, and automatic updates! 🚀', $this->text_domain ),
					$expiration_date
				);
			} else {
				$message = __( 'Your license has expired. Renew now to unlock the latest features, priority support, and automatic updates! 🚀', $this->text_domain );
			}

			return $this->filter_string( $message, 'expired_activation' );
		}
	}
}

