<?php
// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Interface for appointment integration classes.
 *
 * This interface defines the contract that all integration classes should follow,
 * ensuring consistent behavior across different integrations.
 *
 * @package WooCommerce\Appointments\Interfaces
 * @since 5.0.0
 */
interface WC_Appointments_Integration_Interface {

	/**
	 * Initialize the integration by adding hooks and filters.
	 *
	 * This method should be called during the integration's construction
	 * or initialization phase to set up WordPress hooks and filters.
	 *
	 * @return void
	 */
	public function add_hooks(): void;
}

