<?php

/**
 * Translation file for Swedish language.
 *
 * Most strings can be an array, with a value as the key. The system will
 * pick the translation corresponding to the key. The key "else" will be picked
 * if no matching value is found. This is useful for plurals.
 *
 * Licensed under the MIT license.
 *
 * For the full copyright and license information, please view the LICENSE file.
 *
 * @author Rémi Lanvin <remi@cloudconnected.fr>
 * @link https://github.com/rlanvin/php-rrule
 */
return [
	'yearly' => [
		'1' => 'årligen',
		'2' => 'vartannat år',
		'else' => 'var %{interval}:e år'
	],
	'monthly' => [
		'1' => 'månatligen',
		'2' => 'varannan månad',
		'else' => 'var %{interval}:e månad'
	],
	'weekly' => [
		'1' => 'varje vecka',
		'2' => 'varannan vecka',
		'else' => 'var %{interval}:e vecka'
	],
	'daily' => [
		'1' => 'dagligen',
		'2' => 'varannnan dag',
		'else' => 'var %{interval}:e dag'
	],
	'hourly' => [
		'1' => 'varje timme',
		'2' => 'varannan timme',
		'else' => 'var %{interval}:e timme'
	],
	'minutely' => [
		'1' => 'varje minut',
		'2' => 'varannan minut',
		'else' => 'var %{interval}:e minut'
	],
	'secondly' => [
		'1' => 'varje sekund',
		'2' => 'varannan sekund',
		'else' => 'var %{interval}:e sekund'
	],
	'dtstart' => ', börjar %{date}',
	'timeofday' => ' kl %{date}',
	'startingtimeofday' => ' börjar %{date}',
	'infinite' => ', tills vidare',
	'until' => ', t.om %{date}',
	'count' => [
		'1' => ', ett tillfälle',
		'else' => ', %{count} tillfällen'
	],
	'and' => 'och ',
	'x_of_the_y' => [
		'yearly' => '%{x} på året', // ex. den första måndagen på året, eller den första dagen på året,  e.g. the first Monday of the year, or the first day of the year
		'monthly' => '%{x} i månaden',
	],
	'bymonth' => ' i %{months}',
	'months' => [
		1 => 'Januari',
		2 => 'Februari',
		3 => 'Mars',
		4 => 'April',
		5 => 'Maj',
		6 => 'Juni',
		7 => 'Juli',
		8 => 'Augusti',
		9 => 'September',
		10 => 'Oktober',
		11 => 'November',
		12 => 'December',
	],
	'byweekday' => ' på %{weekdays}',
	'weekdays' => [
		1 => 'Måndag',
		2 => 'Tisdag',
		3 => 'Onsdag',
		4 => 'Torsdag',
		5 => 'Fredag',
		6 => 'Lördag',
		7 => 'Söndag',
	],
	'nth_weekday' => [
		'1' => 'den första %{weekday}en', // e.g. the first Monday
		'2' => 'den andra %{weekday}en',
		'else' => 'den %{n}:e %{weekday}en'
	],
	'-nth_weekday' => [
		'-1' => 'den sista %{weekday}en', // e.g. the last Monday
		'-2' => 'näst sista %{weekday}en',
		'else' => 'den %{n}:e %{weekday}en från slutet'
	],
	'byweekno' => [
		'1' => ' i vecka %{weeks}',
		'else' => ' i vecka %{weeks}'
	],
	'nth_weekno' => '%{n}',
	'bymonthday' => '%{monthdays}',
	'nth_monthday' => [
		'1' => 'den 1:a',
		'2' => 'den 2:a',
		'3' => 'den 3:e',
		'21' => 'den 21:a',
		'22' => 'den 22:a',
		'23' => 'den 23:e',
		'31' => 'den 31:a',
		'else' => 'den %{n}:e'
	],
	'-nth_monthday' => [
		'-1' => 'sista dagen',
		'-2' => 'den näst sista dagen',
		'else' => '%{n} dagar från sista dagen'
	],
	'byyearday' => [
		'else' => ' på %{yeardays} dagen'
	],
	'nth_yearday' => [
		'1' => 'den första',
		'2' => 'den andra',
		'3' => 'den tredje',
		'else' => 'den %{n}:e'
	],
	'-nth_yearday' => [
		'-1' => 'sista',
		'-2' => 'den näst sista',
		'else' => '%{n} från sista'
	],
	'byhour' => [
		'else' => ' vid %{hours}'
	],
	'nth_hour' => '%{n}',
	'byminute' => [
		'else' => '.%{minutes}'
	],
	'nth_minute' => '%{n}',
	'bysecond' => [
		'else' => '.%{seconds}'
	],
	'nth_second' => '%{n}',
	'bysetpos' => ', men bara %{setpos} tillfället i serien',
	'nth_setpos' => [
		'1' => 'den första',
		'2' => 'den andra',
		'3' => 'den tredje',
		'else' => 'den %{n}:e'
	],
	'-nth_setpos' => [
		'-1' => 'den sista',
		'-2' => 'den näst sista',
		'else' => 'den %{n}:e sista'
	]
];
