<?php
// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Trait for appointment manager classes.
 *
 * This trait provides common functionality shared by manager classes
 * that handle specific aspects of appointments (cart, checkout, orders, etc.).
 *
 * @package WooCommerce\Appointments\Traits
 * @since 5.0.0
 */
trait WC_Appointments_Manager_Trait {
	/**
	 * Register WordPress hooks for this manager.
	 *
	 * @return void
	 */
	abstract public function register_hooks(): void;

	/**
	 * Check if manager should be active.
	 *
	 * @return bool
	 */
	protected function is_active(): bool {
		return true;
	}

	/**
	 * Get manager name for logging/debugging.
	 *
	 * @return string
	 */
	protected function get_manager_name(): string {
		return static::class;
	}
}

