<?php
// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Trait for appointment meta box classes.
 *
 * This trait provides common properties and functionality shared by
 * all appointment meta box classes.
 *
 * @package WooCommerce\Appointments\Traits
 * @since 5.0.0
 */
trait WC_Appointments_Meta_Box_Trait {

	/**
	 * Meta box ID.
	 *
	 * @var string
	 */
	public string $id;

	/**
	 * Meta box title.
	 *
	 * @var string
	 */
	public string $title;

	/**
	 * Meta box context.
	 *
	 * @var string
	 */
	public string $context;

	/**
	 * Meta box priority.
	 *
	 * @var string
	 */
	public string $priority;

	/**
	 * Meta box post types.
	 *
	 * @var array
	 */
	public array $post_types;

	/**
	 * Meta box inner content method (must be implemented by classes using this trait).
	 *
	 * @param WP_Post $post Post object.
	 * @return void
	 */
	abstract public function meta_box_inner( $post ): void;
}

