/* global wp */
( function() {
	'use strict';
	const { __, setLocaleData } = wp.i18n;
	const { addFilter } = wp.hooks;
	const settings = window.wcSettings || {};

	// Hydrate locale data as a fallback when JSON translations are missing.
	if ( window.wcAppointmentsAnalyticsLocaleData ) {
		setLocaleData( window.wcAppointmentsAnalyticsLocaleData, 'woocommerce-appointments' );
	}

	/**
	 * Add a PRODUCTS item to a dropdown to a report.
	 *
	 * @param {Array} filterConfig - set of filters in a report.
	 * @return {Array} amended set of filters.
	 */
	const addProductsFilters = ( filterConfig ) => {
		const valueToPush = {
			label: __( 'Appointable products', 'woocommerce-appointments' ),
			value: 'appointments'
		};

		filterConfig.forEach( function( obj ) {
			if ( obj.filters ) {
				obj.filters.push( valueToPush );
			}
		} );

		return filterConfig;
	};

	addFilter( 'woocommerce_admin_products_report_filters', 'woocommerce-appointments', addProductsFilters );

	//////////////////////////////////////////////////////////

	/**
	 * Add a MAIN dropdown to a report.
	 *
	 * @param {Array} filters - set of filters in a report.
	 * @return {Array} amended set of filters.
	 */
	const addStaffFilters = ( filters ) => {
		return [
			{
				label: __( 'Staff', 'woocommerce-appointments' ),
				staticParams: [],
				param: 'staff',
				showFilters: () => true,
				defaultValue: 'all',
				filters: [ ...( settings.multiStaff || [] ) ]
			},
			...filters
		];
	};

	addFilter( 'woocommerce_admin_revenue_report_filters', 'woocommerce-appointments', addStaffFilters );
	addFilter( 'woocommerce_admin_orders_report_filters', 'woocommerce-appointments', addStaffFilters );
	addFilter( 'woocommerce_admin_products_report_filters', 'woocommerce-appointments', addStaffFilters );
	addFilter( 'woocommerce_admin_categories_report_filters', 'woocommerce-appointments', addStaffFilters );
	addFilter( 'woocommerce_admin_coupons_report_filters', 'woocommerce-appointments', addStaffFilters );
	addFilter( 'woocommerce_admin_taxes_report_filters', 'woocommerce-appointments', addStaffFilters );
	addFilter( 'woocommerce_admin_dashboard_filters', 'woocommerce-appointments', addStaffFilters );

	/**
	 * Add 'staff' to the list of persisted queries so that the parameter remains
	 * when navigating from report to report.
	 *
	 * @param {Array} params - array of report slugs.
	 * @return {Array} - array of report slugs including 'staff'.
	 */
	const persistQueries = ( params ) => {
		params.push( 'staff' );
		return params;
	};

	addFilter( 'woocommerce_admin_persisted_queries', 'woocommerce-appointments', persistQueries );
} )();
