<?php
/**
 * Admin appointment modal template
 *
 * @package WooCommerce_Appointments
 */

defined( 'ABSPATH' ) || exit;
?>

<script type="text/template" id="tmpl-wc-modal-add-appointment">
	<div class="wc-backbone-modal-dialog ">
		<div class="wc-backbone-modal wc-appointment-modal">
            <div class="wc-backbone-modal-content">
                <section class="wc-backbone-modal-main" role="main">
                    <header class="wc-backbone-modal-header">
                        <h1>
                            <?php esc_html_e( 'Create Appointment', 'woocommerce-appointments' ); ?>
                            <?php
                            // Add a direct link to the legacy 2-step creation flow.
                            // Use data-no-modal to bypass JS interception that opens this modal.
                            $legacy_url = admin_url( 'edit.php?post_type=wc_appointment&page=add_appointment' );
                            ?>
                            <a href="<?php echo esc_url( $legacy_url ); ?>" class="wc-appointment-header-link" data-no-modal="1">
                                <?php esc_html_e( 'Create as a Customer', 'woocommerce-appointments' ); ?>
                            </a>
                        </h1>
                        <div class="wc-appointment-modal-loading" aria-live="polite" aria-busy="false">
                            <span class="spinner is-active"></span>
                        </div>
                        <button class="modal-close modal-close-link dashicons dashicons-no-alt">
                            <span class="screen-reader-text"><?php esc_html_e( 'Close modal panel', 'woocommerce-appointments' ); ?></span>
                        </button>
                    </header>
                    <article class="wc-appointment-modal-content">
                        <?php /* Styles moved to assets/css/appointment-admin-modal.scss */ ?>
                        <form id="wc-appointment-modal-form" class="wc-appointment-modal-form" method="post">
                            <div class="wc-appointment-form-section">
                                <div class="wc-appointment-product-row">
                                    <div class="form-field">
                                        <label for="appointment_product_id"><?php esc_html_e( 'Product', 'woocommerce-appointments' ); ?> <span class="required">*</span></label>
                                        <select id="appointment_product_id" name="appointment_product_id" class="wc-appointment-product-search" data-placeholder="<?php esc_attr_e( 'Search for an appointable product...', 'woocommerce-appointments' ); ?>" data-allow_clear="true" required>
                                            <option value=""><?php esc_html_e( 'Select a product...', 'woocommerce-appointments' ); ?></option>
                                        </select>
                                    </div>
                                    <div class="form-field wc-appointment-qty-field">
                                        <label for="appointment_qty"><?php esc_html_e( 'Quantity', 'woocommerce-appointments' ); ?></label>
                                        <input type="number" id="appointment_qty" name="quantity" min="1" step="1" value="1" />
                                    </div>
                                </div>
                            </div>
                            <div class="wc-appointment-form-section wc-appointment-details">
                                <div class="wc-appointment-datetime-fields form-field-wide">
                                    <div class="form-field wc-appointment-date-field">
                                        <label for="appointment_date"><?php esc_html_e( 'Date', 'woocommerce-appointments' ); ?> <span class="required">*</span></label>
                                        <input type="date" id="appointment_date" name="appointment_date" autocomplete="off" required />
                                    </div>
                                    <div class="wc-appointment-time-range">
                                        <div class="form-field wc-appointment-time-from">
                                            <label for="appointment_time_from"><?php esc_html_e( 'From time', 'woocommerce-appointments' ); ?> <span class="required">*</span></label>
                                            <input type="time" id="appointment_time_from" name="appointment_time_from" />
                                            <!-- Time suggestions overlay injected dynamically -->
                                        </div>
                                        <div class="form-field wc-appointment-time-to">
                                            <label for="appointment_time_to"><?php esc_html_e( 'To time', 'woocommerce-appointments' ); ?> <span class="required">*</span></label>
                                            <input type="time" id="appointment_time_to" name="appointment_time_to" />
                                            <!-- Time suggestions overlay injected dynamically -->
                                        </div>
                                    </div>
                                    <div class="wc-appointment-date-range">
                                        <div class="form-field wc-appointment-date-from">
                                            <label for="appointment_date_from"><?php esc_html_e( 'From date', 'woocommerce-appointments' ); ?> <span class="required">*</span></label>
                                            <input type="date" id="appointment_date_from" name="appointment_date_from" />
                                        </div>
                                        <div class="form-field wc-appointment-date-to">
                                            <label for="appointment_date_to"><?php esc_html_e( 'To date', 'woocommerce-appointments' ); ?> <?php esc_html_e( '(inclusive)', 'woocommerce-appointments' ); ?><span class="required">*</span></label>
                                            <input type="date" id="appointment_date_to" name="appointment_date_to" aria-describedby="appointment_date_to_help" />
                                        </div>
                                    </div>
                                    <div class="wc-appointment-month-range">
                                        <div class="form-field wc-appointment-month-from">
                                            <label for="appointment_month_from"><?php esc_html_e( 'From month', 'woocommerce-appointments' ); ?> <span class="required">*</span></label>
                                            <input type="month" id="appointment_month_from" name="appointment_month_from" />
                                        </div>
                                        <div class="form-field wc-appointment-month-to">
                                            <label for="appointment_month_to"><?php esc_html_e( 'To month', 'woocommerce-appointments' ); ?> <?php esc_html_e( '(inclusive)', 'woocommerce-appointments' ); ?><span class="required">*</span></label>
                                            <input type="month" id="appointment_month_to" name="appointment_month_to" aria-describedby="appointment_month_to_help" />
                                        </div>
                                    </div>
                                    <div class="form-field wc-appointment-staff-field">
                                        <label for="appointment_staff_id"><?php esc_html_e( 'Staff', 'woocommerce-appointments' ); ?></label>
                                        <select id="appointment_staff_id" name="appointment_staff_id" class="wc-enhanced-select" data-allow_clear="true">
                                            <option value=""><?php esc_html_e( 'Any staff member', 'woocommerce-appointments' ); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-field wc-appointment-availability" id="appointment-availability-wrap" style="display:none;">
                                    <span id="appointment-availability-status" class="notice notice-info"></span>
                                </div>
                            </div>
                            <div class="wc-appointment-form-section wc-appointment-status">
                                <div class="form-field">
                                    <label for="appointment_status"><?php esc_html_e( 'Appointment Status', 'woocommerce-appointments' ); ?></label>
                                    <select id="appointment_status" name="appointment_status" class="wc-enhanced-select" data-allow_clear="true">
                                        <option value="confirmed"><?php esc_html_e( 'Confirmed', 'woocommerce-appointments' ); ?></option>
                                        <option value="unpaid"><?php esc_html_e( 'Unpaid', 'woocommerce-appointments' ); ?></option>
                                        <option value="paid"><?php esc_html_e( 'Paid', 'woocommerce-appointments' ); ?></option>
                                        <option value="pending-confirmation"><?php esc_html_e( 'Pending Confirmation', 'woocommerce-appointments' ); ?></option>
                                        <option value="cancelled"><?php esc_html_e( 'Cancelled', 'woocommerce-appointments' ); ?></option>
                                        <option value="complete"><?php esc_html_e( 'Complete', 'woocommerce-appointments' ); ?></option>
                                    </select>
                                </div>
                                <div class="form-field wc-appointment-customer-status-field">
                                    <label for="appointment_customer_status"><?php esc_html_e( 'Customer Status', 'woocommerce-appointments' ); ?></label>
                                    <select id="appointment_customer_status" name="appointment_customer_status" class="wc-enhanced-select" data-allow_clear="true">
                                        <?php
                                        // Use translated labels and canonical keys for customer statuses.
                                        $customer_statuses = array_unique( get_wc_appointment_statuses( 'customer', true ) );
                                        foreach ( $customer_statuses as $key => $value ) {
                                            printf(
                                                '<option value="%s"%s>%s</option>',
                                                esc_attr( $key ),
                                                selected( $key, 'expected', false ),
                                                esc_html__( $value, 'woocommerce-appointments' ),
                                            );
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            <div class="wc-appointment-form-section wc-appointment-customer">
                                <div class="wc-appointment-customer-order-row">
                                    <div class="form-field wc-appointment-customer-field">
                                        <label for="customer_user"><?php esc_html_e( 'Customer', 'woocommerce-appointments' ); ?></label>
                                        <select id="customer_user" name="appointment_customer_id" class="wc-customer-search" data-placeholder="<?php esc_attr_e( 'Guest customer or search for existing customer&hellip;', 'woocommerce-appointments' ); ?>" data-allow_clear="true">
                                            <option value=""><?php esc_html_e( 'Guest', 'woocommerce-appointments' ); ?></option>
                                        </select>
                                    </div>
                                    <div class="form-field wc-appointment-order-type-field">
                                        <label for="order_type"><?php esc_html_e( 'Order', 'woocommerce-appointments' ); ?></label>
                                        <select id="order_type" name="order_type" class="wc-enhanced-select" data-allow_clear="true">
                                            <option value="new"><?php esc_html_e( 'Create a new order', 'woocommerce-appointments' ); ?></option>
                                            <option value="existing"><?php esc_html_e( 'Add to an existing order', 'woocommerce-appointments' ); ?></option>
                                        </select>
                                    </div>
                                    <div class="form-field wc-appointment-existing-order">
                                        <label for="existing_order_id"><?php esc_html_e( 'Existing Order', 'woocommerce-appointments' ); ?></label>
                                        <select id="existing_order_id" name="appointment_order_id" class="wc-order-search" data-placeholder="<?php esc_attr_e( 'Search for an order...', 'woocommerce-appointments' ); ?>" data-allow_clear="true"></select>
                                    </div>
                                </div>
                            </div>
                            <div class="wc-appointment-form-section wc-appointment-billing-details collapsed">
                                <h4><?php esc_html_e( 'Billing', 'woocommerce-appointments' ); ?></h4>
                                <div class="wc-appointment-billing-body">
                                    <div class="wc-appointment-billing-name-fields">
                                        <p class="form-field form-field-first">
                                            <label for="_billing_first_name"><?php esc_html_e( 'First name', 'woocommerce-appointments' ); ?> <span class="required">*</span></label>
                                            <input type="text" id="_billing_first_name" name="_billing_first_name" required />
                                        </p>

                                        <p class="form-field form-field-last">
                                            <label for="_billing_last_name"><?php esc_html_e( 'Last name', 'woocommerce-appointments' ); ?> <span class="required">*</span></label>
                                            <input type="text" id="_billing_last_name" name="_billing_last_name" required />
                                        </p>
                                    </div>

                                    <p class="form-field">
                                        <label for="_billing_company"><?php esc_html_e( 'Company', 'woocommerce-appointments' ); ?></label>
                                        <input type="text" id="_billing_company" name="_billing_company" />
                                    </p>

                                    <p class="form-field">
                                        <label for="_billing_address_1"><?php esc_html_e( 'Address line 1', 'woocommerce-appointments' ); ?></label>
                                        <input type="text" id="_billing_address_1" name="_billing_address_1" />
                                    </p>

                                    <p class="form-field">
                                        <label for="_billing_address_2"><?php esc_html_e( 'Address line 2', 'woocommerce-appointments' ); ?></label>
                                        <input type="text" id="_billing_address_2" name="_billing_address_2" />
                                    </p>

                                    <div class="wc-appointment-billing-location-fields">
                                        <p class="form-field form-field-first">
                                            <label for="_billing_city"><?php esc_html_e( 'City', 'woocommerce-appointments' ); ?></label>
                                            <input type="text" id="_billing_city" name="_billing_city" />
                                        </p>

                                        <p class="form-field form-field-last">
                                            <label for="_billing_postcode"><?php esc_html_e( 'Postcode / ZIP', 'woocommerce-appointments' ); ?></label>
                                            <input type="text" id="_billing_postcode" name="_billing_postcode" />
                                        </p>
                                    </div>

                                    <div class="wc-appointment-billing-region-fields">
                                        <p class="form-field form-field-first">
                                            <label for="_billing_country"><?php esc_html_e( 'Country / Region', 'woocommerce-appointments' ); ?></label>
                                            <select id="_billing_country" name="_billing_country" class="wc-enhanced-select" data-allow_clear="true">
                                                <option value=""><?php esc_html_e( 'Select a country / region&hellip;', 'woocommerce-appointments' ); ?></option>
                                                <?php
                                                foreach ( WC()->countries->get_allowed_countries() as $code => $country ) {
                                                    echo '<option value="' . esc_attr( $code ) . '">' . esc_html( $country ) . '</option>';
                                                }
                                                ?>
                                            </select>
                                        </p>

                                        <p class="form-field form-field-last">
                                            <label for="_billing_state"><?php esc_html_e( 'State / County', 'woocommerce-appointments' ); ?></label>
                                            <select id="_billing_state" name="_billing_state" class="wc-enhanced-select" data-allow_clear="true">
                                                <option value=""><?php esc_html_e( 'Select a state / county&hellip;', 'woocommerce-appointments' ); ?></option>
                                            </select>
                                        </p>
                                    </div>

									<div class="wc-appointment-billing-contact-fields">
										<p class="form-field form-field-first">
											<label for="_billing_email"><?php esc_html_e( 'Email address', 'woocommerce-appointments' ); ?> <span class="required">*</span></label>
											<input type="email" id="_billing_email" name="_billing_email" required />
										</p>

										<p class="form-field form-field-last">
											<label for="_billing_phone"><?php esc_html_e( 'Phone', 'woocommerce-appointments' ); ?></label>
											<input type="tel" id="_billing_phone" name="_billing_phone" />
										</p>
									</div>

									<div class="wc-appointment-billing-account-fields">
										<p class="form-field">
											<label for="appointment_create_account">
												<input type="checkbox" id="appointment_create_account" name="appointment_create_account" value="1" />
												<?php esc_html_e( 'Create an account for this customer', 'woocommerce-appointments' ); ?>
											</label>
										</p>
									</div>

									<div class="wc-appointment-billing-payment-fields">
                                        <p class="form-field form-field-first">
                                            <label for="_payment_method"><?php esc_html_e( 'Payment method', 'woocommerce-appointments' ); ?></label>
                                            <select name="_payment_method" id="_payment_method" class="wc-enhanced-select">
                                                <option value=""><?php esc_html_e( 'N/A', 'woocommerce-appointments' ); ?></option>
                                                <?php
                                                // Populate enabled payment gateways similar to the legacy add-appointment page.
                                                $payment_gateways = WC()->payment_gateways() ? WC()->payment_gateways->payment_gateways() : [];

                                                foreach ( $payment_gateways as $gateway ) {
                                                    if ( 'yes' === $gateway->enabled ) {
                                                        // Skip the appointments gateway used only for confirmation-required bookings.
                                                        if ( 'wcappointmentsgateway' === $gateway->id ) {
                                                            continue;
                                                        }
                                                        echo '<option value="' . esc_attr( $gateway->id ) . '">' . esc_html( $gateway->get_title() ) . '</option>';
                                                    }
                                                }

                                                echo '<option value="other">' . esc_html__( 'Other', 'woocommerce-appointments' ) . '</option>'; // translators: Payment method not listed.
                                                ?>
                                            </select>
                                        </p>
                                        <p class="form-field form-field-last">
                                            <label for="_transaction_id"><?php esc_html_e( 'Transaction ID', 'woocommerce-appointments' ); ?></label>
                                            <input type="text" id="_transaction_id" name="_transaction_id" />
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="wc-appointment-form-section wc-appointment-addons collapsed" id="wc-appointment-addons-section" style="display:none;">
                                <h4 id="appointment_addons_link"><?php esc_html_e( 'Add-ons', 'woocommerce-appointments' ); ?></h4>
                                <div class="wc-appointment-addons-body">
                                    <?php
                                    /**
                                     * Hook to allow product add-ons integration in admin modal
                                     */
                                    do_action( 'woocommerce_before_appointment_form_output_admin_modal', null, null );
                                    ?>
                                    <div id="wc-appointment-addons-container" class="woocommerce">
                                        <div id="wc-appointment-addons-fields"></div>
                                    </div>
                                    <?php
                                    do_action( 'woocommerce_after_appointment_form_output_admin_modal', null, null );
                                    ?>
                                </div>
                                <input type="hidden" id="appointment_override_price_hidden" name="appointment_override_price" />
                                <input type="hidden" id="appointment_calculated_price_raw" name="appointment_calculated_price_raw" />
                            </div>
                        </form>
                    </article>
                    <footer class="wc-backbone-modal-footer">
                        <div class="inner">
                            <div class="wc-appointment-footer-price">
                                <span id="appointment_footer_price" class="price"></span>
                                <button type="button" id="appointment_price_edit" class="button-link" aria-label="<?php esc_attr_e( 'Edit price', 'woocommerce-appointments' ); ?>" style="display:none;"><?php esc_attr_e( 'Edit', 'woocommerce-appointments' ); ?></button>
                                <input type="number" step="0.01" min="0" id="appointment_override_price" style="display:none;" />
                            </div>
                            <!-- Add-ons link moved into form -->
                            <button id="btn-cancel" class="button button-large modal-close"><?php esc_html_e( 'Cancel', 'woocommerce-appointments' ); ?></button>
                            <button id="btn-ok" class="button button-primary button-large"><?php esc_html_e( 'Create Appointment', 'woocommerce-appointments' ); ?></button>
                        </div>
                    </footer>
                </section>
            </div>
		</div>
        <div class="wc-backbone-modal-backdrop modal-close"></div>
	</div>
</script>
