<?php
// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Interface for appointment data objects.
 *
 * This interface defines the contract for data objects that extend WC_Data,
 * ensuring consistent behavior for appointment-related data objects.
 *
 * @package WooCommerce\Appointments\Interfaces
 * @since 5.0.0
 */
interface WC_Appointments_Data_Object_Interface {

	/**
	 * Get the object ID.
	 *
	 * @return int
	 */
	public function get_id();

	/**
	 * Get date created.
	 *
	 * @param string $context What the value is for. Valid values are 'view' and 'edit'.
	 * @return WC_DateTime|int|null Object if the date is set, timestamp as int, or null if there is no date.
	 *                              Different implementations may return different types.
	 */
	public function get_date_created( string $context = 'view' );

	/**
	 * Get date modified.
	 *
	 * @param string $context What the value is for. Valid values are 'view' and 'edit'.
	 * @return WC_DateTime|int|null Object if the date is set, timestamp as int, or null if there is no date.
	 *                              Different implementations may return different types.
	 */
	public function get_date_modified( string $context = 'view' );

	/**
	 * Save the object to the database.
	 *
	 * @return int The object ID.
	 */
	public function save();

	/**
	 * Delete the object from the database.
	 *
	 * @param bool $force_delete Whether to permanently delete the object.
	 * @return bool True on success, false on failure.
	 */
	public function delete( bool $force_delete = false );
}

