<?php
// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Interface for appointment exporter classes.
 *
 * This interface defines the contract for exporter classes that handle
 * exporting appointments to various formats (CSV, ICS, JSON, etc.).
 *
 * @package WooCommerce\Appointments\Interfaces
 * @since 5.0.0
 */
interface WC_Appointments_Exporter_Interface {
	/**
	 * Export appointments to a file.
	 *
	 * @param array $appointments Array of WC_Appointment objects.
	 * @param array $args Optional export arguments.
	 * @return string|false File path on success, false on failure.
	 */
	public function export( array $appointments, array $args = [] );

	/**
	 * Get the export file format/mime type.
	 *
	 * @return string Format identifier (e.g., 'csv', 'ics', 'json').
	 */
	public function get_format(): string;

	/**
	 * Get the file extension for this exporter.
	 *
	 * @return string File extension (e.g., '.csv', '.ics', '.json').
	 */
	public function get_file_extension(): string;
}

