<?php
// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Interface for appointment form handler classes.
 *
 * This interface defines the contract for classes that handle appointment form submissions.
 *
 * @package WooCommerce\Appointments\Interfaces
 * @since 5.0.0
 */
interface WC_Appointments_Form_Handler_Interface {
	/**
	 * Process form submission.
	 *
	 * @param array $posted_data Posted form data.
	 * @param WC_Product_Appointment $product Product being booked.
	 * @return WC_Appointment|WP_Error Created appointment or error.
	 */
	public function process_submission( array $posted_data, WC_Product_Appointment $product );

	/**
	 * Validate form data.
	 *
	 * @param array $posted_data Posted form data.
	 * @param WC_Product_Appointment $product Product being booked.
	 * @return WP_Error|true True if valid, WP_Error if invalid.
	 */
	public function validate_submission( array $posted_data, WC_Product_Appointment $product );
}

