<?php
// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Interface for appointment form renderer classes.
 *
 * This interface defines the contract for classes that render appointment forms.
 *
 * @package WooCommerce\Appointments\Interfaces
 * @since 5.0.0
 */
interface WC_Appointments_Form_Renderer_Interface {
	/**
	 * Render the appointment form.
	 *
	 * @param WC_Product_Appointment $product Product to render form for.
	 * @return void
	 */
	public function render( WC_Product_Appointment $product ): void;

	/**
	 * Prepare form fields.
	 *
	 * @return void
	 */
	public function prepare_fields(): void;
}

