<?php
/**
 * WooCommerce Google Analytics Pro
 *
 * This source file is subject to the GNU General Public License v3.0
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@skyverge.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade WooCommerce Google Analytics Pro to newer
 * versions in the future. If you wish to customize WooCommerce Google Analytics Pro for your
 * needs please refer to http://docs.woocommerce.com/document/woocommerce-google-analytics-pro/ for more information.
 *
 * @author      SkyVerge
 * @copyright   Copyright (c) 2015-2024, SkyVerge, Inc.
 * @license     http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License v3.0
 */

namespace SkyVerge\WooCommerce\Google_Analytics_Pro\Tracking\Events\GA4;

use SkyVerge\WooCommerce\Google_Analytics_Pro\Helpers\Identity_Helper;
use SkyVerge\WooCommerce\Google_Analytics_Pro\Tracking\Adapters\Order_Event_Data_Adapter;
use SkyVerge\WooCommerce\Google_Analytics_Pro\Tracking\Events\GA4_Event;
use WC_Order;

defined( 'ABSPATH' ) or exit;

/**
 * The "place order" event.
 *
 * @since 2.0.0
 */
class Place_Order_Event extends GA4_Event {


	/** @var string the event ID */
	public const ID = 'place_order';


	/**
	 * @inheritdoc
	 */
	public function get_form_field_title(): string {

		return __( 'Place Order', 'woocommerce-google-analytics-pro' );
	}


	/**
	 * @inheritdoc
	 */
	public function get_form_field_description(): string {

		return __( 'Triggered when a customer places an order via checkout.', 'woocommerce-google-analytics-pro' );
	}


	/**
	 * @inheritdoc
	 */
	public function get_default_name(): string {

		return 'place_order';
	}


	/**
	 * @inheritdoc
	 */
	public function register_hooks(): void {

		add_action( 'woocommerce_checkout_order_processed', [ $this, 'track' ] );
		add_action( 'woocommerce_store_api_checkout_order_processed', [ $this, 'track' ] );
	}


	/**
	 * @inheritdoc
	 *
	 * @param int|WC_Order $order_id_or_object the order ID or object
	 */
	public function track( $order_id_or_object = null ): void {

		if ( empty( $order = wc_get_order( $order_id_or_object ) ) ) {
			return;
		}

		$this->record_via_api( array_merge(
			[ 'category' => 'Checkout' ],
			( new Order_Event_Data_Adapter( $order ) )->convert_from_source()
		) );
	}


}
