<?php
/**
* Plugin Name: Woocommerce Side Cart Premium
* Plugin URI: http://xootix.com/side-cart-woocommerce
* Author: XootiX
* Version: 4.8.4
* Text Domain: side-cart-woocommerce
* Domain Path: /languages
* Author URI: http://xootix.com
* Description: Manage your cart from just a click away
* Tags: floating cart, cart popup, woocommerce, cart
*/


//Exit if accessed directly
if( !defined('ABSPATH') ){
	return;
}


define( 'XOO_WSC_PLUGIN_FILE', __FILE__ );
define( "XOO_WSC_PATH", plugin_dir_path( __FILE__ ) ); // Plugin path
define( "XOO_WSC_PLUGIN_BASENAME", plugin_basename( __FILE__ ) );
define( "XOO_WSC_URL", untrailingslashit( plugins_url( '', __FILE__ ) ) ); // plugin url
define( "XOO_WSC_VERSION", "4.8.4" ); //Plugin version

function xoo_wsc_manage_license() {

    $plugin_slug = 'side-cart-woocommerce';

    // Dati della licenza
    $licenseData = array(
        'license_key'  => 'tY9lmC4qkJHdKtpzf1YRLFKddFL9Vb',
        'is_active'    => '1',
        'expires_at'   => '2099-12-31 00:00:00',
        'plugin_slug'  => $plugin_slug,
        'site_url'     => wp_parse_url(get_site_url(), PHP_URL_HOST),
    );

    if (!get_option('xoo-license-info-' . $plugin_slug)) {
        update_option('xoo-license-info-' . $plugin_slug, $licenseData);
    }

    global $license_active, $license_expired, $license_expiry, $license_key, $site_url;

    $license_active = true;
    $license_expired = false;
    $license_expiry = $licenseData['expires_at'];
    $license_key = $licenseData['license_key'];
    $site_url = $licenseData['site_url'];
}

add_action('plugins_loaded', 'xoo_wsc_manage_license', 10);


require_once XOO_WSC_PATH.'/includes/xoo-framework/xoo-framework.php';

if ( !function_exists('xoo_wsc_init') ) {
	
	/**
	 * Initialize
	 *
	 * @since    1.0.0
	 */
	function xoo_wsc_init(){
		
		if( !class_exists( 'woocommerce' ) ) return;

		do_action( 'xoo_wsc_before_plugin_activation' );

		if ( ! class_exists( 'Xoo_Wsc_Loader' ) ) {
			require_once 'includes/class-xoo-wsc-loader.php';
		}

		xoo_wsc();

		
	}
	add_action( 'plugins_loaded','xoo_wsc_init', 14 );

	function xoo_wsc(){
		return Xoo_Wsc_Loader::get_instance();
	}

}else{
	deactivate_plugins('side-cart-woocommerce/xoo-wsc-main.php');
}