<?php
/**
 * Product Threshold Notices Template
 *
 * @version     1.0.0
 * @package     woocommerce-smart-coupons/templates/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( empty( $messages ) || ! is_array( $messages ) ) {
	return;
}

if ( ! function_exists( 'wc_sc_get_badge_for_message' ) ) {
	/**
	 * Auto-detects message type and assigns a colored badge.
	 *
	 * @param string $msg The message text to analyze.
	 * @return array Badge label and CSS class.
	 */
	function wc_sc_get_badge_for_message( $msg ) {

		$badge = array(
			'label' => __( 'Offer', 'woocommerce-smart-coupons' ),
			'class' => 'wc-sc-badge-default',
		);

		if ( strpos( $msg, 'Spend' ) !== false ) {
			$badge = array(
				'label' => __( 'Spend More', 'woocommerce-smart-coupons' ),
				'class' => 'wc-sc-badge-spend',
			);
		}

		if ( strpos( $msg, 'Add' ) !== false ) {
			$badge = array(
				'label' => __( 'Quantity Required', 'woocommerce-smart-coupons' ),
				'class' => 'wc-sc-badge-qty',
			);
		}

		if ( strpos( $msg, '%' ) !== false ) {
			$badge = array(
				'label' => __( 'Percentage Reward', 'woocommerce-smart-coupons' ),
				'class' => 'wc-sc-badge-percent',
			);
		}

		if ( strpos( $msg, '$' ) !== false && strpos( $msg, '%' ) === false ) {
			$badge = array(
				'label' => __( 'Fixed Discount', 'woocommerce-smart-coupons' ),
				'class' => 'wc-sc-badge-fixed',
			);
		}

		return $badge;
	}
}
?>
<style type="text/css">
/* Main box */
.wc-sc-offer-box {
	background: #ffffff;
	border: 1px solid #dce3e1;
	border-radius: 14px;
	padding: 22px 26px;
	margin: 24px 0;
	box-shadow: 0 3px 10px rgba(0,0,0,0.06);
	transition: 0.25s ease-in-out;
}

.wc-sc-offer-box:hover {
	transform: translateY(-2px);
	box-shadow: 0 6px 16px rgba(0,0,0,0.08);
}

/* Header */
.wc-sc-offer-header {
	display: flex;
	align-items: center;
	margin-bottom: 14px;
}

.wc-sc-offer-title {
	font-size: 19px;
	font-weight: 700;
	color: #1e1e1e;
}

/* List layout */
.wc-sc-offer-list {
	list-style: none;
	margin: 0;
	padding: 0;
}

.wc-sc-offer-item {
	display: flex;
	align-items: flex-start;
	margin-bottom: 14px;
	line-height: 1.5;
}

/* Checkmark */
.wc-sc-check {
	color: #22a06b;
	font-size: 18px;
	font-weight: bold;
	margin-right: 12px;
	margin-top: 3px;
}

/* BADGE styles */
.wc-sc-badge {
	font-size: 11px;
	padding: 3px 7px;
	border-radius: 6px;
	font-weight: 600;
	margin-right: 8px;
	display: inline-block;
}

/* Spend More = blue */
.wc-sc-badge-spend {
	background: #e6f1ff;
	color: #2563eb;
}

/* Quantity = orange */
.wc-sc-badge-qty {
	background: #fff4e5;
	color: #d97706;
}

/* Percent reward = purple */
.wc-sc-badge-percent {
	background: #f3e8ff;
	color: #7e22ce;
}

/* Fixed discount = green */
.wc-sc-badge-fixed {
	background: #e8f8f0;
	color: #1c8f4d;
}

/* Default badge */
.wc-sc-badge-default {
	background: #f0f0f0;
	color: #555;
}

/* Message text */
.wc-sc-offer-message strong {
	font-weight: 700;
	color: #222;
}

</style>

<div class="wc-sc-offer-box">
	<div class="wc-sc-offer-header">
		<span class="wc-sc-offer-title"><?php esc_html_e( 'As you shop, the right offer will activate for you:', 'woocommerce-smart-coupons' ); ?></span>
	</div>

	<ul class="wc-sc-offer-list">
		<?php
		foreach ( $messages as $msg ) :
			$badge = wc_sc_get_badge_for_message( $msg );
			?>
			<li class="wc-sc-offer-item">
				<span class="wc-sc-check">✔</span>

				<span class="wc-sc-offer-message">
					<span class="wc-sc-badge <?php echo esc_attr( $badge['class'] ); ?>">
						<?php echo esc_html( $badge['label'] ); ?>
					</span>
					<?php echo wp_kses_post( $msg ); ?>
				</span>
			</li>
		<?php endforeach; ?>
	</ul>
</div>
