<?php
namespace WooLentorPro\Modules\Size_Chart;
use WooLentorPro\Traits\Singleton;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Widgets class.
 */
class Widgets_And_Blocks {
    use Singleton;

	/**
     * Widgets constructor.
     */
    public function __construct() {

        // Elementor Widget
        add_filter( 'woolentor_widget_list', [ $this, 'widget_list' ] );

        // Guttenberg Block
        add_filter('woolentor_block_list', [ $this, 'block_list' ] );

    }

    /**
     * Widget list.
     */
    public function widget_list( $widget_list = [] ) {
        
        $widget_list['single']['wl_size_chart'] = [
            'title'    => esc_html__('Size Chart','woolentor'),
            'location' => WIDGETS_PATH,
        ];

        return $widget_list;
    }

    /**
     * Block list.
     */
    public function block_list( $block_list = [] ){

        $block_list['size_chart'] = [
            'label'  => __('Size Chart','woolentor'),
            'name'   => 'woolentor/size-chart',
            'server_side_render' => true,
            'type'   => 'single',
            'active' => true,
            'location' => BLOCKS_PATH,
            'enqueue_assets' => function(){
                wp_enqueue_style('woolentor-size-chart', MODULE_URL . '/assets/css/size-chart.css', [], WOOLENTOR_VERSION);
            }
        ];

        return $block_list;
    }

}