<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

$uniqClass = 'woolentorblock-' . $settings['blockUniqId'];
$areaClasses = array($uniqClass, 'wl-size-chart-block-widget-area-wrapper');

!empty($settings['className']) ? $areaClasses[] = esc_attr($settings['className']) : '';

if( $settings['icon_position'] == 'after' ){
    $areaClasses[] = 'wl-size-chart-after-icon';
}

$button_icon = '';
if( !empty( $settings['button_icon'] ) ){
	$button_icon = '<i class="'.$settings['button_icon'].'"></i>';
}

$short_code_attributes = [
    'type' => $settings['display_type'],
    'uid'  => $settings['blockUniqId'],
    'button_text' => $settings['button_text'],
    'button_icon' => $button_icon,
];

if( $block['is_editor'] ){
    $short_code_attributes['product_id'] = woolentorBlocks_get_last_product_id();
    $short_code_attributes['force'] = 'on';
}

// Get module default settings for table colors
$module_defaults = array(
    'table_header_bg_color'      => woolentor_get_option( 'table_head_bg_color', 'woolentor_size_chart_settings' ),
    'table_header_text_color'    => woolentor_get_option( 'table_head_text_color', 'woolentor_size_chart_settings' ),
    'table_even_row_bg_color'    => woolentor_get_option( 'table_even_row_bg_color', 'woolentor_size_chart_settings' ),
    'table_even_row_text_color'  => woolentor_get_option( 'table_even_row_text_color', 'woolentor_size_chart_settings' ),
    'table_odd_row_bg_color'     => woolentor_get_option( 'table_odd_row_bg_color', 'woolentor_size_chart_settings' ),
    'table_odd_row_text_color'   => woolentor_get_option( 'table_odd_row_text_color', 'woolentor_size_chart_settings' ),
);

// Build inline styles for module defaults when block attributes are empty
$inline_styles = '';
$wrapper_selector = '.' . $uniqClass . '.wl-size-chart-block-widget-area-wrapper';

if ( empty( $settings['table_header_bg_color'] ) && !empty( $module_defaults['table_header_bg_color'] ) ) {
    $inline_styles .= $wrapper_selector . ' .wl-size-chart-table thead tr { background-color: ' . esc_attr( $module_defaults['table_header_bg_color'] ) . '; }';
}
if ( empty( $settings['table_header_text_color'] ) && !empty( $module_defaults['table_header_text_color'] ) ) {
    $inline_styles .= $wrapper_selector . ' .wl-size-chart-table thead th { color: ' . esc_attr( $module_defaults['table_header_text_color'] ) . '; }';
}
if ( empty( $settings['table_even_row_bg_color'] ) && !empty( $module_defaults['table_even_row_bg_color'] ) ) {
    $inline_styles .= $wrapper_selector . ' .wl-size-chart-table tbody tr:nth-child(even) { background-color: ' . esc_attr( $module_defaults['table_even_row_bg_color'] ) . '; }';
}
if ( empty( $settings['table_even_row_text_color'] ) && !empty( $module_defaults['table_even_row_text_color'] ) ) {
    $inline_styles .= $wrapper_selector . ' .wl-size-chart-table tbody tr:nth-child(even) td { color: ' . esc_attr( $module_defaults['table_even_row_text_color'] ) . '; }';
}
if ( empty( $settings['table_odd_row_bg_color'] ) && !empty( $module_defaults['table_odd_row_bg_color'] ) ) {
    $inline_styles .= $wrapper_selector . ' .wl-size-chart-table tbody tr:nth-child(odd) { background-color: ' . esc_attr( $module_defaults['table_odd_row_bg_color'] ) . '; }';
}
if ( empty( $settings['table_odd_row_text_color'] ) && !empty( $module_defaults['table_odd_row_text_color'] ) ) {
    $inline_styles .= $wrapper_selector . ' .wl-size-chart-table tbody tr:nth-child(odd) td { color: ' . esc_attr( $module_defaults['table_odd_row_text_color'] ) . '; }';
}

echo '<div class="' . implode(' ', $areaClasses) . '">';
    if ( !empty( $inline_styles ) ) {
        echo '<style>' . $inline_styles . '</style>';
    }
    echo woolentor_do_shortcode( 'woolentor_size_chart', $short_code_attributes );
echo '</div>';