<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Woolentor_Wl_Size_Chart_Widget extends Widget_Base{
    public function get_name() {
        return 'woolentor_size_chart';
    }
    
    public function get_title() {
        return __( 'WL: Size Chart', 'woolentor' );
    }

    public function get_icon() {
        return 'eicon-image-box';
    }

    public function get_categories() {
        return [ 'woolentor-addons-pro' ];
    }

    public function get_help_url() {
        return 'https://woolentor.com/documentation/';
    }

    public function get_style_depends(){
        return ['woolentor-size-chart'];
    }

    public function get_keywords(){
        return ['single','product','size chart','woolentor','shoplentor'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_general',
            [
                'label' => __( 'Settings', 'woolentor' ),
            ]
        );
            
            $this->add_control(
                'display_type',
                [
                    'label' => __( 'Display Type', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'popup' => __( 'Popup', 'woolentor' ),
                        'normal' => __( 'Normal', 'woolentor' ),
                    ],
                    'default' => 'popup',
                ]
            );

            $this->add_control(
                'button_text',
                [
                    'label' => __( 'Button Text', 'woolentor' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Size Chart', 'woolentor' ),
                    'condition' => [
                        'display_type' => 'popup',
                    ],
                ]
            );

            $this->add_control(
                'button_icon',
                [
                    'label' => __( 'Button Icon', 'woolentor' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'far fa-chart-bar',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'display_type' => 'popup',
                    ],
                ]
            );

            $this->add_control(
                'icon_position',
                [
                    'label' => __( 'Icon Position', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'before' => __( 'Before', 'woolentor' ),
                        'after' => __( 'After', 'woolentor' ),
                    ],
                    'default' => 'before',
                    'condition' => [
                        'display_type' => 'popup',
                    ],
                ]
            );

        $this->end_controls_section(); // General Settings

        // Button Style Controls.
        $this->start_controls_section(
            'size_chart_button_section',
            [
                'label' => __( 'Button', 'woolentor' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'display_type' => 'popup',
                ],
            ]
        );

            $this->add_control(
                'button_padding',
                [
                    'label' => __( 'Padding', 'woolentor' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .wl-size-chart-block-widget-area-wrapper .wl-size-chart-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            
         $this->start_controls_tabs('button_style_tabs');

            $this->start_controls_tab(
                'button_normal_tab',
                [
                    'label' => __( 'Normal', 'woolentor' ),
                ]
            );

                $this->add_control(
                    'button_bg_color',
                    [
                        'label' => __( 'Background Color', 'woolentor' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .wl-size-chart-block-widget-area-wrapper .wl-size-chart-button' => 'background-color: {{VALUE}} !important;',
                        ],
                    ]
                );

                $this->add_control(
                    'button_text_color',
                    [
                        'label' => __( 'Text Color', 'woolentor' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .wl-size-chart-block-widget-area-wrapper .wl-size-chart-button' => 'color: {{VALUE}} !important;',
                        ],
                    ]
                );



            $this->end_controls_tab();

            $this->start_controls_tab(
                'button_hover_tab',
                [
                    'label' => __( 'Hover', 'woolentor' ),
                ]
            );
                $this->add_control(
                    'button_hover_bg_color',
                    [
                        'label' => __( 'Background Color', 'woolentor' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .wl-size-chart-block-widget-area-wrapper .wl-size-chart-button:hover' => 'background-color: {{VALUE}} !important;',
                        ],
                    ]
                );

                $this->add_control(
                    'button_hover_text_color',
                    [
                        'label' => __( 'Text Color', 'woolentor' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .wl-size-chart-block-widget-area-wrapper .wl-size-chart-button:hover' => 'color: {{VALUE}} !important;',
                        ],
                    ]
                );

            $this->end_controls_tab();

         $this->end_controls_tabs();

        $this->end_controls_section(); // Button Style Controls

        // Table Style Controls.
        $this->start_controls_section(
            'size_chart_table_section',
            [
                'label' => __( 'Table', 'woolentor' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_control(
                'table_header_bg_color',
                [
                    'label' => __( 'Head BG Color', 'woolentor' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => woolentor_get_option( 'table_head_bg_color', 'woolentor_size_chart_settings' ),
                    'selectors' => [
                        '{{WRAPPER}} .wl-size-chart-block-widget-area-wrapper .wl-size-chart-table thead tr' => 'background-color: {{VALUE}} !important;',
                    ],
                ]
            );

            $this->add_control(
                'table_header_text_color',
                [
                    'label' => __( 'Head Text Color', 'woolentor' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => woolentor_get_option( 'table_head_text_color', 'woolentor_size_chart_settings' ),
                    'selectors' => [
                        '{{WRAPPER}} .wl-size-chart-block-widget-area-wrapper .wl-size-chart-table thead th' => 'color: {{VALUE}} !important;',
                    ],
                ]
            );

            $this->add_control(
                'table_even_row_bg_color',
                [
                    'label' => __( 'Even Row BG Color', 'woolentor' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => woolentor_get_option( 'table_even_row_bg_color', 'woolentor_size_chart_settings' ),
                    'selectors' => [
                        '{{WRAPPER}} .wl-size-chart-block-widget-area-wrapper .wl-size-chart-table tbody tr:nth-child(even)' => 'background-color: {{VALUE}} !important;',
                    ],
                ]
            );

            $this->add_control(
                'table_even_row_text_color',
                [
                    'label' => __( 'Even Row Text Color', 'woolentor' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => woolentor_get_option( 'table_even_row_text_color', 'woolentor_size_chart_settings' ),
                    'selectors' => [
                        '{{WRAPPER}} .wl-size-chart-block-widget-area-wrapper .wl-size-chart-table tbody tr:nth-child(even) td' => 'color: {{VALUE}} !important;',
                    ],
                ]
            );

            $this->add_control(
                'table_odd_row_bg_color',
                [
                    'label' => __( 'Odd Row BG Color', 'woolentor' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => woolentor_get_option( 'table_odd_row_bg_color', 'woolentor_size_chart_settings' ),
                    'selectors' => [
                        '{{WRAPPER}} .wl-size-chart-block-widget-area-wrapper .wl-size-chart-table tbody tr:nth-child(odd)' => 'background-color: {{VALUE}} !important;',
                    ],
                ]
            );

            $this->add_control(
                'table_odd_row_text_color',
                [
                    'label' => __( 'Odd Row Text Color', 'woolentor' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => woolentor_get_option( 'table_odd_row_text_color', 'woolentor_size_chart_settings' ),
                    'selectors' => [
                        '{{WRAPPER}} .wl-size-chart-block-widget-area-wrapper .wl-size-chart-table tbody tr:nth-child(odd) td' => 'color: {{VALUE}} !important;',
                    ],
                ]
            );

        $this->end_controls_section(); // End Product Title Style Controls.

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $id       = $this->get_id();

        if( Plugin::instance()->editor->is_edit_mode() ){
            $product = wc_get_product( woolentor_get_last_product_id() );
        }else{
            global $product;
        }

        $button_icon = !empty( $settings['button_icon']['value'] ) ? woolentor_render_icon( $settings, 'button_icon' ) : '';

        $short_code_attributes = [
            'type' => $settings['display_type'],
            'uid'  => $id,
            'product_id' => $product->get_id(),
            'button_text' => $settings['button_text'],
            'button_icon' => $button_icon
        ];

        $class = '';
        if( $settings['icon_position'] == 'after' ){
            $class = 'wl-size-chart-after-icon';
        }

        echo '<div class="wl-size-chart-block-widget-area-wrapper ' . esc_attr($class) . '">';
            echo woolentor_do_shortcode( 'woolentor_size_chart', $short_code_attributes );
        echo '</div>';

    }
}