<?php
/**
* @class WooPackCheckout
*/
class WooPackCheckout extends FLBuilderModule {
    /**
    * Constructor function for the module. You must pass the
    * name, description, dir and url in an array to the parent class.
    *
    * @method __construct
    */
    public function __construct()
    {
        parent::__construct(array(
            'name' 				=> __('Checkout', 'woopack'),
            'description' 		=> __('Module to render and style WooCommerce Checkout form.', 'woopack'),
            'group'             => WooPack_Helper::get_modules_group(),
            'category' 			=> WOOPACK_CAT,
            'dir' 				=> WOOPACK_DIR . 'modules/checkout/',
            'url' 				=> WOOPACK_URL . 'modules/checkout/',
            'editor_export' 	=> true, // Defaults to true and can be omitted.
            'enabled' 			=> true, // Defaults to true and can be omitted.
		));
	}
	public function filter_settings( $settings, $helper ) {
		// Handle old Button Settings.
		$settings = filter_product_button_settings( $settings );

		// Handle old Form Border setting.
		$settings = WooPack_Fields::handle_border_field( $settings, array(
			'form_border_style'		=> array(
				'type'					=> 'style'
			),
			'form_border_width'		=> array(
				'type'					=> 'width'
			),
			'form_border_color'		=> array(
				'type'					=> 'color'
			),
			'form_border_radius'	=> array(
				'type'					=> 'radius'
			),
			'form_shadow_h'      	=> array(
				'type'              	=> 'shadow_horizontal',
				'condition'         	=> isset( $settings->form_shadow ) ? 'yes' == $settings->form_shadow : false
			),
			'form_shadow_v'      	=> array(
				'type'              	=> 'shadow_vertical',
				'condition'         	=> isset( $settings->form_shadow ) ? 'yes' == $settings->form_shadow : false
			),
			'form_shadow_blur'   	=> array(
				'type'              	=> 'shadow_blur',
				'condition'         	=> isset( $settings->form_shadow ) ? 'yes' == $settings->form_shadow : false
			),
			'form_shadow_spread'	=> array(
				'type'              	=> 'shadow_spread',
				'condition'         	=> isset( $settings->form_shadow ) ? 'yes' == $settings->form_shadow : false
			),
			'form_shadow_color'		=> array(
				'type'              	=> 'shadow_color',
				'condition'         	=> isset( $settings->form_shadow ) ? 'yes' == $settings->form_shadow : false
			)
		), 'form_border_group' );

		// Handle old Input Border setting.
		$settings = WooPack_Fields::handle_border_field( $settings, array(
			'input_border_style'	=> array(
				'type'					=> 'style'
			),
			'input_border_width'	=> array(
				'type'					=> 'width'
			),
			'input_border_color'	=> array(
				'type'					=> 'color'
			),
			'input_border_radius'	=> array(
				'type'					=> 'radius'
			),
            'inpur_shadow_h'      	=> array(
                'type'              	=> 'shadow_horizontal',
                'condition'         	=> isset( $settings->inpur_shadow ) ? 'yes' == $settings->inpur_shadow : false
            ),
            'inpur_shadow_v'      	=> array(
                'type'              	=> 'shadow_vertical',
                'condition'         	=> isset( $settings->inpur_shadow ) ? 'yes' == $settings->inpur_shadow : false
            ),
            'inpur_shadow_blur'   	=> array(
                'type'              	=> 'shadow_blur',
                'condition'         	=> isset( $settings->inpur_shadow ) ? 'yes' == $settings->inpur_shadow : false
            ),
            'inpur_shadow_spread'	=> array(
                'type'              	=> 'shadow_spread',
                'condition'         	=> isset( $settings->inpur_shadow ) ? 'yes' == $settings->inpur_shadow : false
            ),
            'inpur_shadow_color'	=> array(
                'type'              	=> 'shadow_color',
                'condition'         	=> isset( $settings->inpur_shadow ) ? 'yes' == $settings->inpur_shadow : false
            )
		), 'input_border_group' );

		// Handle old Form Header Typography setting.
		$settings = WooPack_Fields::handle_typography_field( $settings, array(
			'form_header_font'   			=> array(
				'type'          				=> 'font'
			),
			'form_header_font_size_custom'	=> array(
				'type'          				=> 'font_size',
				'condition'     				=> ( isset( $settings->form_header_font_size ) && 'custom' == $settings->form_header_font_size )
			),
			'form_header_text_transform'	=> array(
				'type'          				=> 'text_transform',
			),
			'form_header_line_height'		=> array(
				'type'          				=> 'line_height',
			),
			'form_header_align'				=> array(
				'type'          				=> 'text_align',
			),
		), 'form_header_typography' );

		// Handle old Form Header Typography setting.
		$settings = WooPack_Fields::handle_typography_field( $settings, array(
			'form_label_font'   			=> array(
				'type'          				=> 'font'
			),
			'form_label_font_size_custom'	=> array(
				'type'          				=> 'font_size',
				'condition'     				=> ( isset( $settings->form_label_font_size ) && 'custom' == $settings->form_label_font_size )
			),
			'form_label_text_transform'		=> array(
				'type'          				=> 'text_transform',
			),
			'form_label_line_height'		=> array(
				'type'          				=> 'line_height',
			),
			'form_label_align'				=> array(
				'type'          				=> 'text_align',
			),
		), 'form_label_typography' );

		// Handle old Table Title Typography setting.
		$settings = WooPack_Fields::handle_typography_field( $settings, array(
			'table_title_font'   			=> array(
				'type'          				=> 'font'
			),
			'table_title_font_size_custom'	=> array(
				'type'          				=> 'font_size',
				'condition'     				=> ( isset( $settings->table_title_font_size ) && 'custom' == $settings->table_title_font_size )
			),
			'table_title_text_transform'	=> array(
				'type'          				=> 'text_transform',
			),
			'table_title_line_height'		=> array(
				'type'          				=> 'line_height',
			),
			'table_title_align'				=> array(
				'type'          				=> 'text_align',
			),
		), 'table_title_typography' );

		// Handle old Table Heade Typography setting.
		$settings = WooPack_Fields::handle_typography_field( $settings, array(
			'table_header_font'   			=> array(
				'type'          				=> 'font'
			),
			'table_header_font_size_custom'	=> array(
				'type'          				=> 'font_size',
				'condition'     				=> ( isset( $settings->table_header_font_size ) && 'custom' == $settings->table_header_font_size )
			),
			'table_header_text_transform'	=> array(
				'type'          				=> 'text_transform',
			),
			'table_header_line_height'		=> array(
				'type'          				=> 'line_height',
			),
		), 'table_header_typography' );

		// Handle old Cart Item Typography setting.
		$settings = WooPack_Fields::handle_typography_field( $settings, array(
			'table_font'   				=> array(
				'type'          			=> 'font'
			),
			'table_font_size_custom'	=> array(
				'type'          			=> 'font_size',
				'condition'     			=> ( isset( $settings->table_font_size ) && 'custom' == $settings->table_font_size )
			),
			'table_font_line_height'	=> array(
				'type'          			=> 'line_height',
			),
		), 'cart_item_typography' );

		// Handle old Coupons Typography setting.
		$settings = WooPack_Fields::handle_typography_field( $settings, array(
			'coupon_font'   			=> array(
				'type'          			=> 'font'
			),
			'coupon_font_size_custom'	=> array(
				'type'          			=> 'font_size',
				'condition'     			=> ( isset( $settings->coupon_font_size ) && 'custom' == $settings->coupon_font_size )
			),
			'coupon_font_line_height'	=> array(
				'type'          			=> 'line_height',
			),
		), 'coupon_typography' );

		// Handle old Payment Method Typography setting.
		$settings = WooPack_Fields::handle_typography_field( $settings, array(
			'payment_method_font'   			=> array(
				'type'          			=> 'font'
			),
			'payment_method_font_size_custom'	=> array(
				'type'          			=> 'font_size',
				'condition'     			=> ( isset( $settings->payment_method_font_size ) && 'custom' == $settings->payment_method_font_size )
			),
			'payment_method_font_line_height'	=> array(
				'type'          			=> 'line_height',
			),
		), 'payment_method_typography' );

		return $settings;
	}

	public function get_checkout_style() {
		return isset( $this->settings->checkout_style ) ? $this->settings->checkout_style : 'legacy';
	}

	public function woocommerce_checkout_before_customer_details() {
		?>
		<div class="woopack-checkout-container">
			<!-- open checkout-container -->
			<div class="woopack-checkout-column woopack-checkout-column-1">
				<!-- open checkout-column-1 -->
		<?php
			do_action( 'woopack_checkout_column_1_start', $this->settings );
	}

	public function woocommerce_checkout_after_customer_details() {
		?>
		<!-- close checkout-column-1 -->
		</div>
		<?php
	}

	public function woocommerce_checkout_before_order_review_heading_1() {
		$sticky_class = '';
		if ( isset( $this->settings->sticky_right_column ) && 'yes' === $this->settings->sticky_right_column ) {
			$sticky_class = ' woopack-checkout-column-sticky';
		}
		?>
		<div class="woopack-checkout-column woopack-checkout-column-2">
			<!-- open checkout-column-2 -->
			<div class="woopack-checkout-column-inner<?php echo $sticky_class; ?>">
				<!-- open checkout-column-inner -->
		<?php
	}

	public function woocommerce_checkout_before_order_review_heading_2() {
		?>
		<div class="woopack-checkout-order-review">
			<!-- open checkout-order-review -->
		<?php
	}

	public function woocommerce_checkout_order_review() {
		?>
			<!--close wc_order_review-->
			</div>
		<!-- close checkout-order-review -->
		</div>
	
		<?php do_action( 'woopack_checkout_before_payment_section', $this->settings ); ?>
	
		<div class="woopack-checkout-payment">
			<!-- open checkout-payment -->
		<?php
	}

	public function woocommerce_checkout_after_order_review() {
		?>
				<!-- close checkout-payment -->
				</div>
			<!-- close checkout-column-2 -->
			</div>
		<!-- close checkout-container -->
		</div>
		<?php
	}

	public function render_woocommerce_checkout_login_form() {
		if ( 'no' === get_option( 'woocommerce_enable_checkout_login_reminder' ) ) {
			return;
		}
		if ( is_user_logged_in() && ! FLBuilderModel::is_builder_active() ) {
			return;
		}
		echo '<div class="woopack-checkout-login-form">';
		woocommerce_checkout_login_form();
		echo '</div>';
	}

	public function render_woocommerce_checkout_coupon_form() {
		$coupon_box_display = true;

		if ( isset( $this->settings->show_coupon ) && 'no' === $this->settings->show_coupon ) {
			$coupon_box_display = false;
		}

		if ( ( WC()->cart->needs_payment() || isset( $_GET['fl_builder'] ) ) && wc_coupons_enabled() && $coupon_box_display ) {
			?>
			<div class="woopack-checkout-coupon">
				<div class="woocommerce-form-coupon-toggle">
					<div class="woocommerce-info">
						<?php esc_html_e( 'Have a coupon?', 'woopack' ); ?> <a href="#" class="showcoupon"><?php esc_html_e( 'Click here to enter your coupon code', 'woopack' ); ?></a>
					</div>
				</div>
				<div class="checkout_coupon">
					<p><?php esc_html_e( 'If you have a coupon code, please apply it below.', 'woopack' ); ?></p>
					<p class="form-row form-row-first">
						<input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_html_e( 'Coupon code', 'woopack' ); ?>" id="coupon_code" value="">
					</p>
					<p class="form-row form-row-last">
						<button type="submit" class="button" name="apply_coupon" value="Apply coupon"><?php esc_html_e( 'Apply coupon', 'woopack' ); ?></button>
					</p>
				</div>
				<div class="clear"></div>
			</div>
			<?php
		}
	}

	public function add_render_hooks() {
		add_filter( 'gettext', array( $this, 'translate_text' ), 20, 3 );

		add_action( 'woocommerce_checkout_before_customer_details', array( $this, 'woocommerce_checkout_before_customer_details' ), 5 );
		add_action( 'woocommerce_checkout_after_customer_details', array( $this, 'woocommerce_checkout_after_customer_details' ), 95 );
		add_action( 'woocommerce_checkout_before_order_review_heading', array( $this, 'woocommerce_checkout_before_order_review_heading_1' ), 5 );
		add_action( 'woocommerce_checkout_before_order_review_heading', array( $this, 'woocommerce_checkout_before_order_review_heading_2' ), 95 );
		add_action( 'woocommerce_checkout_order_review', array( $this, 'woocommerce_checkout_order_review' ), 15 );
		add_action( 'woocommerce_checkout_after_order_review', array( $this, 'woocommerce_checkout_after_order_review' ), 95 );

		// remove the default login & coupon form the original place, we will be placing them in correct location.
		remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_login_form', 10 );
		remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_coupon_form', 10 );

		add_action( 'woocommerce_before_checkout_form', array( $this, 'render_woocommerce_checkout_login_form' ) );
		add_action( 'woopack_checkout_before_payment_section', array( $this, 'render_woocommerce_checkout_coupon_form' ) );
	}

	public function remove_render_hooks() {
		remove_filter( 'gettext', array( $this, 'translate_text' ), 20, 3 );

		remove_action( 'woocommerce_checkout_before_customer_details', array( $this, 'woocommerce_checkout_before_customer_details' ), 5 );
		remove_action( 'woocommerce_checkout_after_customer_details', array( $this, 'woocommerce_checkout_after_customer_details' ), 95 );
		remove_action( 'woocommerce_checkout_before_order_review_heading', array( $this, 'woocommerce_checkout_before_order_review_heading_1' ), 5 );
		remove_action( 'woocommerce_checkout_before_order_review_heading', array( $this, 'woocommerce_checkout_before_order_review_heading_2' ), 95 );
		remove_action( 'woocommerce_checkout_order_review', array( $this, 'woocommerce_checkout_order_review' ), 15 );
		remove_action( 'woocommerce_checkout_after_order_review', array( $this, 'woocommerce_checkout_after_order_review' ), 95 );
	}

	public function translate_text( $translation, $text, $domain ) {
		if ( 'woocommerce' !== $domain && 'woopack' !== $domain ) {
			return $translation;
		}

		$settings = $this->settings;

		$strings = array(
			'Billing details'        => isset( $settings->billing_details_title ) ? $settings->billing_details_title : '',
			'Billing &amp; Shipping' => isset( $settings->billing_details_title ) ? $settings->billing_details_title : '',
			'Ship to a different address?' => isset( $settings->shipping_details_title ) ? $settings->shipping_details_title : '',
			'Additional information' => isset( $settings->additional_info_title ) ? $settings->additional_info_title : '',
			'Your Order' => isset( $settings->your_order_title ) ? $settings->your_order_title : '',
			'Your order' => isset( $settings->your_order_title ) ? $settings->your_order_title : '',
			'Have a coupon?' => isset( $settings->coupon_title ) ? $settings->coupon_title : '',
			'Click here to enter your coupon code' => isset( $settings->coupon_link_text ) ? $settings->coupon_link_text : '',
			'Returning customer?' => isset( $settings->returning_customer_title ) ? $settings->returning_customer_title : '',
			'Click here to login' => isset( $settings->returning_customer_link_text ) ? $settings->returning_customer_link_text : '',
		);

		$strings = apply_filters( 'woopack_checkout_gettext_translations', $strings, $settings );

		return isset( $strings[ $text ] ) && ! empty( $strings[ $text ] ) ? $strings[ $text ] : $translation;
	}
}
/**
* Register the module and its form settings.
*/
FLBuilder::register_module('WooPackCheckout', array(
    'checkout_sections' => array(
        'title'    => __('Sections', 'woopack'),
        'sections' => array(
            'layout' => array(
                'title'  => __('General', 'woopack'),
                'fields' => array(
					'checkout_style' => array(
						'type'    => 'select',
						'label'   => __( 'Style', 'woopack' ),
						'default' => 'legacy',
						'options' => array(
							'legacy'   => __( 'Legacy', 'woopack' ),
							'enhanced' => __( 'Enhanced', 'woopack' ),
						),
						'toggle' => array(
							'enhanced' => array(
								'sections' => array( 'returning_customer', 'billing_details', 'shipping_details', 'coupon', 'additional_information', 'your_order' ),
								'fields'   => array( 'sticky_right_column', 'sticky_top_offset', 'second_column_width' ),
							),
						),
					),
                    'checkout_layout' => array(
                        'type'    => 'select',
                        'label'   => __('Layout', 'woopack'),
                        'default' => '1column',
                        'options' => array(
                            '1column' => __('One Column', 'woopack'),
                            '2column' => __('Two Column', 'woopack'),
                        ),
                    ),
					'sticky_right_column' => array(
						'type'    => 'select',
						'label'   => __( 'Sticky Right Column', 'woopack' ),
						'default' => 'no',
						'options' => array(
							'yes' => __( 'Yes', 'woopack' ),
							'no'  => __( 'No', 'woopack' ),
						),
					),
					'sticky_top_offset' => array(
						'type'       => 'unit',
						'label'      => __( 'Sticky Top Offset', 'woopack' ),
						'units'      => array( 'px' ),
						'responsive' => true
					),
                ),
            ),
			'form_columns' => array(
				'title'     => __('Columns', 'woopack'),
				'collapsed' => false,
                'fields'    => array(
					'first_column_width' => array(
                        'type'       => 'unit',
                        'label'      => __('First Column Width', 'woopack'),
						'default'    => '50',
                        'units'      => array('%'),
						'slider'     => true,
                        'responsive' => true,
                    ),
                    'space_bw_columns' => array(
                        'type'       => 'unit',
                        'label'      => __('Space between columns', 'woopack'),
                        'default'    => '2',
						'units'      => array('%', 'px'),
						'slider'     => true,
                        'responsive' => true,
                    ),
                ),
            ),
			'returning_customer' => array(
				'title'     => __( 'Returning Customer', 'woopack' ),
				'collapsed' => true,
				'fields'    => array(
					'returning_customer_title' => array(
						'type'        => 'text',
						'label'       => __( 'Section Title', 'woopack' ),
						'default'     => __( 'Returning customer?', 'woopack' ),
						'connections' => array( 'string' ),
					),
					'returning_customer_link_text' => array(
						'type'        => 'text',
						'label'       => __( 'Link Text', 'woopack' ),
						'default'     => __( 'Click here to login', 'woopack' ),
						'connections' => array( 'string' ),
					),
				),
			),
			'billing_details' => array(
				'title'     => __( 'Billing Details', 'woopack' ),
				'collapsed' => true,
				'fields'    => array(
					'billing_details_title' => array(
						'type'        => 'text',
						'label'       => __( 'Section Title', 'woopack' ),
						'default'     => __( 'Billing Details', 'woopack' ),
						'connections' => array( 'string' ),
					),
				),
			),
			'shipping_details' => array(
				'title'     => __( 'Shipping Details', 'woopack' ),
				'collapsed' => true,
				'fields'    => array(
					'shipping_details_title' => array(
						'type'        => 'text',
						'label'       => __( 'Section Title', 'woopack' ),
						'default'     => __( 'Ship to a different address?', 'woopack' ),
						'connections' => array( 'string' ),
					),
				),
			),
			'coupon' => array(
				'title'     => __( 'Coupon', 'woopack' ),
				'collapsed' => true,
				'fields'    => array(
					'show_coupon' => array(
						'type'    => 'select',
						'label'   => __( 'Show Coupon', 'woopack' ),
						'default' => 'yes',
						'options' => array(
							'yes' => __( 'Yes', 'woopack' ),
							'no'  => __( 'No', 'woopack' ),
						),
						'toggle' => array(
							'yes' => array(
								'fields' => array( 'coupon_title', 'coupon_link_text' ),
							),
						),
					),
					'coupon_title' => array(
						'type'        => 'text',
						'label'       => __( 'Section Title', 'woopack' ),
						'default'     => __( 'Have a coupon?', 'woopack' ),
						'connections' => array( 'string' ),
					),
					'coupon_link_text' => array(
						'type'        => 'text',
						'label'       => __( 'Link Text', 'woopack' ),
						'default'     => __( 'Click here to enter your coupon code', 'woopack' ),
						'connections' => array( 'string' ),
					),
				),
			),
			'additional_information' => array(
				'title'     => __( 'Additional information', 'woopack' ),
				'collapsed' => true,
				'fields'    => array(
					'show_additional_info' => array(
						'type'    => 'select',
						'label'   => __( 'Show Additional information', 'woopack' ),
						'default' => 'yes',
						'options' => array(
							'yes' => __( 'Yes', 'woopack' ),
							'no'  => __( 'No', 'woopack' ),
						),
						'toggle' => array(
							'yes' => array(
								'fields' => array( 'additional_info_title' )
							),
						),
					),
					'additional_info_title' => array(
						'type'        => 'text',
						'label'       => __( 'Section Title', 'woopack' ),
						'default'     => __( 'Additional information', 'woopack' ),
						'connections' => array( 'string' ),
					),
				),
			),
			'your_order' => array(
				'title'     => __( 'Your Order', 'woopack' ),
				'collapsed' => true,
				'fields'    => array(
					'your_order_title' => array(
						'type'        => 'text',
						'label'       => __( 'Section Title', 'woopack' ),
						'default'     => __( 'Your Order', 'woopack' ),
						'connections' => array( 'string' ),
					),
				),
			),
        ),
    ),
	'style' => array(
		'title'    => __( 'Style', 'woopack' ),
		'sections' => array(
			'form_sections' => array(
				'title'     => __('Sections', 'woopack'),
				'collapsed' => true,
                'fields'    => array(
                    'form_bg_color' => array(
                        'type'        => 'color',
                        'label'       => __('Background Color', 'woopack'),
                        'default'     => '',
                        'show_reset'  => true,
                        'show_alpha'  => true,
						'connections' => array( 'color' ),
                    ),
					'form_title_color' => array(
						'type'        => 'color',
                        'label'       => __('Title Color', 'woopack'),
                        'default'     => '',
                        'show_reset'  => true,
						'connections' => array( 'color' ),
					),
					'form_border_group'	=> array(
						'type'       => 'border',
						'label'      => __('Border', 'woopack'),
						'responsive' => true,
					),
					'form_padding_top_bottom' => array(
                        'type'       => 'unit',
                        'label'      => __('Top & Bottom Padding', 'woopack'),
						'units'      => array('px'),
						'slider'     => true,
                        'responsive' => true,
                    ),
                    'form_padding_right_left' => array(
                        'type'       => 'unit',
                        'label'      => __('Right & Left Padding', 'woopack'),
						'units'      => array('px'),
						'slider'     => true,
                        'responsive' => true,
                    ),
					'form_space' => array(
                        'type'       => 'unit',
                        'label'      => __('Space between sections', 'woopack'),
                        'default'    => 20,
						'units'      => array('px'),
						'slider'     => true,
                        'responsive' => true,
                    ),
                ),
            ),
			'table_header_style' => array(
                'title'     => __('Order Summary - Table Header', 'woopack'),
				'collapsed' => true,
                'fields'    => array(
					'table_header_color' => array(
                        'type'        => 'color',
                        'label'       => __('Text Color', 'woopack'),
                        'default'     => '',
                        'show_reset'  => true,
						'connections' => array( 'color' ),
                        'preview'      => array(
                            'type'     => 'css',
                            'selector' => 'table.shop_table thead th',
                            'property' => 'color',
                        ),
                    ),
                    'table_header_padding' => array(
                        'type'       => 'unit',
                        'label'      => __('Vertical Spacing', 'woopack'),
						'units'      => array('px'),
						'slider'     => true,
						'responsive' => true,
                        'preview'    => array(
                            'type'  => 'css',
                            'rules' => array(
                                array(
                                    'selector' => 'table.shop_table thead th',
                                    'property' => 'padding-top',
                                    'unit'     => 'px',
                                ),
                                array(
                                    'selector' => 'table.shop_table thead th',
                                    'property' => 'padding-bottom',
                                    'unit'     => 'px',
                                ),
                            ),
                        ),
                    ),
					'table_header_h_padding' => array(
                        'type'       => 'unit',
                        'label'      => __('Horizontal Spacing', 'woopack'),
						'units'      => array('px'),
						'slider'     => true,
						'responsive' => true,
                        'preview'    => array(
                            'type'  => 'css',
                            'rules' => array(
                                array(
                                    'selector' => 'table.shop_table thead th',
                                    'property' => 'padding-left',
                                    'unit'     => 'px',
                                ),
                                array(
                                    'selector' => 'table.shop_table thead th',
                                    'property' => 'padding-right',
                                    'unit'     => 'px',
                                ),
                            ),
                        ),
                    ),
                    'table_header_border_width' => array(
                        'type'       => 'unit',
                        'label'      => __('Separator Width', 'woopack'),
						'units'      => array('px'),
						'slider'     => true,
						'responsive' => true,
                        'preview'    => array(
                            'type'     => 'css',
                            'selector' => 'table.shop_table thead th',
                            'property' => 'border-bottom-width',
                            'unit'     => 'px',
                        ),
                    ),
                    'table_header_border_color' => array(
                        'type'        => 'color',
                        'label'       => __('Separator Color', 'woopack'),
                        'show_reset'  => true,
                        'show_alpha'  => true,
						'connections' => array( 'color' ),
                    ),
                ),
            ),
            'table_item_style' => array(
				'title'     => __('Order Summary - Table Body', 'woopack'),
				'collapsed' => true,
                'fields'    => array(
					'table_color' => array(
                        'type'        => 'color',
                        'label'       => __('Text Color', 'woopack'),
                        'default'     => '',
                        'show_reset'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => 'table.shop_table td, table.shop_table tfoot th',
                            'property' => 'color',
                        ),
                    ),
                    'cart_item_even_color' => array(
                        'type'        => 'color',
                        'label'       => __('Even Rows Background Color', 'woopack'),
                        'show_reset'  => true,
                        'show_alpha'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => '.cart_item:nth-child(even), table.shop_table tfoot tr:nth-child(even)',
                            'property' => 'background-color',
                        ),
                    ),
                    'cart_item_odd_color' => array(
                        'type'        => 'color',
                        'label'       => __('Odd Rows Background Color', 'woopack'),
                        'show_reset'  => true,
                        'show_alpha'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => '.cart_item:nth-child(odd), table.shop_table tfoot tr:nth-child(odd)',
                            'property' => 'background-color',
                        ),
                    ),
					'cart_item_padding' => array(
                        'type'       => 'unit',
                        'label'      => __('Vertical Spacing', 'woopack'),
						'units'      => array('px'),
						'slider'     => true,
						'responsive' => true,
                        'preview'    => array(
                            'type'  => 'css',
                            'rules' => array(
                                array(
                                    'selector' => 'table.shop_table td, table.shop_table tfoot td, table.shop_table tfoot th',
                                    'property' => 'padding-top',
                                    'unit'     => 'px',
                                ),
                                array(
                                    'selector' => 'table.shop_table td, table.shop_table tfoot td, table.shop_table tfoot th',
                                    'property' => 'padding-bottom',
                                    'unit'     => 'px',
                                ),
                            ),
                        ),
                    ),
					'cart_item_h_padding' => array(
                        'type'       => 'unit',
                        'label'      => __('Horizontal Spacing', 'woopack'),
						'units'      => array('px'),
						'slider'     => true,
						'responsive' => true,
                        'preview'    => array(
                            'type'  => 'css',
                            'rules' => array(
                                array(
                                    'selector' => 'table.shop_table td, table.shop_table tfoot td, table.shop_table tfoot th',
                                    'property' => 'padding-left',
                                    'unit'     => 'px',
                                ),
                                array(
                                    'selector' => 'table.shop_table td, table.shop_table tfoot td, table.shop_table tfoot th',
                                    'property' => 'padding-right',
                                    'unit'     => 'px',
                                ),
                            ),
                        ),
                    ),
                    'cart_item_border_width' => array(
                        'type'       => 'unit',
                        'label'      => __('Separator Width', 'woopack'),
                        'default'    => '0',
						'units'      => array('px'),
						'slider'     => true,
						'responsive' => true,
                        'preview'    => array(
                            'type'     => 'css',
                            'selector' => '.woocommerce table.shop_table tbody td',
                            'property' => 'border-bottom-width',
                            'unit'     => 'px',
                        ),
                    ),
                    'cart_item_border_color' => array(
                        'type'        => 'color',
                        'label'       => __('Separator Color', 'woopack'),
                        'show_reset'  => true,
                        'show_alpha'  => true,
						'connections' => array( 'color' ),
                    ),
                ),
            ),
			'table_footer_style' => array(
				'title'     => __( 'Order Summary - Table Footer', 'woopack' ),
				'collapsed' => true,
				'fields'    => array(
					'table_footer_color' => array(
                        'type'        => 'color',
                        'label'       => __('Text Color', 'woopack'),
                        'show_reset'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => 'table.shop_table tfoot th, table.shop_table tfoot td',
                            'property' => 'color',
                        ),
                    ),
					'cart_total_border_width' => array(
						'type'       => 'unit',
                        'label'      => __('Separator Width (before Total)', 'woopack'),
                        'default'    => '0',
						'units'      => array('px'),
						'slider'     => true,
						'responsive' => true,
                        'preview'    => array(
                            'type'     => 'css',
                            'selector' => '.woocommerce table.shop_table tr.order-total th, .woocommerce table.shop_table tr.order-total td',
                            'property' => 'border-top-width',
                            'unit'     => 'px',
                        ),
					),
					'cart_total_border_color' => array(
                        'type'        => 'color',
                        'label'       => __('Separator Color', 'woopack'),
                        'show_reset'  => true,
                        'show_alpha'  => true,
						'connections' => array( 'color' ),
                    ),
				),
			),
			'coupon_style' => array(
				'title'     => __( 'Coupon', 'woopack' ),
				'collapsed' => true,
				'fields'    => array(
					'coupon_color' => array(
                        'type'        => 'color',
                        'label'       => __('Text Color', 'woopack'),
                        'show_reset'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => '.woocommerce-form-coupon-toggle .woocommerce-info',
                            'property' => 'color',
                        ),
                    ),
                    'coupon_link_color' => array(
                        'type'        => 'color',
                        'label'       => __('Link Text Color', 'woopack'),
                        'show_reset'  => true,
						'connections' => array( 'color' ),
                        'preview'      => array(
                            'type'     => 'css',
                            'selector' => '.woocommerce-form-coupon-toggle .woocommerce-info a',
                            'property' => 'color',
                        ),
                    ),
				),
			),
            'payment_method_style' => array(
				'title'     => __('Payment Method', 'woopack'),
				'collapsed' => true,
                'fields'    => array(
                    'payment_method_label_color' => array(
                        'type'        => 'color',
                        'label'       => __('Label Color', 'woopack'),
                        'show_reset'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => '#payment ul.payment_methods label',
                            'property' => 'color',
                        ),
                    ),
                    'payment_method_box_text_color' => array(
                        'type'        => 'color',
                        'label'       => __('Message Text Color', 'woopack'),
                        'show_reset'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => '#payment div.payment_box p',
                            'property' => 'color',
                        ),
                    ),
                    'payment_method_box_bg_color' => array(
                        'type'        => 'color',
                        'label'       => __('Message Background Color', 'woopack'),
                        'show_reset'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => '#payment div.payment_box',
                            'property' => 'background',
                        ),
                    ),
                    'payment_method_box_top_bottom_padding' => array(
                        'type'       => 'unit',
                        'label'      => __('Message Top & Bottom Padding', 'woopack'),
						'units'      => array('px'),
						'slider'     => true,
						'responsive' => true,
                        'preview'    => array(
                            'type'  => 'css',
                            'rules' => array(
                                array(
                                    'selector' => '#payment div.payment_box',
                                    'property' => 'padding-top',
                                    'unit'     => 'px',
                                ),
                                array(
                                    'selector' => '#payment div.payment_box',
                                    'property' => 'padding-bottom',
                                    'unit'     => 'px',
                                ),
                            ),
                        ),
                    ),
                    'payment_method_box_right_left_padding' => array(
                        'type'       => 'unit',
                        'label'      => __('Message Right & Left Padding', 'woopack'),
						'units'      => array('px'),
						'slider'     => true,
						'responsive' => true,
                        'preview'    => array(
                            'type'  => 'css',
                            'rules' => array(
                                array(
                                    'selector' => '#payment div.payment_box',
                                    'property' => 'padding-right',
                                    'unit'     => 'px',
                                ),
                                array(
                                    'selector' => '#payment div.payment_box',
                                    'property' => 'padding-left',
                                    'unit'     => 'px',
                                ),
                            ),
                        ),
                    ),
                ),
            ),
			'messages_style' => array(
                'title'     => __('Messages', 'woopack'),
				'collapsed' => true,
                'fields'    => array(
                    'error_bg_color' => array(
                        'type'       => 'color',
                        'label'      => __('Error Field Background Color', 'woopack'),
                        'show_reset' => true,
                        'show_alpha' => true,
                        'preview'    => array(
                            'type'     => 'css',
                            'selector' => '.woocommerce-error',
                            'property' => 'background-color',
                        ),
                    ),
                    'error_text_color' => array(
                        'type'       => 'color',
                        'label'      => __('Error Field Message Text Color', 'woopack'),
                        'show_reset' => true,
                        'show_alpha' => true,
                        'preview'    => array(
                            'type'     => 'css',
                            'selector' => '.woocommerce-error',
                            'property' => 'color',
                        ),
                    ),
                    'error_border_color' => array(
                        'type'       => 'color',
                        'label'      => __('Error Field Border Color', 'woopack'),
                        'show_reset' => true,
                        'show_alpha' => true,
                        'preview'    => array(
                            'type'     => 'css',
                            'selector' => '.woocommerce-error',
                            'property' => 'border-color',
                        ),
                    ),
                ),
            ),
		),
	),
    'inputs' => array(
        'title'    => __('Inputs', 'woopack'),
        'sections' => array(
            'input_color' => array(
                'title'  => __('Color', 'woopack'),
                'fields' => array(
                    'input_text_color' => array(
                        'type'        => 'color',
                        'label'       => __('Text Color', 'woopack'),
                        'show_reset'  => true,
                        'show_alpha'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => 'form .form-row input.input-text, form .form-row textarea, form .form-row select',
                            'property' => 'color',
                        ),
                    ),
                    'input_bg_color' => array(
                        'type'        => 'color',
                        'label'       => __('Background Color', 'woopack'),
                        'show_reset'  => true,
                        'show_alpha'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => 'form .form-row input.input-text, form .form-row textarea, form .form-row select',
                            'property' => 'background-color',
                        ),
                    ),
                    'placeholder_color' => array(
                        'type'        => 'color',
                        'label'       => __('Placeholder Color', 'woopack'),
                        'show_reset'  => true,
                        'show_alpha'  => true,
						'connections' => array( 'color' ),
                    ),
                ),
            ),
            'input_border' => array(
				'title'     => __('Border', 'woopack'),
				'collapsed' => true,
                'fields'    => array(
					'input_border_group' => array(
						'type'       => 'border',
						'label'      => __('Border', 'woopack'),
						'responsive' => true,
						'preview'    => array(
							'type'     => 'css',
							'selector' => 'form .form-row input.input-text, form .form-row textarea, form .form-row select',
						),
					),
					'inpur_shadow_direction' => array(
                        'type'    => 'select',
                        'label'   => __('Shadow Direction', 'woopack'),
                        'default' => 'out',
                        'options' => array(
                            'out'   => __('Outside', 'woopack'),
                            'inset' => __('Inside', 'woopack'),
                        ),
                    ),
                    'input_border_focus' => array(
                        'type'        => 'color',
                        'label'       => __('Border Focus Color', 'woopack'),
                        'show_reset'  => true,
                        'show_alpha'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => 'form .form-row input.input-text:focus',
                            'property' => 'border-color',
                        ),
                    ),
                    'input_border_invalid' => array(
                        'type'        => 'color',
                        'label'       => __('Border Invalid Color', 'woopack'),
                        'show_reset'  => true,
                        'show_alpha'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => '',
                            'property' => 'border-color',
                        ),
                    ),
                ),
            ),
            'input_alignment' => array(
				'title'     => __('Size & Alignment', 'woopack'),
				'collapsed' => true,
                'fields'    => array(
                    'input_height' => array(
                        'type'       => 'unit',
                        'label'      => __('Input Height', 'woopack'),
                        'default'    => '34',
						'units'      => array('px'),
						'slider'     => true,
						'responsive' => true,
                        'preview'    => array(
                            'type'     => 'css',
                            'selector' => 'form .form-row input.input-text, form .form-row select',
                            'property' => 'height',
                            'unit'     => 'px',
                        ),
                    ),
                    'textarea_height' => array(
                        'type'       => 'unit',
                        'label'      => __('Textarea Height', 'woopack'),
						'units'      => array('px'),
						'slider'     => true,
						'responsive' => true,
                        'preview'    => array(
                            'type'     => 'css',
                            'selector' => 'form .form-row textarea',
                            'property' => 'height',
                            'unit'     => 'px',
                        ),
                    ),
                    'input_text_align' => array(
                        'type'    => 'align',
                        'label'   => __('Text Alignment', 'woopack'),
                        'default' => 'left',
                        'preview' => array(
                            'type'     => 'css',
                            'selector' => 'form .form-row input.input-text, form .form-row textarea, form .form-row select',
                            'property' => 'text-align-last',
                        ),
                    ),
                ),
            ),
            'input_spacing' => array(
				'title'     => __('Spacing', 'woopack'),
				'collapsed' => true,
                'fields'    => array(
                    'input_padding' => array(
                        'type'       => 'dimension',
                        'label'      => __('Padding', 'woopack'),
						'units'      => array('px'),
						'slider'     => true,
						'responsive' => true,
                        'preview'    => array(
                            'type'     => 'css',
                            'selector' => 'form .form-row input.input-text, form .form-row textarea, form .form-row select',
                            'property' => 'padding',
                            'unit'     => 'px'
                        ),
                    ),
					'input_margin_bottom' => array(
                        'type'       => 'unit',
                        'label'      => __('Margin Bottom', 'woopack'),
						'units'      => array('px'),
						'slider'     => true,
						'responsive' => true,
                        'preview'    => array(
                            'type'     => 'css',
                            'selector' => 'form .form-row input.input-text, form .form-row textarea, form .form-row select',
                            'property' => 'margin-bottom',
                            'unit'     => 'px'
                        ),
                    ),
                ),
            ),
			'input_typography' => array(
				'title'     => __( 'Typography', 'woopack' ),
				'collapsed' => true,
				'fields'    => array(
					'input_typography' => array(
						'type'       => 'typography',
						'label'      => __( 'Typography', 'woopack' ),
						'responsive' => true,
						'preview'    => array(
							'type'     => 'css',
							'selector' => 'form .form-row input.input-text, form .form-row textarea, form .form-row select',
						),
					),
				),
			),
        ),
	),
    'button' => array(
        'title'    => __('Button', 'woopack'),
        'sections' => woopack_product_button_fields()
    ),
    'typography' => array(
        'title'    => __('Typography', 'woopack'),
        'sections' => array(
            'form_header_fonts' => array(
                'title'  => __('Customer Details Title', 'woopack'),
                'fields' => array(
					'form_header_typography' => array(
						'type'       => 'typography',
						'label'      => __( 'Typography', 'woopack' ),
						'responsive' => true,
						'preview'    => array(
							'type'     => 'css',
							'selector' => '#customer_details h3, #customer_details h3 label',
						),
					),
                    'form_header_color' => array(
                        'type'        => 'color',
                        'label'       => __('Text Color', 'woopack'),
                        'show_reset'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => '#customer_details h3, #customer_details h3 label',
                            'property' => 'color',
                        ),
                    ),
                ),
            ),
            'form_label_fonts' => array(
				'title'     => __('Customer Details Label', 'woopack'),
				'collapsed' => true,
                'fields'    => array(
					'form_label_typography' => array(
						'type'       => 'typography',
						'label'      => __( 'Typography', 'woopack' ),
						'responsive' => true,
						'preview'    => array(
							'type'     => 'css',
							'selector' => '.form-row label',
						),
					),
                    'form_label_color' => array(
                        'type'        => 'color',
                        'label'       => __('Text Color', 'woopack'),
                        'show_reset'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => '.form-row label',
                            'property' => 'color',
                        ),
                    ),
                    'form_label_invalid_color' => array(
                        'type'        => 'color',
                        'label'       => __('Invalid Text Color', 'woopack'),
                        'show_reset'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => '.form-row.woocommerce-invalid label',
                            'property' => 'color',
                        ),
                    ),
                ),
            ),
            'table_title_fonts' => array(
				'title'     => __('Order Summary Title', 'woopack'),
				'collapsed' => true,
                'fields'    => array(
					'table_title_typography' => array(
						'type'       => 'typography',
						'label'      => __( 'Typography', 'woopack' ),
						'responsive' => true,
						'preview'    => array(
							'type'     => 'css',
							'selector' => '#order_review_heading',
						),
					),
                    'table_title_color' => array(
                        'type'        => 'color',
                        'label'       => __('Text Color', 'woopack'),
                        'show_reset'  => true,
						'connections' => array( 'color' ),
                        'preview'     => array(
                            'type'     => 'css',
                            'selector' => '#order_review_heading',
                            'property' => 'color',
                        ),
                    ),
                ),
            ),
            'table_header_fonts' => array(
				'title'     => __('Order Summary - Table Header', 'woopack'),
				'collapsed' => true,
                'fields'    => array(
					'table_header_typography' => array(
						'type'       => 'typography',
						'label'      => __( 'Typography', 'woopack' ),
						'responsive' => true,
						'preview'    => array(
							'type'     => 'css',
							'selector' => 'table.shop_table thead th',
						),
					),
                ),
            ),
            'table_fonts' => array(
				'title'     => __('Order Summary - Table Items', 'woopack'),
				'collapsed' => true,
                'fields'    => array(
                    'cart_item_typography' => array(
                        'type'       => 'typography',
                        'label'      => __('Typography', 'woopack'),
						'responsive' => true,
                        'preview'    => array(
                            'type'     => 'css',
							'selector' => 'table.shop_table td, table.shop_table tfoot td, table.shop_table tfoot th',
                        ),
                    ),
                ),
            ),
			'table_footer_fonts' => array(
				'title'     => __('Order Summary - Table Footer', 'woopack'),
				'collapsed' => true,
                'fields'    => array(
					'table_footer_typography' => array(
						'type'       => 'typography',
						'label'      => __( 'Typography', 'woopack' ),
						'responsive' => true,
						'preview'    => array(
							'type'     => 'css',
							'selector' => 'table.shop_table tfoot th, table.shop_table tfoot td',
						),
					),
                ),
            ),
            'coupon_typography' => array(
				'title'     => __('Coupon', 'woopack'),
				'collapsed' => true,
                'fields'    => array(
                    'coupon_typography' => array(
                        'type'       => 'typography',
                        'label'      => __('Typography', 'woopack'),
						'responsive' => true,
						'preview'    => array(
                            'type'     => 'css',
                            'selector' => '.woocommerce-info',
                        ),
                    ),
                ),
            ),
            'payment_method_fonts' => array(
				'title'     => __('Payment Method', 'woopack'),
				'collapsed' => true,
                'fields'    => array(
                    'payment_method_typography' => array(
						'type'       => 'typography',
                        'label'      => __('Typography', 'woopack'),
                        'responsive' => true,
                        'preview'    => array(
                            'type'     => 'css',
                            'selector' => '#payment ul.payment_methods li',
                        ),
                    ),
                    'payment_method_msg_font_size' => array(
                        'type'       => 'unit',
                        'label'      => __('Message Font Size', 'woopack'),
						'slider'     => true,
						'units'      => array( 'px' ),
                        'responsive' => true,
                        'preview'    => array(
                            'type'     => 'css',
                            'selector' => '#payment div.payment_box, #payment div.payment_box p',
                            'property' => 'font-size',
                            'unit'     => 'px',
                        ),
                    ),
                ),
            ),
        ),
    ),
));
