<?php
// *************************************** Typography ***************************************
// Button Typography
FLBuilderCSS::typography_field_rule( array(
	'settings'		=> $settings,
	'setting_name' 	=> 'button_typography',
	'selector' 		=> ".fl-node-$id .woocommerce .woocommerce-checkout input.button,
						.fl-node-$id .woocommerce .woocommerce-checkout #place_order",
) );

// Form Header Typography
FLBuilderCSS::typography_field_rule( array(
	'settings'		=> $settings,
	'setting_name' 	=> 'form_header_typography',
	'selector' 		=> ".fl-node-$id #customer_details h3,
						.fl-node-$id #customer_details h3 label",
) );

// Form Label Typography
FLBuilderCSS::typography_field_rule( array(
	'settings'		=> $settings,
	'setting_name' 	=> 'form_label_typography',
	'selector' 		=> ".fl-node-$id .woocommerce form .form-row label",
) );

// Table Title Typography
FLBuilderCSS::typography_field_rule( array(
	'settings'		=> $settings,
	'setting_name' 	=> 'table_title_typography',
	'selector' 		=> ".fl-node-$id .woocommerce #order_review_heading",
) );

// Table Header Typography
FLBuilderCSS::typography_field_rule( array(
	'settings'		=> $settings,
	'setting_name' 	=> 'table_header_typography',
	'selector' 		=> ".fl-node-$id .woocommerce table.shop_table thead th",
) );

// Table Body Typography
FLBuilderCSS::typography_field_rule( array(
	'settings'		=> $settings,
	'setting_name' 	=> 'cart_item_typography',
	'selector' 		=> ".fl-node-$id .woocommerce table.shop_table td"
) );

// Table Footer Typography
FLBuilderCSS::typography_field_rule( array(
	'settings'		=> $settings,
	'setting_name' 	=> 'table_footer_typography',
	'selector' 		=> ".fl-node-$id .woocommerce table.shop_table tfoot td,
						.fl-node-$id .woocommerce table.shop_table tfoot th",
) );

// Coupon Typography
FLBuilderCSS::typography_field_rule( array(
	'settings'		=> $settings,
	'setting_name' 	=> 'coupon_typography',
	'selector' 		=> ".fl-node-$id .woocommerce .woocommerce-info",
) );

// Payment Method Typography
FLBuilderCSS::typography_field_rule( array(
	'settings'		=> $settings,
	'setting_name' 	=> 'payment_method_typography',
	'selector' 		=> ".fl-node-$id .woocommerce #payment ul.payment_methods li",
) );
?>
.fl-node-<?php echo $id; ?> .woocommerce .select2-container--default .select2-selection--single,
.fl-node-<?php echo $id; ?> .woocommerce form .form-row.woocommerce-validated .select2-container--default .select2-selection--single {
	display: flex;
    align-items: center;
    position: relative;
}
.fl-node-<?php echo $id; ?> .woocommerce .select2-container--default .select2-selection--single .select2-selection__arrow,
.fl-node-<?php echo $id; ?> .woocommerce form .form-row.woocommerce-validated .select2-container--default .select2-selection--single .select2-selection__arrow {
	top: 50%;
    transform: translateY(-50%);
}

.fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced .woocommerce h3 {
	margin-top: 0;
}
.fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced .woocommerce form.login,
.fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced .woocommerce table.shop_table,
.fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced .woocommerce .woocommerce-info,
.fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced .woocommerce .woopack-checkout-coupon .checkout_coupon,
.fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced .woocommerce #payment {
	background: none;
    border: 0;
    margin-bottom: 0;
	padding: 0 !important;
}
.fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced .woocommerce .woopack-checkout-coupon .checkout_coupon {
	margin-top: 20px;
	display: none;
}
body.fl-builder-edit .fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced .woocommerce .woopack-checkout-coupon .checkout_coupon {
	display: block;
}
.fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced .woocommerce .woopack-checkout-coupon .woocommerce-error {
	margin-bottom: 0;
    margin-top: 10px;
}
.fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced .woocommerce .woopack-checkout-coupon .woocommerce-error + .checkout_coupon {
	display: block !important;
	height: auto !important;
}
.fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced .woocommerce form .form-row #order_comments {
	height: 70px;
}
<?php
$selectors = "
.fl-node-$id .woopack-checkout.style-legacy .woocommerce .woocommerce-form-login,
.fl-node-$id .woopack-checkout.style-legacy #customer_details,
.fl-node-$id .woopack-checkout.style-enhanced #customer_details .col-1,
.fl-node-$id .woopack-checkout.style-enhanced #customer_details .woocommerce-shipping-fields .shipping_address,
.fl-node-$id .woopack-checkout.style-enhanced #customer_details .woocommerce-additional-fields,
.fl-node-$id .woopack-checkout.style-legacy .woocommerce table.shop_table,
.fl-node-$id .woopack-checkout.style-enhanced .woocommerce .woopack-checkout-order-review,
.fl-node-$id .woopack-checkout.style-legacy .woocommerce .woocommerce-info,
.fl-node-$id .woopack-checkout.style-legacy .woocommerce .checkout_coupon,
.fl-node-$id .woopack-checkout.style-enhanced .woocommerce .woopack-checkout-coupon,
.fl-node-$id .woopack-checkout.style-enhanced .woocommerce .woopack-checkout-login-form,
.fl-node-$id .woopack-checkout.style-legacy .woocommerce #payment,
.fl-node-$id .woopack-checkout.style-enhanced .woocommerce .woopack-checkout-payment";

// Section border.
FLBuilderCSS::border_field_rule( array(
	'settings' 		=> $settings,
	'setting_name' 	=> 'form_border_group',
	'selector' 		=> $selectors,
) );

// Section padding top.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'form_padding_top_bottom',
	'selector'     => $selectors,
	'prop'         => 'padding-top',
	'unit'         => 'px'
) );

// Section padding bottom.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'form_padding_top_bottom',
	'selector'     => $selectors,
	'prop'         => 'padding-bottom',
	'unit'         => 'px'
) );

// Section padding left.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'form_padding_right_left',
	'selector'     => $selectors,
	'prop'         => 'padding-left',
	'unit'         => 'px'
) );

// Section padding right.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'form_padding_right_left',
	'selector'     => $selectors,
	'prop'         => 'padding-right',
	'unit'         => 'px'
) );

// Section margin bottom.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'form_space',
	'selector'     => $selectors,
	'prop'         => 'margin-bottom',
	'unit'         => 'px'
) );
?>
<?php echo $selectors; ?> {
	<?php if ( '' == $settings->form_bg_color ) { ?>
		background: none;
	<?php } ?>
	<?php WooPack_Helper::print_css( 'background-color', $settings->form_bg_color ); ?>
	<?php WooPack_Helper::print_css( 'margin-bottom', 20, 'px', '' === $settings->form_space ); ?>
	margin-top: 0;
}
<?php if ( isset( $settings->form_title_color ) && ! empty( $settings->form_title_color ) ) { ?>
.fl-node-<?php echo $id; ?> .woopack-checkout .woocommerce h3 {
	color: #<?php echo $settings->form_title_color; ?>;
}
<?php } ?>

<?php
// Space after WooCommerce notice and legacy shop table.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'form_space',
	'selector'     => ".fl-node-$id .woocommerce-NoticeGroup, .fl-node-$id .woopack-checkout.style-legacy .woocommerce table.shop_table",
	'prop'         => 'margin-bottom',
	'unit'         => 'px'
) );
?>

.fl-node-<?php echo $id; ?> .woocommerce #payment {
	margin-bottom: 0px;
}
.fl-node-<?php echo $id; ?> #customer_details h3,
.fl-node-<?php echo $id; ?> #customer_details h3 label {
	<?php WooPack_Helper::print_css( 'color', $settings->form_header_color ); ?>
}
.fl-node-<?php echo $id; ?> #ship-to-different-address-checkbox {
	margin-left: 0;
}
.fl-node-<?php echo $id; ?> #ship-to-different-address span {
	margin-left: 20px;
}
.fl-node-<?php echo $id; ?> .woocommerce form .form-row label {
	<?php WooPack_Helper::print_css( 'color', $settings->form_label_color ); ?>
}
.fl-node-<?php echo $id; ?> .woocommerce form .form-row.woocommerce-invalid label {
	<?php WooPack_Helper::print_css( 'color', $settings->form_label_invalid_color ); ?>
}
.fl-node-<?php echo $id; ?> .woocommerce #order_review {
	background: transparent;
	padding: 0;
}
.fl-node-<?php echo $id; ?> .woocommerce .cart_item:nth-child(even),
.fl-node-<?php echo $id; ?> .woocommerce table.shop_table tfoot tr:nth-child(even) {
	<?php WooPack_Helper::print_css( 'background-color', $settings->cart_item_even_color ); ?>
}
.fl-node-<?php echo $id; ?> .woocommerce .cart_item:nth-child(odd),
.fl-node-<?php echo $id; ?> .woocommerce table.shop_table tfoot tr:nth-child(odd) {
	<?php WooPack_Helper::print_css( 'background-color', $settings->cart_item_odd_color ); ?>
}

<?php
// Order summary table header padding top.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'table_header_padding',
	'selector'     => ".fl-node-$id .woopack-checkout .woocommerce table.shop_table thead th",
	'prop'         => 'padding-top',
	'unit'         => 'px'
) );

// Order summary table header padding bottom.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'table_header_padding',
	'selector'     => ".fl-node-$id .woopack-checkout .woocommerce table.shop_table thead th",
	'prop'         => 'padding-bottom',
	'unit'         => 'px'
) );

// Order summary table header padding left.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'table_header_h_padding',
	'selector'     => ".fl-node-$id .woopack-checkout .woocommerce table.shop_table thead th",
	'prop'         => 'padding-top',
	'unit'         => 'px'
) );

// Order summary table header padding right.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'table_header_h_padding',
	'selector'     => ".fl-node-$id .woopack-checkout .woocommerce table.shop_table thead th",
	'prop'         => 'padding-right',
	'unit'         => 'px'
) );

// Order summary table header separator.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'table_header_border_width',
	'selector'     => ".fl-node-$id .woocommerce table.shop_table thead th",
	'prop'         => 'border-bottom-width',
	'unit'         => 'px'
) );
?>
.fl-node-<?php echo $id; ?> .woocommerce table.shop_table thead th {
	<?php WooPack_Helper::print_css( 'border-bottom-style', 'solid', '', '' != $settings->table_header_border_width ); ?>
	<?php WooPack_Helper::print_css( 'border-color', $settings->table_header_border_color, '!important', '' != $settings->table_header_border_width ); ?>
	<?php WooPack_Helper::print_css( 'color', $settings->table_header_color ); ?>
}

<?php
// Order summary table body separator.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'cart_item_border_width',
	'selector'     => ".fl-node-$id .woocommerce table.shop_table tbody td",
	'prop'         => 'border-bottom-width',
	'unit'         => 'px'
) );
?>
.fl-node-<?php echo $id; ?> .woocommerce table.shop_table tbody td {
	<?php WooPack_Helper::print_css( 'border-bottom-style', 'solid', '', '' != $settings->cart_item_border_width ); ?>
	<?php WooPack_Helper::print_css( 'border-color', $settings->cart_item_border_color, ' !important' ); ?>
}

<?php
// Order summary table body & footer padding top.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'cart_item_padding',
	'selector'     => ".fl-node-$id .woopack-checkout .woocommerce table.shop_table td, .fl-node-$id .woopack-checkout .woocommerce table.shop_table tfoot th",
	'prop'         => 'padding-top',
	'unit'         => 'px'
) );

// Order summary table body & footer padding bottom.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'cart_item_padding',
	'selector'     => ".fl-node-$id .woopack-checkout .woocommerce table.shop_table td, .fl-node-$id .woopack-checkout .woocommerce table.shop_table tfoot th",
	'prop'         => 'padding-bottom',
	'unit'         => 'px'
) );

// Order summary table body & footer padding top.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'cart_item_h_padding',
	'selector'     => ".fl-node-$id .woopack-checkout .woocommerce table.shop_table td, .fl-node-$id .woopack-checkout .woocommerce table.shop_table tfoot th",
	'prop'         => 'padding-left',
	'unit'         => 'px'
) );

// Order summary table body & footer padding bottom.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'cart_item_h_padding',
	'selector'     => ".fl-node-$id .woopack-checkout .woocommerce table.shop_table td, .fl-node-$id .woopack-checkout .woocommerce table.shop_table tfoot th",
	'prop'         => 'padding-right',
	'unit'         => 'px'
) );
?>
.fl-node-<?php echo $id; ?> .woocommerce table.shop_table td,
.fl-node-<?php echo $id; ?> .woocommerce table.shop_table tfoot th {
	border: 0;
	<?php WooPack_Helper::print_css( 'color', $settings->table_color ); ?>
}
.fl-node-<?php echo $id; ?> .woocommerce table.shop_table tfoot td,
.fl-node-<?php echo $id; ?> .woocommerce table.shop_table tfoot th {
	<?php WooPack_Helper::print_css( 'color', $settings->table_footer_color ); ?>
}

<?php
// Order summary table footer total separator.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'cart_total_border_width',
	'selector'     => ".fl-node-$id .woocommerce table.shop_table tr.order-total th, .fl-node-$id .woocommerce table.shop_table tr.order-total td",
	'prop'         => 'border-top-width',
	'unit'         => 'px'
) );
?>
.fl-node-<?php echo $id; ?> .woocommerce table.shop_table tr.order-total th,
.fl-node-<?php echo $id; ?> .woocommerce table.shop_table tr.order-total td {
	<?php WooPack_Helper::print_css( 'border-top-style', 'solid', '', '' != $settings->cart_total_border_width ); ?>
	<?php WooPack_Helper::print_css( 'border-color', $settings->cart_total_border_color, ' !important' ); ?>
}
.fl-node-<?php echo $id; ?> .woocommerce table.shop_table tbody tr:first-child td {
	border-top-width: 0 !important;
}
.fl-node-<?php echo $id; ?> .woocommerce table.shop_table tfoot td {
	font-weight: 600;
}
.fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced .woocommerce table.shop_table td,
.fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced .woocommerce table.shop_table th {
	padding-left: 0;
	padding-right: 0;
}
/*
.fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced .woocommerce table.shop_table tfoot tr:last-of-type th,
.fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced .woocommerce table.shop_table tfoot tr:last-of-type td {
    padding-bottom: 0;
}
*/
.fl-node-<?php echo $id; ?> .woocommerce #order_review_heading {
	<?php WooPack_Helper::print_css( 'color', $settings->table_title_color ); ?>
}

<?php if ( isset( $settings->show_additional_info ) && 'no' === $settings->show_additional_info ) { ?>
.fl-node-<?php echo $id; ?> .woopack-checkout.style-enhanced #customer_details .woocommerce-additional-fields {
	display: none;
}
<?php } ?>

<?php
// *********************
// Coupon
// *********************
?>
.fl-node-<?php echo $id; ?> .woocommerce .woocommerce-form-coupon-toggle .woocommerce-info {
	<?php WooPack_Helper::print_css( 'color', $settings->coupon_color ); ?>
}
.fl-node-<?php echo $id; ?> .woocommerce .woocommerce-form-coupon-toggle .woocommerce-info a {
	<?php WooPack_Helper::print_css( 'color', $settings->coupon_link_color ); ?>
}

<?php
// *********************
// Inputs
// *********************
$input_selectors = ".fl-node-$id .woocommerce form .form-row input.input-text,
					.fl-node-$id .woocommerce form .form-row input.input-text:focus,
					.fl-node-$id .woocommerce form .form-row textarea,
					.fl-node-$id .woocommerce form .form-row textarea:focus,
					.fl-node-$id .woocommerce form .form-row select,
					.fl-node-$id .woocommerce .select2-container--default .select2-selection--single,
					.fl-node-$id .woocommerce .select2-container--default .select2-selection--single:focus,
					.fl-node-$id .woocommerce form .form-row.woocommerce-validated .select2-container--default .select2-selection--single,
					.fl-node-$id .woocommerce form .form-row.woocommerce-validated input.input-text";

if ( 'inset' ==  $settings->inpur_shadow_direction ) {
	$devices = array( '', '_medium', '_responsive' );
	foreach ( $devices as $device ) {
		$input 			= 'input_border_group' . $device;
		$border_h		= $settings->$input['shadow']['horizontal'];
		$border_v		= $settings->$input['shadow']['vertical'];
		$border_b		= $settings->$input['shadow']['blur'];
		$border_s		= $settings->$input['shadow']['spread'];
		$border_c		= $settings->$input['shadow']['color'];

		if ( is_array( $settings->$input ) && isset( $settings->$input['shadow'] ) ) {
			unset( $settings->$input['shadow'] );
			if ( '_medium' == $device ) { ?>
				@media only screen and (max-width: <?php echo $global_settings->medium_breakpoint; ?>px) {
			<?php } else if ( '_responsive' == $device ) { ?>
				@media only screen and (max-width: <?php echo $global_settings->responsive_breakpoint; ?>px) {
			<?php }
				echo $input_selectors; ?> {
					-webkit-box-shadow: inset <?php echo $border_h; ?>px <?php echo $border_v; ?>px <?php echo $border_b; ?>px <?php echo $border_s; ?>px <?php echo WooPack_Helper::get_color_value( $border_c ); ?>;
					-moz-box-shadow: inset <?php echo $border_h; ?>px <?php echo $border_v; ?>px <?php echo $border_b; ?>px <?php echo $border_s; ?>px <?php echo WooPack_Helper::get_color_value( $border_c ); ?>;
					-o-box-shadow: inset <?php echo $border_h; ?>px <?php echo $border_v; ?>px <?php echo $border_b; ?>px <?php echo $border_s; ?>px <?php echo WooPack_Helper::get_color_value( $border_c ); ?>;
					box-shadow: inset <?php echo $border_h; ?>px <?php echo $border_v; ?>px <?php echo $border_b; ?>px <?php echo $border_s; ?>px <?php echo WooPack_Helper::get_color_value( $border_c ); ?>;
				}
	<?php	if ( '_medium' == $device || '_responsive' ==  $device ) { ?>
				}
	<?php	}
		}
	}
	FLBuilderCSS::border_field_rule( array(
		'settings' 		=> $settings,
		'setting_name' 	=> 'input_border_group',
		'selector' 		=> $input_selectors,
	) );
} else {
	FLBuilderCSS::border_field_rule( array(
		'settings' 		=> $settings,
		'setting_name' 	=> 'input_border_group',
		'selector' 		=> $input_selectors,
	) );
}

// Input Padding
FLBuilderCSS::dimension_field_rule( array(
	'settings'		=> $settings,
	'setting_name' 	=> 'input_padding',
	'selector' 		=> $input_selectors,
	'unit'			=> 'px',
	'props'			=> array(
		'padding-top' 		=> 'input_padding_top',
		'padding-right' 	=> 'input_padding_right',
		'padding-bottom' 	=> 'input_padding_bottom',
		'padding-left' 		=> 'input_padding_left',
	),
) );

// Input margin bottom.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'input_margin_bottom',
	'selector'     => $input_selectors,
	'prop'         => 'margin-bottom',
	'unit'         => 'px'
) );

// Input Typography
FLBuilderCSS::typography_field_rule( array(
	'settings'		=> $settings,
	'setting_name' 	=> 'input_typography',
	'selector' 		=> $input_selectors,
) );
?>
<?php echo $input_selectors; ?> {
	<?php WooPack_Helper::print_css( 'color', $settings->input_text_color ); ?>
	<?php WooPack_Helper::print_css( 'background-color', $settings->input_bg_color ); ?>
	<?php WooPack_Helper::print_css( 'text-align-last', $settings->input_text_align ); ?>
}

.fl-node-<?php echo $id; ?> .woocommerce form .form-row.woocommerce-invalid input.input-text,
.fl-node-<?php echo $id; ?> .woocommerce form .form-row.woocommerce-invalid .select2-container--default .select2-selection--single {
	<?php WooPack_Helper::print_css( 'border-color', $settings->input_border_invalid ); ?>
}

.fl-node-<?php echo $id; ?> .woocommerce form .form-row input.input-text:focus,
.fl-node-<?php echo $id; ?> .woocommerce form .form-row textarea:focus {
	<?php WooPack_Helper::print_css( 'border-color', $settings->input_border_focus, ' !important' ); ?>
}

<?php
// Input height.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'input_height',
	'selector'     => ".fl-node-$id .woocommerce form .form-row input.input-text, .fl-node-$id .woocommerce form .form-row select, .fl-node-$id .woocommerce .select2-container--default .select2-selection--single",
	'prop'         => 'height',
	'unit'         => 'px'
) );

// Textarea height.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'textarea_height',
	'selector'     => ".fl-node-$id .woocommerce form .form-row textarea",
	'prop'         => 'height',
	'unit'         => 'px'
) );
?>

.fl-node-<?php echo $id; ?> .woocommerce form .form-row input.input-text::-webkit-input-placeholder,
.fl-node-<?php echo $id; ?> .woocommerce form .form-row textarea::-webkit-input-placeholder {
	<?php WooPack_Helper::print_css( 'color', $settings->placeholder_color ); ?>
}

<?php
// *********************
// Button
// *********************
?>

<?php
// Button width custom.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'button_width_custom',
	'selector'     => ".fl-node-$id .woocommerce #payment #place_order",
	'prop'         => 'width',
	'unit'         => '%',
	'enabled'      => 'custom' == $settings->button_width
) );
?>
.fl-node-<?php echo $id; ?> .woocommerce input.button,
.fl-node-<?php echo $id; ?> .woocommerce #place_order {
	<?php WooPack_Helper::print_css( 'background-color', $settings->button_bg_color ); ?>
	<?php WooPack_Helper::print_css( 'color', $settings->button_color ); ?>
	<?php WooPack_Helper::print_css( 'width', '100', '%', 'full_width' == $settings->button_width ); ?>
}
<?php
// Button margin top.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'button_margin_top',
	'selector'     => ".fl-node-$id .woocommerce #payment #place_order",
	'prop'         => 'margin-top',
	'unit'         => 'px'
) );

// Button margin bottom.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'button_margin_bottom',
	'selector'     => ".fl-node-$id .woocommerce #payment #place_order",
	'prop'         => 'margin-bottom',
	'unit'         => 'px'
) );

// Button Border
FLBuilderCSS::border_field_rule( array(
	'settings' 		=> $settings,
	'setting_name' 	=> 'button_border_group',
	'selector' 		=> ".fl-node-$id .woocommerce .woocommerce-checkout input.button,
						.fl-node-$id .woocommerce .woocommerce-checkout #place_order",
) );

// Border - Hover Settings
if ( ! empty( $settings->button_border_color_hover ) && is_array( $settings->button_border_group ) ) {
	$settings->button_border_group['color'] = $settings->button_border_color_hover;
}

FLBuilderCSS::border_field_rule( array(
	'settings' 		=> $settings,
	'setting_name' 	=> 'button_border_group',
	'selector' 		=> ".fl-node-$id .woocommerce .woocommerce-checkout input.button:hover,
						.fl-node-$id .woocommerce .woocommerce-checkout #place_order:hover",
) );

// Button Padding
FLBuilderCSS::dimension_field_rule( array(
	'settings'		=> $settings,
	'setting_name' 	=> 'button_padding',
	'selector' 		=> ".fl-node-$id .woocommerce .woocommerce-checkout input.button,
						.fl-node-$id .woocommerce .woocommerce-checkout #place_order",
	'unit'			=> 'px',
	'props'			=> array(
		'padding-top' 		=> 'button_padding_top',
		'padding-right' 	=> 'button_padding_right',
		'padding-bottom' 	=> 'button_padding_bottom',
		'padding-left' 		=> 'button_padding_left',
	),
) );
?>
.fl-node-<?php echo $id; ?> .woocommerce #payment #place_order {
	float: none;
}
.fl-node-<?php echo $id; ?> .woocommerce input.button:hover,
.fl-node-<?php echo $id; ?> .woocommerce #place_order:hover {
	<?php WooPack_Helper::print_css( 'background-color', $settings->button_bg_color_hover ); ?>
	<?php WooPack_Helper::print_css( 'color', $settings->button_color_hover ); ?>
	transition: all 0.2s ease-in-out;
}
.fl-node-<?php echo $id; ?> .woocommerce #payment .form-row.place-order,
.fl-node-<?php echo $id; ?> .woocommerce-page #payment .form-row.place-order {
	<?php WooPack_Helper::print_css( 'text-align', $settings->button_alignment ); ?>
}

<?php
// *********************
// Errors
// *********************
?>
.fl-node-<?php echo $id; ?> .woocommerce .woocommerce-error {
	<?php WooPack_Helper::print_css( 'background-color', $settings->error_bg_color ); ?>
	<?php WooPack_Helper::print_css( 'color', $settings->error_text_color ); ?>
	<?php WooPack_Helper::print_css( 'border-color', $settings->error_border_color ); ?>
}

<?php
// *********************
// Payment box
// *********************
?>
.fl-node-<?php echo $id; ?> .woocommerce #payment ul.payment_methods label {
	<?php WooPack_Helper::print_css( 'color', $settings->payment_method_label_color ); ?>
	font-weight: inherit;
}
<?php
// Payment box - message padding top.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'payment_method_box_top_bottom_padding',
	'selector'     => ".fl-node-$id .woocommerce #payment div.payment_box",
	'prop'         => 'padding-top',
	'unit'         => 'px'
) );

// Payment box - message padding bottom.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'payment_method_box_top_bottom_padding',
	'selector'     => ".fl-node-$id .woocommerce #payment div.payment_box",
	'prop'         => 'padding-bottom',
	'unit'         => 'px'
) );

// Payment box - message padding left.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'payment_method_box_right_left_padding',
	'selector'     => ".fl-node-$id .woocommerce #payment div.payment_box",
	'prop'         => 'padding-left',
	'unit'         => 'px'
) );

// Payment box - message padding right.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'payment_method_box_right_left_padding',
	'selector'     => ".fl-node-$id .woocommerce #payment div.payment_box",
	'prop'         => 'padding-right',
	'unit'         => 'px'
) );
?>
.fl-node-<?php echo $id; ?> .woocommerce #payment div.payment_box {
	<?php WooPack_Helper::print_css( 'background', $settings->payment_method_box_bg_color ); ?>
}
.fl-node-<?php echo $id; ?> .woocommerce #payment div.payment_box::before {
	<?php WooPack_Helper::print_css( 'border-color', $settings->payment_method_box_bg_color ); ?>
	border-right-color: transparent;
	border-left-color: transparent;
	border-top-color: transparent;
}
<?php
// Payment box - message font size.
FLBuilderCSS::responsive_rule( array(
	'settings'     => $settings,
	'setting_name' => 'payment_method_msg_font_size',
	'selector'     => ".fl-node-$id .woocommerce #payment div.payment_box p",
	'prop'         => 'font-size',
	'unit'         => 'px',
) );
?>
.fl-node-<?php echo $id; ?> .woocommerce #payment div.payment_box p {
	<?php WooPack_Helper::print_css( 'color', $settings->payment_method_box_text_color ); ?>
}

<?php
// **************
// Sticky right column.
// **************
?>
<?php
	FLBuilderCSS::responsive_rule( array(
		'settings'     => $settings,
		'setting_name' => 'sticky_top_offset',
		'selector'     => ".fl-node-$id .woopack-checkout-column-2 .woopack-checkout-column-sticky",
		'prop'         => 'top',
		'unit'         => 'px',
	) );
?>

<?php if ( '1column' == $settings->checkout_layout ) { ?>
	.fl-node-<?php echo $id; ?> .woocommerce .col2-set .col-1,
	.fl-node-<?php echo $id; ?> .woocommerce .col2-set .col-2 {
		width: 100%;
	}
<?php } ?>

<?php if ( '2column' == $settings->checkout_layout ) { ?>
	.fl-node-<?php echo $id; ?> .woocommerce .woopack-checkout-container {
		<?php if ( ! empty( $settings->first_column_width ) ) { ?>
		grid-template-columns: <?php echo $settings->first_column_width; ?>% auto;
		<?php } ?>
		<?php WooPack_Helper::print_css( 'grid-column-gap', $settings->space_bw_columns, $settings->space_bw_columns_unit ); ?>
	}
<?php } ?>

<?php
if ( '2column' == $settings->checkout_layout ) { 
	// First column width
	FLBuilderCSS::rule( array(
		'selector'     => ".fl-node-$id .woocommerce .woopack-checkout-container",
		'enabled'      => '' !== $settings->first_column_width,
		'props'        => array(
			'grid-template-columns' => "$settings->first_column_width%" . ( 100 != $settings->first_column_width ? ' auto' : '' )
		),
	) );
	// First column width - large
	FLBuilderCSS::rule( array(
		'media'    => 'large',
		'selector' => ".fl-node-$id .woocommerce .woopack-checkout-container",
		'enabled'  => '' !== $settings->first_column_width_large,
		'props'    => array(
			'grid-template-columns' => "$settings->first_column_width_large%" . ( 100 != $settings->first_column_width_large ? ' auto' : '' )
		),
	) );
	// First column width - medium
	FLBuilderCSS::rule( array(
		'media'    => 'medium',
		'selector' => ".fl-node-$id .woocommerce .woopack-checkout-container",
		'enabled'  => '' !== $settings->first_column_width_medium,
		'props'    => array(
			'grid-template-columns' => "$settings->first_column_width_medium%" . ( 100 != $settings->first_column_width_medium ? ' auto' : '' )
		),
	) );
	// First column width - responsive
	FLBuilderCSS::rule( array(
		'media'    => 'responsive',
		'selector' => ".fl-node-$id .woocommerce .woopack-checkout-container",
		'enabled'  => '' !== $settings->first_column_width_responsive,
		'props'    => array(
			'grid-template-columns' => "$settings->first_column_width_responsive%" . ( 100 != $settings->first_column_width_responsive ? ' auto' : '' )
		),
	) );

	FLBuilderCSS::responsive_rule( array(
		'settings'     => $settings,
		'setting_name' => 'space_bw_columns',
		'selector'     => ".fl-node-$id .woocommerce .woopack-checkout-container",
		'prop'         => 'grid-column-gap',
		'unit'         => $settings->space_bw_columns_unit,
		'enabled'      => '2column' == $settings->checkout_layout
	) );
}
?>

<?php if ( '2column' == $settings->checkout_layout && 'legacy' === $module->get_checkout_style() ) { // do not print old styles ?>
	.fl-node-<?php echo $id; ?> .woocommerce .checkout_coupon .form-row,
	.fl-node-<?php echo $id; ?> .woocommerce #coupon_code {
		margin-bottom: 0;
	}
	<?php
	if ( empty( $settings->first_column_width_responsive ) ) {
		$settings->first_column_width_responsive = 100;
	}

	// First column width
	FLBuilderCSS::responsive_rule( array(
		'settings'     => $settings,
		'setting_name' => 'first_column_width',
		'selector'     => ".fl-node-$id #customer_details",
		'prop'         => 'width',
		'unit'         => '%',
	) );

	$column_spacing = '' !== $settings->space_bw_columns ? $settings->space_bw_columns : 0;
	$column_spacing .= $settings->space_bw_columns_unit;
	$column_spacing_lg = '' !== $settings->space_bw_columns_large ? $settings->space_bw_columns_large : $column_spacing;
	$column_spacing_lg .= $settings->space_bw_columns_large_unit;
	$column_spacing_md = '' !== $settings->space_bw_columns_medium ? $settings->space_bw_columns_medium : $column_spacing_lg;
	$column_spacing_md .= $settings->space_bw_columns_medium_unit;
	$column_spacing_sm = '' !== $settings->space_bw_columns_responsive ? $settings->space_bw_columns_responsive : $column_spacing_md;
	$column_spacing_sm .= $settings->space_bw_columns_responsive_unit;

	// Second column width
	FLBuilderCSS::rule( array(
		'selector'     => ".fl-node-$id #order_review",
		'props'        => array(
			'width' => "calc(100% - ($settings->first_column_width% + $column_spacing))"
		),
	) );
	// Second column width - large
	FLBuilderCSS::rule( array(
		'media'    => 'large',
		'selector' => ".fl-node-$id #order_review",
		'enabled'  => '' !== $settings->first_column_width_large,
		'props'    => array(
			'width' => "calc(100% - ($settings->first_column_width_large% + $column_spacing_lg))"
		),
	) );
	// Second column width - medium
	FLBuilderCSS::rule( array(
		'media'    => 'medium',
		'selector' => ".fl-node-$id #order_review",
		'enabled'  => '' !== $settings->first_column_width_medium,
		'props'    => array(
			'width' => "calc(100% - ($settings->first_column_width_medium% + $column_spacing_md))"
		),
	) );

	// Second column width - responsive
	FLBuilderCSS::rule( array(
		'media'    => 'responsive',
		'selector' => ".fl-node-$id #order_review",
		'enabled'  => '' !== $settings->first_column_width_responsive,
		'props'    => array(
			'width' => "$settings->first_column_width_responsive%"
		),
	) );

	// Space between columns
	FLBuilderCSS::responsive_rule( array(
		'settings'     => $settings,
		'setting_name' => 'space_bw_columns',
		'selector'     => ".fl-node-$id #customer_details",
		'prop'         => 'margin-right',
		'unit'         => '%',
	) );
	?>
	.fl-node-<?php echo $id; ?> #customer_details {
		float: left;
	}
	.fl-node-<?php echo $id; ?> #customer_details .col-1,
	.fl-node-<?php echo $id; ?> #customer_details .col-2 {
		width: 100%;
	}
	.fl-node-<?php echo $id; ?> .woocommerce #order_review_heading {
		float: left;
		margin-top: 0;
		margin-bottom: 10px;
		display: none;
	}
	.fl-node-<?php echo $id; ?> #order_review {
		float: left;
	}
<?php } // End if().?>
