<?php
$is_builder_active = FLBuilderModel::is_builder_active();
$checkout_style  = $module->get_checkout_style();
$wrapper_classes = array(
	'woopack-checkout',
	"layout-$settings->checkout_layout",
	"style-$checkout_style"
);
?>

<?php do_action( 'woopack_before_checkout_wrap', $settings ); ?>

<div class="<?php echo implode( ' ', $wrapper_classes ); ?>">
	<?php
	do_action( 'woopack_before_checkout_content', $settings );

	// Simulate a logged out user so that all WooCommerce sections will render in the Editor
	if ( $is_builder_active ) {
		$_current_user = wp_get_current_user()->ID;
		wp_set_current_user( 0 );
	}

	if ( 'enhanced' === $module->get_checkout_style() ) {
		$module->add_render_hooks();
	}

    echo do_shortcode( '[woocommerce_checkout]' );
	
	if ( 'enhanced' === $module->get_checkout_style() ) {
		$module->remove_render_hooks();
	}

	// Return to existing logged-in user after widget is rendered.
	if ( $is_builder_active ) {
		wp_set_current_user( $_current_user );
	}
	
	do_action( 'woopack_after_checkout_content', $settings );
	?>
</div>

<?php do_action( 'woopack_after_checkout_wrap', $settings ); ?>