<?php
/**
 * Loop Product Rating.
 *
 * This template can be overridden by copying it to yourtheme/woopack/templates/loop-product-rating.php.
 *
 * HOWEVER, on occasion WooPack will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @package WooPack/Templates
 * @version 1.5.4
 */
?>

<?php
if ( ! is_object( $product ) ) {
	if ( FLBuilderModel::is_builder_active() ) {
		echo '<div class="fl-builder-module-placeholder-message">woopack_product_rating_reviews</div>';
	}
	return;
}
$rating_count = $product->get_rating_count();
$review_count = $product->get_review_count();
$wrapper_attr = 'data-rating-count="' . $rating_count . '"';
$wrapper_attr = ! apply_filters( 'woopack_product_show_empty_rating', true, $product, $settings ) ? ' style="display: none;"' : '';
?>
<div class="woopack-product-rating" <?php echo $wrapper_attr; ?>>
<?php
if ( 'yes' === $settings->product_rating ) {
	echo wc_get_rating_html( $product->get_average_rating() );
}

if ( comments_open() && isset( $settings->product_rating_count ) && 'yes' === $settings->product_rating_count ) {
	?>
	<a href="<?php echo get_permalink( $product->get_id() ); ?>#reviews" class="woocommerce-rating-count" rel="nofollow">
	<?php
	if ( isset( $settings->product_rating_text ) && ! empty( $settings->product_rating_text ) ) {
		$rating_text = $settings->product_rating_text;
		if ( isset( $settings->product_rating_text_plural ) && ! empty( $settings->product_rating_text_plural ) ) {
			if ( $review_count > 1 ) {
				$rating_text = $settings->product_rating_text_plural;
			}
		}
	?>
		<?php if ( ! empty( trim( $rating_text ) ) ) { ?>
		(<span class="count"><?php echo $review_count; ?></span> <?php echo $rating_text; ?>)
		<?php } else { ?>
		(<span class="count"><?php echo $review_count; ?></span>)
		<?php } ?>
	<?php } else { ?>
		<?php // translators: %s is for Rating. ?>
		(<?php printf( _n( '%s customer review', '%s customer reviews', $review_count, 'woocommerce' ), '<span class="count">' . esc_html( $review_count ) . '</span>' ); ?>)
	<?php } ?>
	</a>
	<?php
}
?>
</div>