<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* PrintOrientation File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Microsoft\Graph\Model;

use Microsoft\Graph\Core\Enum;

/**
* PrintOrientation class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class PrintOrientation extends Enum
{
    /**
    * The Enum PrintOrientation
    */
    const PORTRAIT = "portrait";
    const LANDSCAPE = "landscape";
    const REVERSE_LANDSCAPE = "reverseLandscape";
    const REVERSE_PORTRAIT = "reversePortrait";
    const UNKNOWN_FUTURE_VALUE = "unknownFutureValue";
}
