/**
 * Folder tree for WP File Download
 */
var wpfdPrivateFolders;
(function ($) {
    wpfdPrivateFolders = {
        categories: [], // categories

        /**
         * Retrieve the Jquery tree view element
         * of the current frame
         * @return jQuery
         */
        getTreeElement: function () {
            return $('#wpfd_local_categories');
        },

        /**
         * Initialize module related things
         */
        initModule: function () {
            // Import categories from wpfd main module
            wpfdPrivateFolders.importCategories();

            // Render the tree view
            wpfdPrivateFolders.loadTreeView();
        },

        getchecked: function (folder_id, button) {
            $('#wpfd_local_categories .media_checkbox').not(button).prop('checked', false);
            if ($(button).is(':checked')) {
                wpfdPrivateFolders.renderCatID(folder_id);
            } else {
                wpfdPrivateFolders.renderCatID(0);
            }
        },

        /**
         * Import categories from wpfd main module
         */
        importCategories: function () {
            var folders_ordered = wpfd_var.wpfd_categories;
            var tree_categories = [];

            if (folders_ordered) {
                folders_ordered.forEach(function (ele, i) {
                    // Convert cloud ids
                    if (ele.cloudType !== false && typeof (ele.wp_term_id) !== 'undefined' && typeof (ele.wp_parent) !== 'undefined') {
                        folders_ordered[i].term_id = ele.wp_term_id;
                        folders_ordered[i].parent = ele.wp_parent;
                    }

                    // Correct cloud parent id
                    if (ele.cloudType !== false && ele.parent === false) {
                        folders_ordered[i].parent = 0;
                    }

                    if (ele.cloudType === false) {
                        tree_categories.push(folders_ordered[i]);
                    }
                });
            }

            // Reorder array based on children
            var folders_ordered_deep = [];
            var processed_ids = [];
            var loadChildren = function (id) {
                if (processed_ids.indexOf(id) < 0) {
                    processed_ids.push(id);
                    for (var ij = 0; ij < tree_categories.length; ij++) {
                        if (tree_categories[ij].parent === id) {
                            folders_ordered_deep.push(tree_categories[ij]);
                            loadChildren(tree_categories[ij].term_id);
                        }
                    }
                }
            };
            loadChildren(0);
            // Finally save it to the global var
            wpfdPrivateFolders.categories = folders_ordered_deep;
        },

        /**
         * Render tree view inside content
         */
        loadTreeView: function () {
            wpfdPrivateFolders.getTreeElement().html(wpfdPrivateFolders.getRendering());
        },

        /**
         * Get the html resulting tree view
         * @return {string}
         */
        getRendering: function () {
            var ij = 0;
            var content = '<p>' + wpfd_admin.label_sync_wpfd + '</p>'; // Final tree view content
            var selected_id = $('#wpfd_selected_category_id').val();

            /**
             * Recursively print list of folders
             * @return {boolean}
             */
            var generateList = function generateList() {
                content += '<ul class="jaofiletree">';

                while (ij < wpfdPrivateFolders.categories.length) {
                    var className = 'closed';
                    if (wpfdPrivateFolders.categories[ij + 1] && wpfdPrivateFolders.categories[ij + 1].level > wpfdPrivateFolders.categories[ij].level) {
                        className += ' directory-parent';
                    } else {
                        className += ' directory-no-arrow';
                    }
                    // Open li tag
                    content += '<li class="' + className + ' directory" data-id="' + wpfdPrivateFolders.categories[ij].term_id + '" >';

                    var a_tag = '<a data-id="' + wpfdPrivateFolders.categories[ij].term_id + '">';

                    if (wpfdPrivateFolders.categories[ij + 1] && wpfdPrivateFolders.categories[ij + 1].level > wpfdPrivateFolders.categories[ij].level) { // The next element is a sub folder
                        content += '<a class="wpfd-folder-toggle" onclick="wpfdPrivateFolders.toggle(' + wpfdPrivateFolders.categories[ij].term_id + ')"><i class="material-icons wpfd-arrow">keyboard_arrow_down</i></a>';
                        content += a_tag;
                    } else {
                        content += a_tag;
                    }

                    var checked = (parseInt(selected_id) === parseInt(wpfdPrivateFolders.categories[ij].term_id)) ? ' checked' : '';

                    content += '<input type="checkbox" class="media_checkbox" onclick="wpfdPrivateFolders.getchecked(' + wpfdPrivateFolders.categories[ij].term_id + ',  this)" data-id="' + wpfdPrivateFolders.categories[ij].term_id + '" ' + checked + ' />';

                    // Add current category name
                    content += '<span class="wpfd-folder-toggle" onclick="wpfdPrivateFolders.changeFolder(' + wpfdPrivateFolders.categories[ij].term_id + ');wpfdPrivateFolders.toggle(' + wpfdPrivateFolders.categories[ij].term_id + ')">' + wpfdPrivateFolders.categories[ij].name + '</span>';
                    content += '</a>';
                    // This is the end of the array
                    if (wpfdPrivateFolders.categories[ij + 1] === undefined) {
                        // var's close all opened tags
                        for (var ik = wpfdPrivateFolders.categories[ij].level; ik >= 0; ik--) {
                            content += '</li>';
                            content += '</ul>';
                        }

                        // We are at the end don't continue to process array
                        return false;
                    }

                    if (wpfdPrivateFolders.categories[ij + 1].level > wpfdPrivateFolders.categories[ij].level) { // The next element is a sub folder
                        // Recursively list it
                        ij++;
                        if (generateList() === false) {
                            // We have reached the end, var's recursively end
                            return false;
                        }
                    } else if (wpfdPrivateFolders.categories[ij + 1].level < wpfdPrivateFolders.categories[ij].level) { // The next element don't have the same parent
                        // var's close opened tags
                        for (var ik1 = wpfdPrivateFolders.categories[ij].level; ik1 > wpfdPrivateFolders.categories[ij + 1].level; ik1--) {
                            content += '</li>';
                            content += '</ul>';
                        }

                        // We're not at the end of the array var's continue processing it
                        return true;
                    }

                    // Close the current element
                    content += '</li>';
                    ij++;
                }
            };

            // Start generation
            generateList();
            return content;
        },

        /**
         * Change the selected folder in tree view
         * @param folder_id
         */
        changeFolder: function (folder_id) {
            // Remove previous selection
            wpfdPrivateFolders.getTreeElement().find('li').removeClass('selected');

            // Select the folder
            wpfdPrivateFolders.getTreeElement().find('li[data-id="' + folder_id + '"]').addClass('selected').// Open parent folders
                parents('.wpfd-folder-tree li.closed').removeClass('closed');
        },

        /**
         * Change the selected folder in tree view
         * @param folder_id
         */
        renderCatID: function (folder_id) {
            if (parseInt(folder_id) == 0) {
                $('#wpfd_selected_category_id').val('');
                $('.dir_name_private_category').attr('data-id_category', 0);
            } else {
                var categories = wpfd_var.wpfd_email_categories_order;
                var category = categories[folder_id];
                var breadcrumb_content = '';

                // Ascend until there is no more parent
                while (parseInt(category.parent) !== 0) {
                    // Generate breadcrumb element
                    breadcrumb_content = '/' + categories[category.term_id].name + breadcrumb_content;

                    // Get the parent
                    category = categories[categories[category.term_id].parent];
                }

                if (parseInt(category.term_id) !== 0) {
                    breadcrumb_content = categories[category.term_id].name + breadcrumb_content;
                }

                breadcrumb_content = '/' + breadcrumb_content;
                $('.dir_name_private_category').val(breadcrumb_content);
                $('.dir_name_private_category').attr('data-id_category', folder_id);
                $('#wpfd_selected_category_id').val(folder_id);

            }
        },

        /**
         * Toggle the open / closed state of a folder
         * @param folder_id
         */
        toggle: function (folder_id) {
            // Check is folder has closed class
            if (wpfdPrivateFolders.getTreeElement().find('li[data-id="' + folder_id + '"]').hasClass('closed')) {
                // Open the folder
                wpfdPrivateFolders.openFolder(folder_id);
            } else {
                // Close the folder
                wpfdPrivateFolders.closeFolder(folder_id);
                // close all sub folder
                $('li[data-id="' + folder_id + '"]').find('li').addClass('closed');
            }
        },


        /**
         * Open a folder to show children
         */
        openFolder: function (folder_id) {
            wpfdPrivateFolders.getTreeElement().find('li[data-id="' + folder_id + '"]').removeClass('closed');
        },

        /**
         * Close a folder and hide children
         */
        closeFolder: function (folder_id) {
            wpfdPrivateFolders.getTreeElement().find('li[data-id="' + folder_id + '"]').addClass('closed');
        }
    };

    // var's initialize WPfd folder tree features
    $(document).ready(function () {
        wpfdPrivateFolders.initModule();
    });
})(jQuery);