(function ($) {
    $(document).ready(function ($) {
        $('.sidebar-menu-item.has-submenu > a').on('click', function (e) {
            e.preventDefault();

            const item = $(this).closest('.sidebar-menu-item');

            if (item.hasClass('expanded')) {
                item.removeClass('expanded');
            } else {
                $('.sidebar-menu-item.has-submenu').removeClass('expanded');
                item.addClass('expanded');

                const firstSubLink = item.find('.sidebar-sub-item:first-child .link-tab');
                if (firstSubLink.length) {
                    const href = firstSubLink.attr('data-href');
                    if (href && href.startsWith('#')) {
                        firstSubLink.trigger('click');
                        location.hash = href;
                    }
                }
            }
        });

        // Click on main item WITHOUT submenu
        $('.sidebar-menu-item:not(.has-submenu) > a').on('click', function (e) {
            $('.sidebar-menu-item.has-submenu').removeClass('expanded');
            $('.sidebar-menu-item').removeClass('active');
            $('.sidebar-menu-item .link-tab').removeClass('active');
            $('.sidebar-sub-item .link-tab').removeClass('active');
            $(this).closest('.sidebar-menu-item').addClass('active');

            wpfdShowContentByHash($(this).attr('href'));
        });

        // Click on sub item
        $('.sidebar-sub-item > .link-tab').on('click', function (e) {
            $('.sidebar-sub-item, .sidebar-menu-item').removeClass('active');
            $('.sidebar-sub-item .link-tab, .sidebar-menu-item .link-tab').removeClass('active');
            const subItem = $(this).closest('.sidebar-sub-item');
            const parentItem = $(this).closest('.sidebar-menu-item');

            $(this).addClass('active');
            subItem.addClass('active');
            parentItem.addClass('active');

            wpfdShowContentByHash($(this).attr('data-href'));
        });

        wpfdActivateMenuByHash();
        wpfdInitSidebarSearch();
        wpfdInitSidebarToggle();
        wpfdInitCollapsedSidebarHover();
        wpfdInitCloudConnectorTabs();
    });

    function wpfdShowContentByHash(hash) {
        if (!hash) return;

        $('.wpfd-settings-content .ju-content-wrapper, .wpfd-settings-content .tab-content').hide();

        const target = $('.wpfd-settings-content').find(hash);
        if (target.length) {
            target.show();

            target.closest('.ju-content-wrapper').show();
            target.parent('.ju-content-wrapper').show();
        }
    }

    function wpfdActivateMenuByHash() {
        const hash = window.location.hash;
        if (!hash) return;

        const subLink = $(`.sidebar-sub-item a[href="${hash}"]`);
        if (subLink.length) {
            const subItem = subLink.closest('.sidebar-sub-item');
            const parentItem = subLink.closest('.sidebar-menu-item');

            $('.sidebar-menu-item, .sidebar-sub-item').removeClass('active expanded');

            subItem.addClass('active');
            parentItem.addClass('active expanded');

            wpfdShowContentByHash(hash);
            return;
        }

        const mainLink = $(`.sidebar-menu-item:not(.has-submenu) > a[href="${hash}"]`);
        if (mainLink.length) {
            $('.sidebar-menu-item, .sidebar-sub-item').removeClass('active expanded');
            mainLink.closest('.sidebar-menu-item').addClass('active');

            wpfdShowContentByHash(hash);
        }
    }

    function wpfdInitSidebarSearch() {
        var wrapper = $('.wpfd-settings-wrapper');
        var sidebar = $('.wpfd-settings-sidebar');
        var searchContainer = $('.wpfd-settings-search');
        var searchIcon = searchContainer.find('.wpfd-search-icon');

        searchIcon.on('click', function (e) {
            e.stopPropagation();
            if (wrapper.hasClass('wpfd-sidebar-collapsed')) {
                searchContainer.toggleClass('search-active');
                if (searchContainer.hasClass('search-active')) {
                    var iconOffset = searchIcon.offset();
                    var sidebarOffset = sidebar.offset();
                    var iconHeight = searchIcon.outerHeight();

                    $('.wpfd-search-input-wrapper').css({
                        top: iconOffset.top - iconHeight + 'px',
                        left: sidebarOffset.left + sidebar.outerWidth() + 3 + 'px'
                    })
                }
            }
        });

        $(document).on('click', function (e) {
            if (!searchContainer.is(e.target) && searchContainer.has(e.target).length === 0) {
                searchContainer.removeClass('search-active');
            }
        });

        $('.wpfd-settings-search input').on('input', function () {
            const keyword = $(this).val().toLowerCase().trim();
            $('.sidebar-menu-item').each(function () {
                const menuItem = $(this);
                const titleText = menuItem.find('> a > div > span:last-child').text().toLowerCase();

                if (menuItem.hasClass('has-submenu')) {
                    let hasVisibleSub = false;
                    menuItem.find('.sidebar-sub-item').each(function () {
                        const subItem = $(this);
                        const subText = subItem.text().toLowerCase();
                        if (subText.includes(keyword)) {
                            subItem.show();
                            hasVisibleSub = true;
                        } else {
                            subItem.hide();
                        }
                    });
                    if (titleText.includes(keyword) || hasVisibleSub) {
                        menuItem.show();
                    } else {
                        menuItem.hide();
                    }
                } else {
                    if (titleText.includes(keyword)) {
                        menuItem.show();
                    } else {
                        menuItem.hide();
                    }
                }
            });
        });
    }

    function wpfdInitSidebarToggle() {
        const wrapper = $('.wpfd-settings-wrapper');
        const collapseBtn = $('.wpfd-sidebar-collapse-btn');
        const expandBtn = $('.wpfd-sidebar-expand-btn');

        collapseBtn.on('click', function () {
            wrapper.addClass('wpfd-sidebar-collapsed');
        });

        expandBtn.on('click', function () {
            wrapper.removeClass('wpfd-sidebar-collapsed');
            wrapper.removeClass('wpfd-sidebar-silent');
            resetSidebarSubmenus();
        });
    }

    function wpfdInitCollapsedSidebarHover() {
        $('.wpfd-settings-sidebar-menu-items .sidebar-menu-item.has-submenu').hover(function () {
            var wrapper = $('.wpfd-settings-wrapper');
            if (!wrapper.hasClass('wpfd-sidebar-collapsed')) return;

            var item = $(this);
            var itemWidth = item.outerWidth();
            var itemHeight = item.outerHeight();
            var itemOffset = item.offset();
            var itemRect = item[0].getBoundingClientRect();
            var submenu = item.find('.sidebar-sub-wrapper');
            var submenuContent = item.find('.sidebar-sub-menu');
            // $('.wpfd-settings-wrapper.wpfd-sidebar-collapsed').removeClass('wpfd-sidebar-silent').addClass('wpfd-sidebar-silent');

            submenu.css({display: 'block', visibility: 'hidden'});
            submenuContent.css({display: 'flex', visibility: 'hidden'});

            var submenuHeight = submenu.outerHeight();
            var windowHeight = window.innerHeight;

            submenu.css({display: 'none', visibility: '', top: '', bottom: ''});
            submenuContent.css({display: 'none', visibility: ''});

            var cssProps = {
                display: 'block',
                left: itemOffset.left + itemWidth + 'px'
            };

            if (itemRect.bottom + submenuHeight > windowHeight) {
                var distanceFromBottom = windowHeight - itemRect.bottom;
                cssProps.bottom = distanceFromBottom + 'px';
            } else {
                cssProps.top = item.position().top + itemHeight - 12 + 'px';
            }

            submenu.css(cssProps);
            submenuContent.css('display', 'flex');
        }, function () {
            var wrapper = $('.wpfd-settings-wrapper');
            if (!wrapper.hasClass('wpfd-sidebar-collapsed')) return;

            var submenu = $(this).find('.sidebar-sub-wrapper');
            var submenuContent = $(this).find('.sidebar-sub-menu');
            $('.wpfd-settings-wrapper.wpfd-sidebar-collapsed').removeClass('wpfd-sidebar-silent');

            submenu.hide().css({top: '', bottom: ''});
            submenuContent.hide();
        });
    }

    function resetSidebarSubmenus() {
        $('.sidebar-sub-wrapper').hide().css({top: '', bottom: '', left: '', display: ''});
        $('.sidebar-sub-menu').hide().css({visibility: '', display: ''});
    }

    function wpfdInitCloudConnectorTabs() {
        $('.wpfd-cloud-providers .provider-card').on('click', function () {
            var target = $(this).data('tab');

            $('.wpfd-cloud-providers .provider-card').removeClass('active');
            $(this).addClass('active');

            $('#cloud .sub-tab-content').hide();
            $('#' + target).show();
            $('#cloud_connector .wpfd-divider').show();
        });
    }

})(jQuery);