(function ($) {
  $(document).ready(function ($) {
    var wpfd_wizard = {
      init: function () {
        $(document).on('change', '.ju-switch-button .switch input[type="checkbox"]', this.switch);
        $(document).on('click', '.wizard-theme-config .wpfd-theme .overlay', this.theme_select);
      },
      theme_select: function (e) {
        var $this = $(e.target);
        // Clear selected
        $('.wizard-theme-config .wpfd-theme').removeClass('checked');
        $('.wizard-theme-config input').prop('checked', false);

        // Select current
        $this.parent().addClass('checked');
        $this.parent().find('input').prop('checked', true);
      },
      switch: function (e) {
        var $this = $(e.target);
        var ref = $this.attr('name').replace('ref_', '');
        $('input[name="' + ref + '"]').val($this.prop('checked') ? 1 : 0);
      },
      minicolors: function () {
        $('.minicolors:not(.bgcolor, .bgdownloadlink)').minicolors({position: 'bottom left'});

        // Transparent color option
        $('.minicolors.bgcolor, .minicolors.bgdownloadlink').minicolors({
          position: 'bottom left',
          opacity: true,
          value: '#fff',
          change: function (hex, opacity) {
            var opacitySaved = $(this).data('opacity').toString();
            if (opacity === opacitySaved && opacitySaved !== '1.00') {
              opacitySaved = '1.00';
              opacity = '1.00';
              $(this).attr('data-opacity', '1.00').trigger('change');
              $(this).siblings('.minicolors-swatch').find('.minicolors-swatch-color').css({'opacity': '1'});
              $(this).siblings('.minicolors-panel').find('.minicolors-opacity-slider .minicolors-picker').css({'top': '0'});
            }

            if ((!hex || hex === '') && $(this).hasClass('bgcolor')) {
              color = 'rgba(255, 255, 255, 0)';
            } else {
              color = $(this).minicolors('rgbaString');
            }
          },
          hide : function() {
            $(this).val(color);
          },
          show : function() {}
        });
      },
    };

    // Wizard Init
    wpfd_wizard.init();
    wpfd_wizard.minicolors();

    var eventMethod = window.addEventListener ? "addEventListener" : "attachEvent";
    var eventer = window[eventMethod];
    var messageEvent = eventMethod === "attachEvent" ? "onmessage" : "message";
    console.log(eventer);
    console.log(messageEvent);
    // Listen to message from child window
    eventer(messageEvent, function (e) {
      console.log("run here");
      console.log(e.data);
      var res = e.data;
      if (typeof res !== "undefined" && typeof res.type !== "undefined" && res.type === "joomunited_connect") {
        $.ajax({
          url: ajaxurl,
          type: 'POST',
          data: {
            'action': 'wpfdju_update_license',
            'token': res.token,
            'ju_updater_nonce': updaterV2params.ju_updater_nonce
          },
          success: function (res) {
            console.log('success');
            console.log(res);
            location.assign(wpfdNextStep);
            //    location.reload();
          }
        });
      }
    }, false);
  });
})(jQuery);