<?php
/**
 * WP File Download
 *
 * @package WP File Download
 * @author  Joomunited
 * @version 1.0
 */

namespace Joomunited\WP_File_Download\Admin\Fields;

use Joomunited\WPFramework\v1_0_6\Field;
use Joomunited\WPFramework\v1_0_6\Factory;
use Joomunited\WPFramework\v1_0_6\Application;

defined('ABSPATH') || die();

/**
 * Class Social
 */
class Social extends Field
{

    /**
     * Display config social field
     *
     * @param array $field Fields
     * @param array $data  Data
     *
     * @return string
     */
    public function getfield($field, $data)
    {
        $attributes = $field['@attributes'];
        $className = '';
        if (isset($attributes['name'])) {
            $className = ' wpfd-field-'.$attributes['name'];
        }
        $html       = '';
        // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- Possibility to translate by our deployment script
        $tooltip    = isset($attributes['tooltip']) ? __($attributes['tooltip'], 'wpfd') : '';
        if (defined('WPFDA_VERSION')) {
            $html .= '<div class="control-group wpfd-form-field'.$className.'">';
            if (!empty($attributes['label']) && $attributes['label'] !== '' &&
                !empty($attributes['name']) && $attributes['name'] !== '') {
                $html .= '<label title="' . $tooltip . '" class="control-label" for="' . $attributes['name'] . '">';
                // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- Dynamic translate
                $html .= esc_html__($attributes['label'], 'wpfd') . '</label>';
            }
            $html .= '<div class="controls">';
            $html .= '<select';
            if (!empty($attributes)) {
                foreach ($attributes as $attribute => $value) {
                    if (in_array($attribute, array('id', 'class', 'onchange', 'name')) && isset($value)) {
                        $html .= ' ' . $attribute . '="' . $value . '"';
                    }
                }
            }
            $html       .= ' >';
            $cleanfield = $field;
            unset($cleanfield['@attributes']);
            if (!empty($cleanfield[0])) {
                $attribute_array = array('type', 'id', 'class', 'name', 'onchange', 'value');
                foreach ($cleanfield[0] as $child) {
                    if (!empty($child['option']['@attributes'])) {
                        $html .= '<option ';
                        foreach ($child['option']['@attributes'] as $childAttribute => $childValue) {
                            if (in_array($childAttribute, $attribute_array) && isset($childValue)) {
                                $html .= ' ' . $childAttribute . '="' . $childValue . '"';
                                if ($childAttribute === 'value' && isset($attributes['value']) &&
                                    $attributes['value'] === $childValue) {
                                    $html .= ' selected="selected"';
                                }
                            }
                        }
                        $html .= '>';
                        // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- Dynamic translate
                        $html .= esc_html__($child['option'][0], 'wpfd');
                        $html .= '</option>';
                    }
                }
            }
            $html .= '</select>';
            if (!empty($attributes['help']) && $attributes['help'] !== '') {
                // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- Possibility to translate by our deployment script
                $html .= '<p class="help-block">' . __($attributes['help'], 'wpfd') . '</p>';
            }
            $html .= '</div></div>';
        }

        return $html;
    }
}
