<?php
/**
 * WP File Download
 *
 * @package WP File Download
 * @author  Joomunited
 * @version 1.0
 */

namespace Joomunited\WP_File_Download\Admin\Fields;

use Joomunited\WPFramework\v1_0_6\Field;
use Joomunited\WPFramework\v1_0_6\Application;
use Joomunited\WPFramework\v1_0_6\Model;

defined('ABSPATH') || die();

/**
 * Class Clone Themes
 */
class Clonethemes extends Field
{
    /**
     * Display theme config
     *
     * @param array $field Fields
     * @param array $data  Data
     *
     * @return string
     */
    public function getfield($field, $data)
    {
        Application::getInstance('Wpfd');
        $clonedThemes = array();

        // Additional themes path on wp-content
        $clonedThemeDirectory = WP_CONTENT_DIR . DIRECTORY_SEPARATOR . wpfd_get_content_dir() . DIRECTORY_SEPARATOR . 'themes' . DIRECTORY_SEPARATOR;
        if (file_exists($clonedThemeDirectory)) {
            foreach (glob($clonedThemeDirectory . 'wpfd-*', GLOB_ONLYDIR) as $rep) {
                $clonedThemes[] = str_replace('wpfd-', '', basename($rep));
            }
        }

        if (!empty($clonedThemes) && is_countable($clonedThemes)) {
            $rootThemes = array('default', 'ggd', 'preview', 'table', 'tree');
            $rootThemeTypes = get_option('wpfd_root_theme_types', array());
            $attributes = $field['@attributes'];
            $counter = count($clonedThemes);
            $html = '<div class="ju-settings-option ju-settings-clone-theme-list-option">';
            $html .= '<div class="wpfd_row_full">';
            $html .= '<div class="clone-theme-contents">';

            // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- Possibility to translate by our deployment script
            $tooltip = isset($attributes['tooltip']) ? __($attributes['tooltip'], 'wpfd') : '';

            if (empty($attributes['hidden']) || (!empty($attributes['hidden']) && $attributes['hidden'] !== 'true')) {
                if (!empty($attributes['label']) && $attributes['label'] !== '' &&
                    !empty($attributes['name']) && $attributes['name'] !== '') {
                    $html .= '<label title="' . $tooltip . '" class="ju-setting-label" for="' . $attributes['name'] . '">';
                    // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- Dynamic translate
                    $html .= esc_html__($attributes['label'], 'wpfd') . '</label>';
                }
            }

            $html .= '<ul id="cl_list" class="cl_list">';

            foreach ($clonedThemes as $theme) {
                $rootTheme = 'none';

                if (in_array($theme, $rootThemes)) {
                    $rootTheme = $theme;
                } elseif (!empty($rootThemeTypes)) {
                    if (array_key_exists($theme, $rootThemeTypes)) {
                        $rootTheme = $rootThemeTypes[$theme];
                    }
                } else {
                    $rootTheme = 'none';
                }

                $themeName = ucfirst(str_replace('_', ' ', $theme));
                $checkbox = '<input class="media_checkbox cl_theme_checkbox" id="cb-select-'. esc_html($theme) .'" type="checkbox" data-val="'. esc_html($theme) .'" value="'. esc_html($theme) .'" />';
                $html .= '<li class="cl_theme" value="' . $theme . '" data-root_theme_type="'. $rootTheme .'">'. $checkbox .'<span>' . $themeName . '</span></li>';
            }

            $html .= '</ul>';

            if (!empty($attributes['help']) && $attributes['help'] !== '') {
                // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- Possibility to translate by our deployment script
                $html .= '<p class="help-block">' . __($attributes['help'], 'wpfd') . '</p>';
            }

            $html .= '</div>';
            $html .= '<div id="cl_buttons" class="cl_buttons" style="display: none;">';
            $html .= '<button type="button" id="wpfd_cl_theme_delete" class="ju-button orange-outline-button ju-button-inline wpfd_cl_theme_delete">';
            $html .= esc_html__('Delete', 'wpfd');
            $html .= '</button>';
            $html .= '</div>';
            $html .= '<div id="cl_theme_counter" class="cl_theme_counter" data-counter="'. esc_attr($counter) .'"><span class="cl_counter">'. esc_attr($counter) .'</span></div>';
            $html .= '</div>';
            $html .= '<input type="hidden" id="wpfd_selected_cl_themes" value="" />';
            $html .= '<input type="hidden" id="wpfd_cl_theme_counter" value="'. esc_attr($counter) .'" />';
            $html .= '</div>';

            return $html;
        }
    }
}
