<?php
/**
 * WP File Download
 *
 * @package WP File Download
 * @author  Joomunited
 * @version 1.0
 */

namespace Joomunited\WP_File_Download\Admin\Fields;

use Joomunited\WPFramework\v1_0_6\Field;
use Joomunited\WPFramework\v1_0_6\Application;
use Joomunited\WPFramework\v1_0_6\Model;

defined('ABSPATH') || die();

/**
 * Class CustomCSS
 */
class Customcss extends Field
{
    /**
     * Get field
     *
     * @param array $field Fields
     * @param array $data  Data from fields
     *
     * @return string
     */
    public function getfield($field, $data)
    {
        $attributes = $field['@attributes'];
        $cssContents = get_option('wpfd_custom_css_contents');

        if (is_null($cssContents) || !$cssContents || !is_string($cssContents) || empty($cssContents)) {
            $cssContents = esc_html__('/* Enter Your Custom CSS Here */', 'wpfd');
        }

        $html = '<div class="ju-settings-option ju-settings-custom-css-option full-width" style="padding: 0;">';
        $html .= '<div class="wpfd_row_full">';
        $html .= '<textarea cols="70" rows="30" name="custom_css_contents" class="custom_css_contents" id="custom_css_contents">';
        $html .= esc_attr($cssContents);
        $html .= '</textarea>';
        $html .= '</div>';
        $html .= '</div>';

        return $html;
    }
}
