<?php
/**
 * WP File Download
 *
 * @package WP File Download
 * @author  Joomunited
 * @version 1.0
 */

namespace Joomunited\WP_File_Download\Admin\Fields;

use Joomunited\WPFramework\v1_0_6\Field;
use Joomunited\WPFramework\v1_0_6\Application;
use Joomunited\WPFramework\v1_0_6\Model;

defined('ABSPATH') || die();

/**
 * Class Acf
 */
class FileCustomFields extends Field
{
    /**
     * Render <input> tag
     *
     * @param array $field Fields
     * @param array $data  Data
     *
     * @return string
     */
    public function getfield($field, $data)
    {
        Application::getInstance('Wpfd');
        $modelCategory = Model::getInstance('category');
        $modelConfig = Model::getInstance('config');
        $config = $modelConfig->getConfig();
        $attributes = $field['@attributes'];
        $className = '';

        if (isset($attributes['name'])) {
            $className = ' wpfd-field-'.$attributes['name'];
        }

        if (!isset($_POST['security']) || !wp_verify_nonce($_POST['security'], 'wpfd-security')) {
            wp_die(esc_html__('You don\'t have permission to perform this action!', 'wpfd'));
        }

        $fileInfo   = isset($_POST['fileInfo'][0]) ? $_POST['fileInfo'][0] : array();
        $fileId     = (is_array($fileInfo) && isset($fileInfo['fileId'])) ? $fileInfo['fileId'] : null;
        $categoryId = (is_array($fileInfo) && isset($fileInfo['catid'])) ? $fileInfo['catid'] : null;
        $html       = '';

        if (!empty($attributes['value'])) {
            $attributes['value'] = str_replace('\\', '', $attributes['value']);
        }

        if (function_exists('wpfdCheckInstallACFPlugins') && wpfdCheckInstallACFPlugins() && $fileId && is_numeric($fileId)) {
            $category = $modelCategory->getCategory($categoryId);
            $themeSettings = (isset($config['themesettings']) && intval($config['themesettings']) === 1) ? true : false;
            $themePerCategory = (isset($config['catparameters']) && intval($config['catparameters']) === 1) ? true : false;
            $defaultThemePerCategory = isset($config['defaultthemepercategory']) ? $config['defaultthemepercategory'] : 'default';
            $params = isset($category->params) ? (array) $category->params : array();

            if ($themeSettings) {
                $prefix = (isset($params['theme']) && strval($params['theme']) !== 'default') ? $params['theme'] . '_' : '';
                $acfGroup = isset($params[$prefix . 'groupcustomfields']) ? strval($params[$prefix . 'groupcustomfields']) : 'none';
                $showCustomFields = (isset($params[$prefix . 'showcustomfields']) && intval($params[$prefix . 'showcustomfields']) === 1) ? true : false;
            } else {
                if ($themePerCategory) {
                    $selectedTheme = isset($params['theme']) ? $params['theme'] : 'default';
                    $prefix = (isset($params['theme']) && strval($params['theme']) !== 'default') ? $params['theme'] . '_' : '';
                    $themeParams = get_option('_wpfd_' . $selectedTheme . '_config', array());
                    $acfGroup = isset($themeParams[$prefix . 'groupcustomfields']) ? strval($themeParams[$prefix . 'groupcustomfields']) : 'none';
                    $showCustomFields = (isset($themeParams[$prefix . 'showcustomfields']) && intval($themeParams[$prefix . 'showcustomfields']) === 1) ? true : false;
                } else {
                    $prefix = (strval($defaultThemePerCategory) !== 'default') ? $defaultThemePerCategory . '_' : '';
                    $themeParams = get_option('_wpfd_' . $defaultThemePerCategory . '_config', array());
                    $acfGroup = isset($themeParams[$prefix . 'groupcustomfields']) ? strval($themeParams[$prefix . 'groupcustomfields']) : 'none';
                    $showCustomFields = (isset($themeParams[$prefix . 'showcustomfields']) && intval($themeParams[$prefix . 'showcustomfields']) === 1) ? true : false;
                }
            }

            $formParams = array(
                'id' => 'wpfd_acf_form',
                'post_type' => 'wpfd_file',
                'post_title' => false,
                'post_content' => false,
                'form' => false,
                'field_el' => 'div',
                'submit_value' => __('Save fields', 'wpfd')
            );

            switch ($acfGroup) {
                case 'none':
                    $formParams = array();
                    break;
                case 'all_groups':
                    $formParams['post_id'] = $fileId;
                    break;
                default:
                    $validGroup = wpfdACFCheckValidGroup($acfGroup);
                    if ($validGroup === true) {
                        $formParams['post_id'] = $fileId;
                        $formParams['field_groups'] = array('key' => $acfGroup);
                    }
                    break;
            }

            if ($showCustomFields === false || $acfGroup === 'none') {
                $html = '';
            } else {
                $html = '<div class="ju-settings-option wpfd-custom-field-section full-width wpfd-tool-box' . $className . '">';
                $html .= '<div class="wpfd_row_full">';
                $html .= acf_form($formParams);
                $html .= '</div>';
                $html .= '</div>';
            }
        }

        return $html;
    }
}
